/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.client.http;

import java.net.URI;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.http.HttpEntity;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.entity.ByteArrayEntity;
import org.jfrog.client.http.QueryParamsBuilder;
import org.jfrog.client.http.RestRequest;

public class HttpRequest
extends HttpEntityEnclosingRequestBase {
    public static final String X_ORIGIN_USERNAME = "X-Origin-Username";
    public static final String X_ORIGIN_USER_ADDRESS = "X-Origin-User-Address";
    private final String method;

    HttpRequest(@Nonnull String method) {
        this.method = Objects.requireNonNull(method, "method is required").toUpperCase();
    }

    public String getMethod() {
        return this.method;
    }

    public static HttpRequestBase fromRestRequest(RestRequest originalReq, String baseUrl, RequestConfig defaultRequestConfig) {
        HttpRequest httpRequest = new HttpRequest(originalReq.getMethod());
        if (originalReq.getBody() != null) {
            httpRequest.setEntity((HttpEntity)new ByteArrayEntity(originalReq.getBody()));
        }
        httpRequest.setURI(HttpRequest.createUri(originalReq, baseUrl));
        HttpRequest.setTimeoutIfNeeded(httpRequest, defaultRequestConfig, originalReq::getSocketTimeout, (timeoout1, restConfigBuilder) -> restConfigBuilder.setSocketTimeout(timeoout1.intValue()));
        HttpRequest.setTimeoutIfNeeded(httpRequest, defaultRequestConfig, originalReq::getConnectTimeout, (timeoout1, restConfigBuilder) -> restConfigBuilder.setConnectTimeout(timeoout1.intValue()));
        originalReq.getHeaders().forEach(header -> httpRequest.addHeader((String)header.getKey(), (String)header.getValue()));
        return httpRequest;
    }

    private static void setTimeoutIfNeeded(HttpRequest httpRequest, RequestConfig defaultRequestConfig, Supplier<Integer> timeoutSupplier, BiFunction<Integer, RequestConfig.Builder, RequestConfig.Builder> configTimeoutSetter) {
        Integer timeoout = timeoutSupplier.get();
        if (timeoout == null || timeoout <= 0) {
            return;
        }
        if (defaultRequestConfig == null) {
            throw new IllegalStateException("Default request config must be provided when setting different timeout");
        }
        RequestConfig.Builder restConfigBuilder = RequestConfig.copy((RequestConfig)defaultRequestConfig);
        httpRequest.setConfig(configTimeoutSetter.apply(timeoout, restConfigBuilder).build());
    }

    private static URI createUri(RestRequest originalReq, String baseUrl) {
        Object uri = (String)(HttpRequest.isFullPath(originalReq) ? "" : baseUrl + "/") + StringUtils.removeStart((String)originalReq.getPath(), (String)"/");
        for (Pair<String, String> param : originalReq.getQueryParams()) {
            uri = QueryParamsBuilder.param((String)uri, (String)param.getKey(), param.getValue());
        }
        return URI.create((String)uri);
    }

    private static boolean isFullPath(RestRequest originalReq) {
        return originalReq.getPath().matches("^https?://.*");
    }
}

