/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.client.http.auth;

import java.io.IOException;
import org.apache.http.HttpException;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.auth.AuthScheme;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.AuthState;
import org.apache.http.auth.ChallengeState;
import org.apache.http.auth.Credentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.conn.routing.RouteInfo;
import org.apache.http.impl.auth.BasicScheme;
import org.apache.http.protocol.HttpContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProxyPreemptiveAuthInterceptor
implements HttpRequestInterceptor {
    private static final Logger log = LoggerFactory.getLogger(ProxyPreemptiveAuthInterceptor.class);

    public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
        HttpClientContext clientContext = HttpClientContext.adapt((HttpContext)context);
        AuthState proxyAuthState = clientContext.getProxyAuthState();
        if (proxyAuthState.getAuthScheme() == null) {
            CredentialsProvider credsProvider = clientContext.getCredentialsProvider();
            RouteInfo route = clientContext.getHttpRoute();
            if (route == null) {
                log.debug("No route found for {}", (Object)clientContext.getTargetHost());
                return;
            }
            HttpHost proxyHost = route.getProxyHost();
            if (proxyHost == null) {
                log.warn("No proxy host found in route {} for host {}", (Object)route, (Object)clientContext.getTargetHost());
                return;
            }
            Credentials creds = credsProvider.getCredentials(new AuthScope(proxyHost.getHostName(), proxyHost.getPort()));
            if (creds == null) {
                log.info("No credentials found for proxy: " + proxyHost);
                return;
            }
            proxyAuthState.update((AuthScheme)new BasicScheme(ChallengeState.PROXY), creds);
        }
    }
}

