package org.jfrog.client.http.model;

import org.apache.commons.lang.StringUtils;

import javax.annotation.Nullable;

/**
 * Denotes all required fields to configure a proxy for the http client.
 *
 * @author Dan Feldman
 */
public class ProxyConfig {

    private String host;
    private int port;
    private String username;
    private String password;
    private String ntHost;
    private String domain;
    /**
     * New line or comma separated host names that the proxy might redirect requests to.
     */
    private String redirectedToHosts;

    public String getHost() {
        return host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public int getPort() {
        return port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public String getUsername() {
        return username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getNtHost() {
        return ntHost;
    }

    public void setNtHost(String ntHost) {
        this.ntHost = ntHost;
    }

    public String getDomain() {
        return domain;
    }

    public void setDomain(String domain) {
        this.domain = domain;
    }

    /**
     * Returns new line or comma separated host names that the proxy might redirect requests to.
     * Use {@link ProxyConfig#getRedirectedToHostsList()} to get a list of host names.
     */
    @Nullable
    public String getRedirectedToHosts() {
        return redirectedToHosts;
    }

    @Nullable
    public String[] getRedirectedToHostsList() {
        // split by newline, space, comma or semi-colon
        return StringUtils.split(redirectedToHosts, "\n,; ");
    }

    public void setRedirectedToHosts(@Nullable String redirectedToHosts) {
        this.redirectedToHosts = StringUtils.trim(redirectedToHosts);
    }
}
