/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.build.extractor.nuget.extractor;

import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.jfrog.build.api.Build;
import org.jfrog.build.api.Dependency;
import org.jfrog.build.api.Module;
import org.jfrog.build.api.builder.DependencyBuilder;
import org.jfrog.build.api.builder.ModuleBuilder;
import org.jfrog.build.api.builder.ModuleType;
import org.jfrog.build.api.util.FileChecksumCalculator;
import org.jfrog.build.api.util.Log;
import org.jfrog.build.extractor.clientConfiguration.ArtifactoryClientConfiguration;
import org.jfrog.build.extractor.clientConfiguration.ArtifactoryDependenciesClientBuilder;
import org.jfrog.build.extractor.clientConfiguration.client.ArtifactoryBaseClient;
import org.jfrog.build.extractor.clientConfiguration.client.ArtifactoryDependenciesClient;
import org.jfrog.build.extractor.nuget.drivers.DotnetDriver;
import org.jfrog.build.extractor.nuget.drivers.NugetDriver;
import org.jfrog.build.extractor.nuget.drivers.ToolchainDriverBase;
import org.jfrog.build.extractor.nuget.types.NugetPackgesConfig;
import org.jfrog.build.extractor.nuget.types.NugetProjectAssets;
import org.jfrog.build.extractor.packageManager.PackageManagerExtractor;
import org.jfrog.build.extractor.packageManager.PackageManagerUtils;

public class NugetRun
extends PackageManagerExtractor {
    private static final String TEMP_DIR_PREFIX = "artifactory.plugin";
    private static final String NUGET_CONFIG_FILE_PREFIX = "artifactory.plugin.nuget.config";
    private static final String PACKAGES_CONFIG = "packages.config";
    private static final String PROJECT_ASSETS = "project.assets.json";
    private static final String PROJECT_ASSETS_DIR = "obj";
    private static final String CONFIG_FILE_FORMAT = "<?xml version=\"1.0\" encoding=\"utf-8\"?>\n<configuration>\n\t<packageSources>\n\t\t<add key=\"JFrogJenkins\" value=\"%s\" protocolVersion=\"%s\" />\n\t</packageSources>\n\t<packageSourceCredentials>\n\t\t<JFrogJenkins>\n\t\t\t<add key=\"Username\" value=\"%s\" />\n\t\t\t<add key=\"ClearTextPassword\" value=\"%s\" />\n\t\t</JFrogJenkins>\n\t</packageSourceCredentials>\n</configuration>";
    private static final String SOURCE_NAME = "BuildInfo.extractor.nuget";
    private static final String SLN_FILE_PARSING_REGEX = "^Project\\(\\\"(.*)";
    private static final String SHA1 = "SHA1";
    private static final String MD5 = "MD5";
    private static final String ABSENT_NUPKG_WARN_MSG = " Skipping adding this dependency to the build info. This might be because the package already exists in a different NuGet cache, possibly the SDK's NuGetFallbackFolder cache. Removing the package from this cache may resolve the issue.";
    private static final long serialVersionUID = 1L;
    private ArtifactoryDependenciesClientBuilder clientBuilder;
    private ToolchainDriverBase toolchainDriver;
    private Path workingDir;
    private Log logger;
    private Path path;
    private String resolutionRepo;
    private String username;
    private String password;
    private String apiProtocol;
    private String module;
    private String nugetCmdArgs;
    private List<String> dependenciesSources;
    private List<Module> modulesList = new ArrayList<Module>();

    public NugetRun(ArtifactoryDependenciesClientBuilder clientBuilder, String resolutionRepo, boolean useDotnetCli, String nugetCmdArgs, Log logger, Path path, Map<String, String> env, String module, String username, String password, String apiProtocol) {
        this.clientBuilder = clientBuilder;
        this.toolchainDriver = useDotnetCli ? new DotnetDriver(env, path, logger) : new NugetDriver(env, path, logger);
        this.workingDir = Files.isDirectory(path, new LinkOption[0]) ? path : path.toAbsolutePath().getParent();
        this.logger = logger;
        this.path = path;
        this.resolutionRepo = resolutionRepo;
        this.nugetCmdArgs = StringUtils.isBlank((CharSequence)nugetCmdArgs) ? "" : nugetCmdArgs;
        this.username = username;
        this.password = password;
        this.apiProtocol = apiProtocol;
        this.module = module;
    }

    private static String removeQuotes(String str) {
        if (str.startsWith("\"") && str.endsWith("\"")) {
            return str.substring(1, str.length() - 1);
        }
        return str;
    }

    protected static List<String> createAlternativeVersionForms(String originalVersion) {
        ArrayList<String> alternativeVersions = new ArrayList<String>();
        ArrayList<String> versionParts = new ArrayList<String>();
        Collections.addAll(versionParts, originalVersion.split("\\."));
        while (versionParts.size() < 4) {
            versionParts.add("0");
        }
        for (int i = 4; i > 0; --i) {
            String version = String.join((CharSequence)".", versionParts.subList(0, i));
            if (!version.equals(originalVersion)) {
                alternativeVersions.add(version);
            }
            if (version.endsWith(".0")) continue;
            return alternativeVersions;
        }
        return alternativeVersions;
    }

    public static void main(String[] ignored) {
        try {
            ArtifactoryClientConfiguration clientConfiguration = PackageManagerUtils.createArtifactoryClientConfiguration();
            ArtifactoryDependenciesClientBuilder clientBuilder = (ArtifactoryDependenciesClientBuilder)new ArtifactoryDependenciesClientBuilder().setClientConfiguration(clientConfiguration, (ArtifactoryClientConfiguration.RepositoryConfiguration)clientConfiguration.resolver);
            ArtifactoryClientConfiguration.PackageManagerHandler handler = clientConfiguration.packageManagerHandler;
            NugetRun nugetRun = new NugetRun(clientBuilder, clientConfiguration.resolver.getRepoKey(), clientConfiguration.dotnetHandler.useDotnetCoreCli(), handler.getArgs(), clientConfiguration.getLog(), Paths.get(handler.getPath() != null ? handler.getPath() : ".", new String[0]), clientConfiguration.getAllProperties(), handler.getModule(), clientConfiguration.resolver.getUsername(), clientConfiguration.resolver.getPassword(), clientConfiguration.dotnetHandler.apiProtocol());
            nugetRun.executeAndSaveBuildInfo(clientConfiguration);
        }
        catch (RuntimeException e) {
            ExceptionUtils.printRootCauseStackTrace((Throwable)e, (PrintStream)System.out);
            System.exit(1);
        }
    }

    public Build execute() {
        Build build = null;
        try {
            this.prepareAndRunCmd();
            if (!StringUtils.isBlank((CharSequence)this.module)) {
                ModuleBuilder builder = new ModuleBuilder().type(ModuleType.NUGET).id(this.module);
                this.modulesList.add(builder.build());
            }
            this.collectDependencies();
            build = new Build();
            build.setModules(this.modulesList);
        }
        catch (Exception e) {
            this.logger.error(e.getMessage(), (Throwable)e);
            throw new RuntimeException(e);
        }
        return build;
    }

    private void prepareAndRunCmd() throws Exception {
        try (ArtifactoryDependenciesClient artifactoryClient = this.clientBuilder.build();){
            ArrayList<String> extraArgs = new ArrayList<String>();
            File configFile = this.prepareConfig(artifactoryClient);
            if (configFile != null) {
                String configPath = configFile.getAbsolutePath();
                extraArgs = StringUtils.isBlank((CharSequence)configPath) ? null : Arrays.asList(this.toolchainDriver.getFlagSyntax("configfile"), configPath);
            }
            this.toolchainDriver.runCmd(this.nugetCmdArgs, extraArgs, null, true);
        }
    }

    private File prepareConfig(ArtifactoryDependenciesClient client) throws Exception {
        File configFile = null;
        if (!this.nugetCmdArgs.contains(this.toolchainDriver.getFlagSyntax("configfile")) && !this.nugetCmdArgs.contains(this.toolchainDriver.getFlagSyntax("source"))) {
            configFile = File.createTempFile(NUGET_CONFIG_FILE_PREFIX, null);
            configFile.deleteOnExit();
            this.addSourceToConfigFile(configFile.getAbsolutePath(), client, this.resolutionRepo, this.username, this.password, this.apiProtocol);
        }
        return configFile;
    }

    private void addSourceToConfigFile(String configPath, ArtifactoryDependenciesClient client, String repo, String username, String password, String apiProtocol) throws Exception {
        String sourceUrl = this.toolchainDriver.buildNugetSourceUrl((ArtifactoryBaseClient)client, repo, apiProtocol);
        String protocolVersion = apiProtocol.substring(apiProtocol.length() - 1);
        String configFileText = String.format(CONFIG_FILE_FORMAT, sourceUrl, protocolVersion, username, password);
        try (PrintWriter out = new PrintWriter(configPath);){
            out.println(configFileText);
        }
    }

    File getProjectRootPath() throws IOException {
        File projectPath = this.workingDir.toFile();
        String[] args = this.nugetCmdArgs.split(" ");
        if (args.length > 1 && !StringUtils.startsWith((CharSequence)args[1], (CharSequence)"-") && !(projectPath = new File(args[1])).isAbsolute()) {
            projectPath = new File(FilenameUtils.concat((String)this.workingDir.toString(), (String)args[1]));
        }
        if (projectPath.exists()) {
            if (projectPath.isFile()) {
                return projectPath;
            }
            return this.findProjectPathInDir(projectPath);
        }
        return null;
    }

    private File findProjectPathInDir(File projectPathRoot) {
        File[] slnFiles = projectPathRoot.listFiles((dir, name) -> name.toLowerCase().endsWith(".sln"));
        if (slnFiles.length == 1) {
            return slnFiles[0];
        }
        File[] pkgsConfig = projectPathRoot.listFiles((dir, name) -> name.toLowerCase().endsWith(PACKAGES_CONFIG));
        if (pkgsConfig.length == 1) {
            return pkgsConfig[0];
        }
        File[] csprojFiles = projectPathRoot.listFiles((dir, name) -> name.toLowerCase().endsWith(".csproj"));
        if (csprojFiles.length == 1) {
            return csprojFiles[0];
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private List<String> findDependenciesSources(Path rootDir) {
        try (Stream<Path> walk = Files.walk(rootDir, new FileVisitOption[0]);){
            List<String> result;
            Predicate<String> assetsJson = p -> p.endsWith(PROJECT_ASSETS);
            Predicate<String> packagesConfig = p -> p.endsWith(PACKAGES_CONFIG);
            List<String> list = result = walk.map(x -> x.toString()).filter(assetsJson.or(packagesConfig)).collect(Collectors.toList());
            return list;
        }
        catch (IOException e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    private void collectDependencies() throws Exception {
        this.dependenciesSources = this.findDependenciesSources(this.workingDir);
        File projectPathRoot = this.getProjectRootPath();
        if (projectPathRoot.toString().endsWith(".sln")) {
            this.collectDependenciesFromSln(projectPathRoot);
            return;
        }
        this.collectDependenciesFromProjectDir(projectPathRoot.getParentFile());
    }

    private void collectDependenciesFromSln(File slnFile) throws IOException, InterruptedException {
        Pattern pattern = Pattern.compile(SLN_FILE_PARSING_REGEX);
        String globalCachePath = this.toolchainDriver.globalPackagesCache();
        try (Stream<String> lines = Files.lines(slnFile.toPath());){
            lines.filter(pattern.asPredicate()).forEach(line -> {
                try {
                    this.projectLineHandler((String)line, slnFile.getParentFile(), globalCachePath);
                }
                catch (Exception e) {
                    throw new RuntimeException(e.getMessage());
                }
            });
        }
    }

    private void collectDependenciesFromProjectDir(File projectRoot) throws Exception {
        List csprojFiles = Files.list(projectRoot.toPath()).filter(path -> path.toString().endsWith(".csproj")).collect(Collectors.toList());
        if (csprojFiles.size() == 1) {
            String csprojPath = ((Path)csprojFiles.get(0)).toString();
            String projectName = ((Path)csprojFiles.get(0)).getFileName().toString().replace(".csproj", "");
            String globalCachePath = this.toolchainDriver.globalPackagesCache();
            this.singleProjectHandler(projectName, csprojPath, globalCachePath);
        }
    }

    private void projectLineHandler(String line, File slnRootDir, String globalCachePath) throws Exception {
        String[] projectDetails = line.split("=")[1].split(",");
        String projectName = NugetRun.removeQuotes(projectDetails[0].trim());
        String csprojPath = FilenameUtils.separatorsToSystem((String)NugetRun.removeQuotes(projectDetails[1].trim()));
        if (!csprojPath.endsWith(".csproj")) {
            this.logger.debug("Skipping project " + projectName + ", since it doesn't have a csproj file path.");
            return;
        }
        String csprojFullPath = new File(slnRootDir, csprojPath).getPath();
        this.singleProjectHandler(projectName, csprojFullPath, globalCachePath);
    }

    private void singleProjectHandler(String projectName, String csprojPath, String globalCachePath) throws Exception {
        String dependenciesSource = this.getDependenciesSource(projectName, csprojPath);
        if (StringUtils.isEmpty((CharSequence)dependenciesSource)) {
            this.logger.debug("Project dependencies was not found for project: " + projectName);
            return;
        }
        List<Object> dependencies = new ArrayList();
        if (dependenciesSource.endsWith(PACKAGES_CONFIG)) {
            dependencies = this.collectDependenciesFromPackagesConfig(dependenciesSource, globalCachePath);
        } else if (dependenciesSource.endsWith(PROJECT_ASSETS)) {
            dependencies = this.collectDependenciesFromProjectAssets(dependenciesSource);
        }
        Module projectModule = new ModuleBuilder().type(ModuleType.NUGET).id(projectName).dependencies(dependencies).build();
        if (StringUtils.isBlank((CharSequence)this.module)) {
            this.modulesList.add(projectModule);
        } else {
            this.modulesList.get(0).append(projectModule);
        }
    }

    private String getDependenciesSource(String projectName, String csprojPath) {
        Path projectRootPath = Paths.get(csprojPath, new String[0]).getParent().normalize();
        String projectNamePattern = File.separator + projectName + File.separator;
        String projectPathPattern = projectRootPath + File.separator + PROJECT_ASSETS_DIR + File.separator;
        for (String source : this.dependenciesSources) {
            Path sourceRootPath = Paths.get(source, new String[0]).getParent().normalize();
            if (!sourceRootPath.equals(projectRootPath) && !source.contains(projectNamePattern) && !source.contains(projectPathPattern)) continue;
            return source;
        }
        return "";
    }

    private List<Dependency> collectDependenciesFromPackagesConfig(String packagesConfigPath, String globalCachePath) throws Exception {
        File packagesConfig = new File(packagesConfigPath);
        NugetPackgesConfig config = new NugetPackgesConfig();
        config.readPackageConfig(packagesConfig);
        ArrayList<Dependency> dependenciesList = new ArrayList<Dependency>();
        for (NugetPackgesConfig.ConfigPackage pkg : config.getPackages()) {
            Dependency pkgDependency = this.createDependency(pkg, globalCachePath);
            if (pkgDependency == null) {
                this.logger.warn(String.format("The following NuGet package %s with version %s was not found in the NuGet cache %s.%s", pkg.getId(), pkg.getVersion(), globalCachePath, ABSENT_NUPKG_WARN_MSG));
                continue;
            }
            dependenciesList.add(pkgDependency);
        }
        return dependenciesList;
    }

    private Dependency createDependency(NugetPackgesConfig.ConfigPackage pkg, String globalCachePath) throws IOException, NoSuchAlgorithmException {
        boolean found = true;
        File nupkg = this.createNupkgFile(pkg.getId(), pkg.getVersion(), globalCachePath);
        if (!nupkg.exists()) {
            found = false;
            for (String v : NugetRun.createAlternativeVersionForms(pkg.getVersion())) {
                nupkg = this.createNupkgFile(pkg.getId(), v, globalCachePath);
                if (!nupkg.exists()) continue;
                found = true;
                break;
            }
        }
        if (found) {
            Map checksums = FileChecksumCalculator.calculateChecksums((File)nupkg, (String[])new String[]{MD5, SHA1});
            Dependency dependency = new DependencyBuilder().id(pkg.getId() + ':' + pkg.getVersion()).md5((String)checksums.get(MD5)).sha1((String)checksums.get(SHA1)).build();
            return dependency;
        }
        return null;
    }

    private File createNupkgFile(String id, String version, String cachePath) {
        String nupkgFileName = id + "." + version + ".nupkg";
        String nupkgBasePath = FilenameUtils.concat((String)FilenameUtils.concat((String)cachePath, (String)id), (String)version);
        return new File(nupkgBasePath, nupkgFileName);
    }

    private List<Dependency> collectDependenciesFromProjectAssets(String projectAssetsPath) throws Exception {
        File projectAssets = new File(projectAssetsPath);
        ArrayList<Dependency> dependenciesList = new ArrayList<Dependency>();
        NugetProjectAssets assets = new NugetProjectAssets();
        assets.readProjectAssets(projectAssets);
        for (Map.Entry<String, NugetProjectAssets.Library> entry : assets.getLibraries().entrySet()) {
            String pkgKey = entry.getKey();
            NugetProjectAssets.Library library = entry.getValue();
            if (library.getType().equals("project")) continue;
            File nupkg = new File(assets.getPackagesPath(), library.getNupkgFilePath());
            if (nupkg.exists()) {
                Map checksums = FileChecksumCalculator.calculateChecksums((File)nupkg, (String[])new String[]{MD5, SHA1});
                Dependency dependency = new DependencyBuilder().id(pkgKey.replace('/', ':')).md5((String)checksums.get(MD5)).sha1((String)checksums.get(SHA1)).build();
                dependenciesList.add(dependency);
                continue;
            }
            if (this.isPackagePartOfTargetDependencies(library.getPath(), assets.getTargets())) {
                this.logger.warn(String.format("The file %s doesn't exist in the NuGet cache directory but it does exist as a target in the assets files. %s", nupkg.getPath(), ABSENT_NUPKG_WARN_MSG));
                continue;
            }
            throw new Exception(String.format("The file %s doesn't exist in the NuGet cache directory.", nupkg.getPath()));
        }
        return dependenciesList;
    }

    private boolean isPackagePartOfTargetDependencies(String dependencyId, Map<String, Map<String, NugetProjectAssets.TargetDependency>> targets) {
        String dependencyName = dependencyId.split("/")[0];
        for (Map<String, NugetProjectAssets.TargetDependency> dependencies : targets.values()) {
            for (String dependencyKey : dependencies.keySet()) {
                if (!dependencyName.equalsIgnoreCase(dependencyKey)) continue;
                return true;
            }
        }
        return false;
    }
}

