/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.build.extractor.npm.types;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.jfrog.build.api.producerConsumer.ProducerConsumerItem;
import org.jfrog.build.extractor.BuildInfoExtractorUtils;

public class NpmPackageInfo
implements Serializable,
ProducerConsumerItem {
    private static final long serialVersionUID = 1L;
    private String name;
    private String version;
    private String scope;
    private String[] pathToRoot;

    public NpmPackageInfo() {
    }

    public NpmPackageInfo(String name, String version, String scope, String[] pathToRoot) {
        this.name = name;
        this.version = version;
        this.scope = scope;
        this.pathToRoot = pathToRoot;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getScope() {
        return this.scope;
    }

    public void setScope(String scope) {
        this.scope = scope;
    }

    void splitScopeFromName() {
        if (StringUtils.startsWith((CharSequence)this.name, (CharSequence)"@") && StringUtils.contains((CharSequence)this.name, (CharSequence)"/")) {
            String[] splitValues = StringUtils.split((String)this.name, (String)"/");
            this.scope = splitValues[0];
            this.name = splitValues[1];
        }
    }

    public void readPackageInfo(InputStream inputStream) throws IOException {
        ObjectMapper mapper = BuildInfoExtractorUtils.createMapper();
        NpmPackageInfo npmPackageInfo = (NpmPackageInfo)mapper.readValue(inputStream, NpmPackageInfo.class);
        this.setVersion(npmPackageInfo.getVersion());
        this.setName(npmPackageInfo.getName());
        this.splitScopeFromName();
        this.setPathToRoot(npmPackageInfo.getPathToRoot());
    }

    public String getModuleId() {
        String nameBase = String.format("%s:%s", this.name, this.version);
        if (StringUtils.isBlank((CharSequence)this.scope)) {
            return nameBase;
        }
        return String.format("%s:%s", this.scope.replaceFirst("^@", ""), nameBase);
    }

    public String getDeployPath() {
        String deployPath = String.format("%s/-/%s-%s.tgz", this.name, this.name, this.version);
        if (StringUtils.isBlank((CharSequence)this.scope)) {
            return deployPath;
        }
        return String.format("%s/%s", this.scope, deployPath);
    }

    public boolean equals(Object obj) {
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        NpmPackageInfo other = (NpmPackageInfo)obj;
        return Objects.equals(this.name, other.getName()) && Objects.equals(this.version, other.getVersion()) && Objects.equals(this.scope, other.getScope());
    }

    public int hashCode() {
        return Objects.hash(this.name, this.version, this.scope);
    }

    public String toString() {
        return this.name + ":" + this.version;
    }

    public String[] getPathToRoot() {
        return this.pathToRoot;
    }

    public void setPathToRoot(String[] pathToRoot) {
        this.pathToRoot = pathToRoot;
    }
}

