/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.build.extractor.npm.extractor;

import java.io.IOException;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.jfrog.build.api.producerConsumer.ProducerConsumerItem;
import org.jfrog.build.api.search.AqlSearchResult;
import org.jfrog.build.api.util.Log;
import org.jfrog.build.extractor.builder.DependencyBuilder;
import org.jfrog.build.extractor.ci.Dependency;
import org.jfrog.build.extractor.clientConfiguration.client.artifactory.ArtifactoryManager;
import org.jfrog.build.extractor.npm.types.NpmPackageInfo;
import org.jfrog.build.extractor.producerConsumer.ConsumerRunnableBase;
import org.jfrog.build.extractor.producerConsumer.ProducerConsumerExecutor;

public class NpmExtractorConsumer
extends ConsumerRunnableBase {
    private static final String NPM_AQL_FORMAT = "items.find({\"@npm.name\": \"%s\",\"@npm.version\": \"%s\"}).include(\"name\", \"repo\", \"path\", \"actual_sha1\", \"actual_md5\")";
    private Map<String, Dependency> previousBuildDependencies;
    private final ArtifactoryManager artifactoryManager;
    private Map<String, Dependency> dependencies;
    private ProducerConsumerExecutor executor;
    private Set<NpmPackageInfo> badPackages;
    private Log log;

    NpmExtractorConsumer(ArtifactoryManager artifactoryManager, Map<String, Dependency> dependencies, Map<String, Dependency> previousBuildDependencies, Set<NpmPackageInfo> badPackages) {
        this.artifactoryManager = artifactoryManager;
        this.dependencies = dependencies;
        this.previousBuildDependencies = previousBuildDependencies;
        this.badPackages = badPackages;
    }

    public void consumerRun() {
        while (!Thread.interrupted()) {
            try {
                ProducerConsumerItem item = this.executor.take();
                if (item == this.executor.TERMINATE) {
                    this.executor.put(item);
                    break;
                }
                NpmPackageInfo npmPackageInfo = (NpmPackageInfo)item;
                if (this.appendDependency(npmPackageInfo)) continue;
                this.badPackages.add(npmPackageInfo);
            }
            catch (InterruptedException e) {
                return;
            }
        }
    }

    private boolean appendDependency(NpmPackageInfo npmPackageInfo) {
        String id = npmPackageInfo.getName() + ":" + npmPackageInfo.getVersion();
        Dependency dependency = this.dependencies.get(id);
        if (dependency == null) {
            dependency = this.createDependency(npmPackageInfo, id);
            if (dependency == null) {
                return false;
            }
            this.dependencies.put(id, dependency);
        } else {
            dependency.getScopes().add(npmPackageInfo.getScope());
        }
        dependency.addRequestedBy(npmPackageInfo.getPathToRoot());
        return true;
    }

    private Dependency createDependency(NpmPackageInfo npmPackageInfo, String id) {
        Dependency previousDependency = this.previousBuildDependencies.get(id);
        if (previousDependency != null) {
            return this.createDependencyFromPreviousBuild(npmPackageInfo, previousDependency);
        }
        return this.createDependencyFromAqlResult(npmPackageInfo, id);
    }

    private Dependency createDependencyFromAqlResult(NpmPackageInfo npmPackageInfo, String id) {
        String aql = String.format(NPM_AQL_FORMAT, npmPackageInfo.getName(), npmPackageInfo.getVersion());
        try {
            AqlSearchResult searchResult = this.artifactoryManager.searchArtifactsByAql(aql);
            if (searchResult.getResults().isEmpty()) {
                return null;
            }
            DependencyBuilder builder = new DependencyBuilder();
            AqlSearchResult.SearchEntry searchEntry = (AqlSearchResult.SearchEntry)searchResult.getResults().get(0);
            return builder.id(id).addScope(npmPackageInfo.getScope()).md5(searchEntry.getActualMd5()).sha1(searchEntry.getActualSha1()).build();
        }
        catch (IOException e) {
            this.log.error(ExceptionUtils.getStackTrace((Throwable)e), (Throwable)e);
            return null;
        }
    }

    private Dependency createDependencyFromPreviousBuild(NpmPackageInfo npmPackageInfo, Dependency previousDependency) {
        return new DependencyBuilder().id(previousDependency.getId()).sha1(previousDependency.getSha1()).md5(previousDependency.getMd5()).addScope(npmPackageInfo.getScope()).build();
    }

    public void setExecutor(ProducerConsumerExecutor executor) {
        this.executor = executor;
    }

    public void setLog(Log log) {
        this.log = log;
    }
}

