/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.build.extractor.npm.extractor;

import com.fasterxml.jackson.databind.JsonNode;
import java.io.BufferedWriter;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Scanner;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiConsumer;
import javax.swing.tree.DefaultMutableTreeNode;
import org.apache.commons.lang3.StringUtils;
import org.jfrog.build.api.Build;
import org.jfrog.build.api.Dependency;
import org.jfrog.build.api.Module;
import org.jfrog.build.api.builder.ModuleBuilder;
import org.jfrog.build.api.builder.ModuleType;
import org.jfrog.build.api.util.Log;
import org.jfrog.build.client.ProxyConfiguration;
import org.jfrog.build.extractor.BuildInfoExtractor;
import org.jfrog.build.extractor.clientConfiguration.ArtifactoryManagerBuilder;
import org.jfrog.build.extractor.clientConfiguration.client.artifactory.ArtifactoryManager;
import org.jfrog.build.extractor.npm.NpmDriver;
import org.jfrog.build.extractor.npm.extractor.NpmDependencyTree;
import org.jfrog.build.extractor.npm.extractor.NpmExtractorConsumer;
import org.jfrog.build.extractor.npm.extractor.NpmExtractorProducer;
import org.jfrog.build.extractor.npm.types.NpmPackageInfo;
import org.jfrog.build.extractor.npm.types.NpmProject;
import org.jfrog.build.extractor.npm.types.NpmScope;
import org.jfrog.build.extractor.producerConsumer.ConsumerRunnableBase;
import org.jfrog.build.extractor.producerConsumer.ProducerConsumerExecutor;
import org.jfrog.build.extractor.producerConsumer.ProducerRunnableBase;
import org.jfrog.build.extractor.scan.DependencyTree;

public class NpmBuildInfoExtractor
implements BuildInfoExtractor<NpmProject> {
    private static final String NPMRC_BACKUP_FILE_NAME = "jfrog.npmrc.backup";
    private static final String NPMRC_FILE_NAME = ".npmrc";
    private final ArtifactoryManagerBuilder artifactoryManagerBuilder;
    private NpmPackageInfo npmPackageInfo = new NpmPackageInfo();
    private TypeRestriction typeRestriction;
    private NpmDriver npmDriver;
    private String npmRegistry;
    private Properties npmAuth;
    private String buildName;
    private final String project;
    private String npmProxy;
    private String module;
    private Log logger;

    NpmBuildInfoExtractor(ArtifactoryManagerBuilder artifactoryManagerBuilder, NpmDriver npmDriver, Log logger, String module, String buildName, String project) {
        this.artifactoryManagerBuilder = artifactoryManagerBuilder;
        this.npmDriver = npmDriver;
        this.logger = logger;
        this.module = module;
        this.buildName = buildName;
        this.project = project;
        this.typeRestriction = TypeRestriction.DEFAULT_RESTRICTION;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Build extract(NpmProject npmProject) throws Exception {
        String resolutionRepository = npmProject.getResolutionRepository();
        List<String> commandArgs = npmProject.getCommandArgs();
        Path workingDir = npmProject.getWorkingDir();
        this.preparePrerequisites(resolutionRepository, workingDir);
        this.createTempNpmrc(workingDir, commandArgs);
        try {
            if (npmProject.isCiCommand()) {
                this.runCi(workingDir, commandArgs);
            } else {
                this.runInstall(workingDir, commandArgs);
            }
        }
        finally {
            this.restoreNpmrc(workingDir);
        }
        List<Dependency> dependencies = this.collectDependencies(workingDir);
        String moduleId = StringUtils.isNotBlank((CharSequence)this.module) ? this.module : this.npmPackageInfo.toString();
        return this.createBuild(dependencies, moduleId);
    }

    private void preparePrerequisites(String resolutionRepository, Path workingDir) throws IOException {
        try (ArtifactoryManager artifactoryManager = this.artifactoryManagerBuilder.build();){
            this.setNpmAuth(artifactoryManager);
            this.setRegistryUrl(artifactoryManager, resolutionRepository);
            this.setNpmProxy(artifactoryManager);
        }
        this.readPackageInfoFromPackageJson(workingDir);
        this.backupProjectNpmrc(workingDir);
    }

    private void setNpmAuth(ArtifactoryManager artifactoryManage) throws IOException {
        this.npmAuth = artifactoryManage.getNpmAuth();
    }

    private void setRegistryUrl(ArtifactoryManager artifactoryManage, String resolutionRepository) {
        this.npmRegistry = artifactoryManage.getUrl();
        if (!StringUtils.endsWith((CharSequence)this.npmRegistry, (CharSequence)"/")) {
            this.npmRegistry = this.npmRegistry + "/";
        }
        this.npmRegistry = this.npmRegistry + "api/npm/" + resolutionRepository;
    }

    private void setNpmProxy(ArtifactoryManager artifactoryManage) {
        ProxyConfiguration proxyConfiguration = artifactoryManage.getProxyConfiguration();
        if (proxyConfiguration == null || StringUtils.isBlank((CharSequence)proxyConfiguration.host)) {
            return;
        }
        this.npmProxy = "http://";
        String username = proxyConfiguration.username;
        String password = proxyConfiguration.password;
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{username}) && StringUtils.isNotBlank((CharSequence)password)) {
            this.npmProxy = this.npmProxy + username + ":" + password + "@";
        }
        this.npmProxy = this.npmProxy + proxyConfiguration.host + ":" + proxyConfiguration.port;
    }

    private void readPackageInfoFromPackageJson(Path workingDir) throws IOException {
        try (FileInputStream fis = new FileInputStream(workingDir.resolve("package.json").toFile());){
            this.npmPackageInfo.readPackageInfo(fis);
        }
    }

    private void backupProjectNpmrc(Path workingDir) throws IOException {
        Path npmrcPath = workingDir.resolve(NPMRC_FILE_NAME);
        if (!Files.exists(npmrcPath, new LinkOption[0])) {
            return;
        }
        Path npmrcBackupPath = workingDir.resolve(NPMRC_BACKUP_FILE_NAME);
        Files.copy(npmrcPath, npmrcBackupPath, StandardCopyOption.COPY_ATTRIBUTES, StandardCopyOption.REPLACE_EXISTING);
    }

    private void createTempNpmrc(Path workingDir, List<String> commandArgs) throws IOException, InterruptedException {
        String configList = this.npmDriver.configList(workingDir.toFile(), commandArgs, this.logger);
        Path npmrcPath = workingDir.resolve(NPMRC_FILE_NAME);
        Files.deleteIfExists(npmrcPath);
        StringBuilder npmrcBuilder = new StringBuilder();
        try (Scanner configScanner = new Scanner(configList);){
            while (configScanner.hasNextLine()) {
                String[] splitOption;
                String currOption = configScanner.nextLine();
                if (StringUtils.isBlank((CharSequence)currOption) || (splitOption = currOption.split("=", 2)).length < 2) continue;
                String key2 = splitOption[0].trim();
                if (NpmBuildInfoExtractor.isValidKey(key2)) {
                    String value2 = splitOption[1].trim();
                    if (value2.startsWith("[") && value2.endsWith("]")) {
                        NpmBuildInfoExtractor.addArrayConfigs(npmrcBuilder, key2, value2);
                    } else {
                        npmrcBuilder.append(currOption).append("\n");
                    }
                    this.setTypeRestriction(key2, value2);
                    continue;
                }
                if (!key2.startsWith("@")) continue;
                npmrcBuilder.append(key2).append(" = ").append(this.npmRegistry).append("\n");
            }
        }
        boolean isJsonOutputRequired = this.npmDriver.isJson(workingDir.toFile(), commandArgs);
        npmrcBuilder.append("json = ").append(isJsonOutputRequired).append("\n");
        npmrcBuilder.append("registry = ").append(this.npmRegistry).append("\n");
        if (StringUtils.isNotBlank((CharSequence)this.npmProxy)) {
            npmrcBuilder.append("proxy = ").append(this.npmProxy).append("\n");
        }
        this.npmAuth.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(key, value) -> npmrcBuilder.append(key).append("=").append(value).append("\n")));
        try (FileWriter fileWriter = new FileWriter(npmrcPath.toFile());
             BufferedWriter bufferedWriter = new BufferedWriter(fileWriter);){
            bufferedWriter.write(npmrcBuilder.toString());
            bufferedWriter.flush();
        }
    }

    private static void addArrayConfigs(StringBuilder npmrcBuilder, String key, String arrayValue) {
        String[] separatedValues;
        if (arrayValue.equals("[]")) {
            return;
        }
        String valuesString = arrayValue.substring(1, arrayValue.length() - 1);
        for (String val : separatedValues = valuesString.split(",")) {
            npmrcBuilder.append(key).append("[] = ").append(val).append("\n");
        }
    }

    private static boolean isValidKey(String key) {
        return !key.startsWith("//") && !key.startsWith(";") && !key.startsWith("@") && !key.equals("registry") && !key.equals("metrics-registry") && !key.equals("json");
    }

    TypeRestriction getTypeRestriction() {
        return this.typeRestriction;
    }

    void setTypeRestriction(String key, String value) {
        if (key.equals("omit")) {
            this.typeRestriction = StringUtils.contains((CharSequence)value, (CharSequence)"dev") ? TypeRestriction.PROD_ONLY : TypeRestriction.ALL;
        } else if (this.typeRestriction == TypeRestriction.DEFAULT_RESTRICTION) {
            if (key.equals("only")) {
                if (StringUtils.startsWith((CharSequence)value, (CharSequence)"prod")) {
                    this.typeRestriction = TypeRestriction.PROD_ONLY;
                } else if (StringUtils.startsWith((CharSequence)value, (CharSequence)"dev")) {
                    this.typeRestriction = TypeRestriction.DEV_ONLY;
                }
            } else if (key.equals("production") && value.equals("true")) {
                this.typeRestriction = TypeRestriction.PROD_ONLY;
            }
        }
    }

    private void runInstall(Path workingDir, List<String> installationArgs) throws IOException {
        this.logger.info(this.npmDriver.install(workingDir.toFile(), installationArgs, this.logger));
    }

    private void runCi(Path workingDir, List<String> installationArgs) throws IOException {
        this.logger.info(this.npmDriver.ci(workingDir.toFile(), installationArgs, this.logger));
    }

    private void restoreNpmrc(Path workingDir) throws IOException {
        Path npmrcPath = workingDir.resolve(NPMRC_FILE_NAME);
        Path npmrcBackupPath = workingDir.resolve(NPMRC_BACKUP_FILE_NAME);
        if (Files.exists(npmrcBackupPath, new LinkOption[0])) {
            Files.move(npmrcBackupPath, npmrcPath, StandardCopyOption.REPLACE_EXISTING);
        } else {
            Files.deleteIfExists(npmrcPath);
        }
    }

    private List<Dependency> collectDependencies(Path workingDir) throws Exception {
        ConcurrentHashMap<String, Dependency> dependencies = new ConcurrentHashMap<String, Dependency>();
        List<NpmScope> scopes = this.getNpmScopes();
        if (scopes.isEmpty()) {
            return new ArrayList<Dependency>();
        }
        for (NpmScope scope : scopes) {
            ArrayList<String> extraListArgs = new ArrayList<String>();
            extraListArgs.add("--" + (Object)((Object)scope));
            JsonNode jsonNode = this.npmDriver.list(workingDir.toFile(), extraListArgs);
            this.populateDependenciesMap(dependencies, this.getDependenciesMapFromLatestBuild(), jsonNode, scope);
        }
        return new ArrayList<Dependency>(dependencies.values());
    }

    private List<NpmScope> getNpmScopes() {
        ArrayList<NpmScope> scopes = new ArrayList<NpmScope>();
        if (this.typeRestriction != TypeRestriction.PROD_ONLY) {
            scopes.add(NpmScope.DEVELOPMENT);
        }
        if (this.typeRestriction != TypeRestriction.DEV_ONLY) {
            scopes.add(NpmScope.PRODUCTION);
        }
        return scopes;
    }

    private Build createBuild(List<Dependency> dependencies, String moduleId) {
        Module module = new ModuleBuilder().type(ModuleType.NPM).id(moduleId).dependencies(dependencies).build();
        ArrayList<Module> modules = new ArrayList<Module>();
        modules.add(module);
        Build build = new Build();
        build.setModules(modules);
        return build;
    }

    private void populateDependenciesMap(Map<String, Dependency> dependencies, Map<String, Dependency> previousBuildDependencies, JsonNode npmDependencyTree, NpmScope scope) throws Exception {
        Set<NpmPackageInfo> badPackages = Collections.synchronizedSet(new HashSet());
        DependencyTree rootNode = NpmDependencyTree.createDependencyTree(npmDependencyTree, scope);
        try (ArtifactoryManager artifactoryManager = this.artifactoryManagerBuilder.build();){
            ProducerRunnableBase[] producerRunnable = new ProducerRunnableBase[]{new NpmExtractorProducer((DefaultMutableTreeNode)rootNode)};
            ConsumerRunnableBase[] consumerRunnables = new ConsumerRunnableBase[]{new NpmExtractorConsumer(artifactoryManager, dependencies, previousBuildDependencies, badPackages), new NpmExtractorConsumer(artifactoryManager, dependencies, previousBuildDependencies, badPackages), new NpmExtractorConsumer(artifactoryManager, dependencies, previousBuildDependencies, badPackages)};
            ProducerConsumerExecutor deploymentExecutor = new ProducerConsumerExecutor(this.logger, producerRunnable, consumerRunnables, 10);
            deploymentExecutor.start();
            if (!badPackages.isEmpty()) {
                this.logger.info(Arrays.toString(badPackages.toArray()));
                this.logger.info("The npm dependencies above could not be found in Artifactory and therefore are not included in the build-info. Make sure the dependencies are available in Artifactory for this build. Deleting the local cache will force populating Artifactory with these dependencies.");
            }
        }
    }

    private Map<String, Dependency> getDependenciesMapFromLatestBuild() throws IOException {
        if (StringUtils.isBlank((CharSequence)this.buildName)) {
            return Collections.emptyMap();
        }
        try (ArtifactoryManager artifactoryManager = this.artifactoryManagerBuilder.build();){
            Build previousBuildInfo = artifactoryManager.getBuildInfo(this.buildName, "LATEST", this.project);
            if (previousBuildInfo == null) {
                Map<String, Dependency> map = Collections.emptyMap();
                return map;
            }
            Map<String, Dependency> map = NpmBuildInfoExtractor.getDependenciesMapFromBuild(previousBuildInfo);
            return map;
        }
    }

    static Map<String, Dependency> getDependenciesMapFromBuild(Build build) {
        ConcurrentHashMap<String, Dependency> previousBuildDependencies = new ConcurrentHashMap<String, Dependency>();
        List modules = build.getModules();
        for (Module module : modules) {
            List dependencies = module.getDependencies();
            if (dependencies == null) continue;
            for (Dependency dependency : dependencies) {
                previousBuildDependencies.put(dependency.getId(), dependency);
            }
        }
        return previousBuildDependencies;
    }

    static enum TypeRestriction {
        DEFAULT_RESTRICTION,
        ALL,
        DEV_ONLY,
        PROD_ONLY;

    }
}

