/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.build.extractor.go.extractor;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import java.util.zip.ZipEntry;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.ArchiveOutputStream;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveOutputStream;
import org.apache.commons.compress.archivers.zip.ZipFile;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.jfrog.build.api.util.Log;
import org.jfrog.build.extractor.go.extractor.GoVersionUtils;

public class GoZipBallStreamer
implements Closeable {
    protected ArchiveOutputStream archiveOutputStream;
    private final Log log;
    private final ZipFile zipFile;
    private final String projectName;
    private final String version;
    private final Set<String> excludedDirectories;
    private String subModuleName = "";
    private static final String MOD_FILE = "go.mod";
    private static final String MOD_FILE_PATH = "/go.mod";
    private static final String VENDOR = "vendor/";

    public GoZipBallStreamer(ZipFile zipFile, String projectName, String version, Log log) {
        this.zipFile = zipFile;
        this.projectName = projectName;
        this.version = version;
        this.log = log;
        this.excludedDirectories = new HashSet<String>();
    }

    public void writeDeployableZip(File deployableZip) throws IOException {
        try (ZipArchiveOutputStream zos = new ZipArchiveOutputStream(deployableZip);){
            this.archiveOutputStream = zos;
            this.packProject();
            this.archiveOutputStream.finish();
            this.archiveOutputStream.flush();
        }
    }

    protected void packProject() throws IOException {
        this.initiateProjectType();
        this.scanEntries();
        this.writeEntries();
    }

    void setSubModuleName(String subModuleName) {
        this.subModuleName = subModuleName;
    }

    private void initiateProjectType() {
        boolean compatibleModuleFromV2;
        boolean bl = compatibleModuleFromV2 = GoVersionUtils.getMajorVersion(this.version, this.log) >= 2 && GoVersionUtils.isCompatibleGoModuleNaming(this.projectName, this.version, this.log);
        if (compatibleModuleFromV2) {
            String majorVersion = "v" + GoVersionUtils.getMajorProjectVersion(this.projectName, this.log);
            if (!this.hasRootModFileOfCompatibleModuleFromV2(majorVersion)) {
                this.subModuleName = majorVersion;
                this.log.debug(this.projectName + "@" + this.version + " is compatible Go module from major version " + this.subModuleName);
            }
        } else {
            this.subModuleName = GoVersionUtils.getSubModule(this.projectName);
            if (this.shouldPackSubModule()) {
                this.log.debug(this.projectName + "@" + this.version + " is a sub module - the sub module name is " + this.subModuleName);
            } else {
                this.log.debug(this.projectName + "@" + this.version + " is a regular module");
            }
        }
    }

    private void writeEntries() throws IOException {
        Enumeration entries = this.zipFile.getEntries();
        while (entries.hasMoreElements()) {
            ZipArchiveEntry zipEntry = (ZipArchiveEntry)entries.nextElement();
            if (zipEntry.isDirectory() || this.zipFile.getUnixSymlink(zipEntry) != null) continue;
            try {
                if (this.excludeEntry(zipEntry.getName())) continue;
                ZipArchiveEntry correctedEntry = this.getCorrectedEntryName(zipEntry.getName(), zipEntry.getSize());
                this.writeEntry(zipEntry, correctedEntry);
            }
            catch (IOException e) {
                this.log.error("Could not read or write entity from zip for Go package " + this.projectName, (Throwable)e);
            }
        }
    }

    private void writeEntry(ZipArchiveEntry originalEntry, ZipArchiveEntry correctedEntry) throws IOException {
        try {
            this.archiveOutputStream.putArchiveEntry((ArchiveEntry)correctedEntry);
            IOUtils.copy((InputStream)this.zipFile.getInputStream(originalEntry), (OutputStream)this.archiveOutputStream);
        }
        finally {
            this.archiveOutputStream.closeArchiveEntry();
        }
    }

    private ZipArchiveEntry getCorrectedEntryName(String entryName, long entryLength) {
        String subPath = GoZipBallStreamer.stripFirstPathElement(entryName);
        if (subPath.startsWith(this.subModuleName + "/")) {
            subPath = subPath.replace(this.subModuleName + '/', "");
        }
        String correctedEntryName = String.join((CharSequence)"/", this.projectName + "@" + this.version, subPath);
        ZipArchiveEntry zipArchiveEntry = new ZipArchiveEntry(correctedEntryName);
        zipArchiveEntry.setSize(entryLength);
        return zipArchiveEntry;
    }

    private boolean excludeEntry(String entryName) {
        if (entryName.endsWith("/.hg_archival.txt")) {
            return true;
        }
        if (this.isVendorPackage(entryName)) {
            return true;
        }
        if (entryName.lastIndexOf(47) != -1) {
            String rootPath;
            String trimmedPrefix = entryName.substring(0, entryName.lastIndexOf(47));
            if (this.shouldPackSubModule() && (rootPath = trimmedPrefix.split('/' + this.subModuleName, 2)[0]).equals(trimmedPrefix)) {
                return !entryName.endsWith("LICENSE");
            }
            return this.excludedDirectories.contains(trimmedPrefix);
        }
        return false;
    }

    private void scanEntries() {
        Enumeration entries = this.zipFile.getEntries();
        HashSet<String> allDirectories = new HashSet<String>();
        while (entries.hasMoreElements()) {
            ZipEntry zipEntry = (ZipEntry)entries.nextElement();
            if (!zipEntry.isDirectory() && this.isSubModule(zipEntry.getName())) {
                String subModulePath = zipEntry.getName().replace(MOD_FILE_PATH, "");
                this.excludedDirectories.add(subModulePath);
                continue;
            }
            allDirectories.add(GoVersionUtils.getParent(zipEntry.getName()));
        }
        if (!this.excludedDirectories.isEmpty()) {
            String moduleRootDir = allDirectories.stream().filter(dir -> dir.endsWith(this.subModuleName)).findFirst().orElse("");
            allDirectories.stream().filter(dir -> this.shouldExcludeDirectory(moduleRootDir, (String)dir)).forEach(this.excludedDirectories::add);
        }
    }

    private boolean shouldExcludeDirectory(String moduleRootDir, String directory) {
        return !directory.startsWith(moduleRootDir) || this.isSubFolderOfAnotherModule(moduleRootDir, directory);
    }

    private boolean isSubFolderOfAnotherModule(String moduleRootDir, String directory) {
        String currentDir = directory;
        while (StringUtils.isNotEmpty((CharSequence)currentDir)) {
            if (currentDir.equals(moduleRootDir)) {
                return false;
            }
            if (this.excludedDirectories.contains(currentDir)) {
                return true;
            }
            currentDir = GoVersionUtils.getParent(currentDir);
        }
        return false;
    }

    boolean isSubModule(String entryName) {
        if (entryName.endsWith(MOD_FILE_PATH)) {
            if (this.shouldPackSubModule()) {
                return !entryName.substring(entryName.indexOf(47) + 1).endsWith(this.subModuleName + MOD_FILE_PATH);
            }
            return !entryName.substring(entryName.indexOf(47) + 1).equals(MOD_FILE);
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean hasRootModFileOfCompatibleModuleFromV2(String majorVersion) {
        Enumeration entries = this.zipFile.getEntries();
        if (!entries.hasMoreElements()) return false;
        ZipArchiveEntry zipEntry = (ZipArchiveEntry)entries.nextElement();
        ZipArchiveEntry modEntry = this.zipFile.getEntry(this.getFirstPathElement(zipEntry.getName()) + MOD_FILE_PATH);
        if (modEntry == null) {
            modEntry = this.zipFile.getEntry(MOD_FILE);
        }
        if (modEntry == null) return false;
        try (InputStream inputStream = this.zipFile.getInputStream(modEntry);){
            String modFileContent = IOUtils.toString((InputStream)inputStream, (String)StandardCharsets.UTF_8.name());
            boolean bl = StringUtils.substringBefore((String)modFileContent, (String)System.lineSeparator()).endsWith("/" + majorVersion);
            return bl;
        }
        catch (IOException e) {
            this.log.warn("Failed to read go.mod file of the root project: " + ExceptionUtils.getRootCauseMessage((Throwable)e));
        }
        return false;
    }

    private boolean isVendorPackage(String entryName) {
        int i;
        if (entryName.startsWith(VENDOR)) {
            i = VENDOR.length();
        } else if (entryName.contains("/vendor/")) {
            i = VENDOR.length() + 1;
        } else {
            return false;
        }
        return entryName.substring(i).contains("/");
    }

    private boolean shouldPackSubModule() {
        return StringUtils.isNotEmpty((CharSequence)this.subModuleName);
    }

    private static String stripFirstPathElement(String path) {
        if (path == null) {
            return null;
        }
        int indexOfFirstSlash = path.indexOf(47);
        return indexOfFirstSlash < 0 ? "" : path.substring(indexOfFirstSlash + 1);
    }

    @Override
    public void close() throws IOException {
        this.zipFile.close();
    }

    private String getFirstPathElement(String path) {
        if (path == null) {
            return "";
        }
        path = StringUtils.removeStart((String)path, (String)"/");
        return StringUtils.substringBefore((String)path, (String)"/");
    }
}

