/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.build.extractor.go.extractor;

import com.google.common.collect.Sets;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import java.util.zip.ZipEntry;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.ArchiveOutputStream;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveOutputStream;
import org.apache.commons.compress.archivers.zip.ZipFile;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.jfrog.build.api.util.Log;
import org.jfrog.build.extractor.go.extractor.GoVersionUtils;

public class GoZipBallStreamer
implements Closeable {
    protected ArchiveOutputStream archiveOutputStream;
    private final Log log;
    private ZipFile zipFile;
    private String projectName;
    private String version;
    private Set<String> excludedDirectories;
    private String subModuleName;
    private static final String MOD_FILE = "/go.mod";
    private static final String VENDOR = "vendor/";

    public GoZipBallStreamer(ZipFile zipFile, String projectName, String version, Log log) {
        this.zipFile = zipFile;
        this.projectName = projectName;
        this.version = version;
        this.log = log;
        this.excludedDirectories = Sets.newHashSet();
    }

    public void writeDeployableZip(File deployableZip) throws IOException {
        try (ZipArchiveOutputStream zos = new ZipArchiveOutputStream(deployableZip);){
            this.archiveOutputStream = zos;
            this.packProject();
            this.archiveOutputStream.finish();
            this.archiveOutputStream.flush();
        }
    }

    protected void packProject() throws IOException {
        this.initiateProjectType();
        this.scanEntries();
        this.writeEntries();
    }

    private void initiateProjectType() {
        boolean compatibleModuleFromV2;
        boolean bl = compatibleModuleFromV2 = GoVersionUtils.getMajorVersion(this.version, this.log) >= 2 && GoVersionUtils.isCompatibleGoModuleNaming(this.projectName, this.version, this.log);
        if (compatibleModuleFromV2) {
            this.subModuleName = "v" + GoVersionUtils.getMajorProjectVersion(this.projectName, this.log);
            this.log.debug(this.projectName + "@" + this.version + " is compatible Go module from major version " + this.subModuleName);
        } else {
            this.subModuleName = GoVersionUtils.getSubModule(this.projectName);
            if (this.shouldPackSubModule()) {
                this.log.debug(this.projectName + "@" + this.version + " is a sub module - the sub module name is " + this.subModuleName);
            } else {
                this.log.debug(this.projectName + "@" + this.version + " is a regular module");
            }
        }
    }

    private void writeEntries() throws IOException {
        Enumeration entries = this.zipFile.getEntries();
        while (entries.hasMoreElements()) {
            ZipArchiveEntry zipEntry = (ZipArchiveEntry)entries.nextElement();
            if (zipEntry.isDirectory() || this.zipFile.getUnixSymlink(zipEntry) != null) continue;
            try {
                if (this.excludeEntry(zipEntry.getName())) continue;
                ZipArchiveEntry correctedEntry = this.getCorrectedEntryName(zipEntry.getName(), zipEntry.getSize());
                this.writeEntry(zipEntry, correctedEntry);
            }
            catch (IOException e) {
                this.log.error("Could not read or write entity from zip for Go package " + this.projectName, (Throwable)e);
            }
        }
    }

    private void writeEntry(ZipArchiveEntry originalEntry, ZipArchiveEntry correctedEntry) throws IOException {
        try {
            this.archiveOutputStream.putArchiveEntry((ArchiveEntry)correctedEntry);
            IOUtils.copy((InputStream)this.zipFile.getInputStream(originalEntry), (OutputStream)this.archiveOutputStream);
        }
        finally {
            this.archiveOutputStream.closeArchiveEntry();
        }
    }

    private ZipArchiveEntry getCorrectedEntryName(String entryName, long entryLength) {
        String subPath = GoZipBallStreamer.stripFirstPathElement(entryName);
        if (subPath.startsWith(this.subModuleName + "/")) {
            subPath = subPath.replace(this.subModuleName + '/', "");
        }
        String correctedEntryName = String.join((CharSequence)"/", this.projectName + "@" + this.version, subPath);
        ZipArchiveEntry zipArchiveEntry = new ZipArchiveEntry(correctedEntryName);
        zipArchiveEntry.setSize(entryLength);
        return zipArchiveEntry;
    }

    private boolean excludeEntry(String entryName) {
        if (entryName.endsWith("/.hg_archival.txt")) {
            return true;
        }
        if (this.isVendorPackage(entryName)) {
            return true;
        }
        if (entryName.lastIndexOf(47) != -1) {
            String rootPath;
            String trimmedPrefix = entryName.substring(0, entryName.lastIndexOf(47));
            if (this.shouldPackSubModule() && (rootPath = trimmedPrefix.split('/' + this.subModuleName, 2)[0]).equals(trimmedPrefix)) {
                return !entryName.endsWith("LICENSE");
            }
            return this.excludedDirectories.contains(trimmedPrefix);
        }
        return false;
    }

    private void scanEntries() {
        Enumeration entries = this.zipFile.getEntries();
        HashSet allDirectories = Sets.newHashSet();
        while (entries.hasMoreElements()) {
            ZipEntry zipEntry = (ZipEntry)entries.nextElement();
            if (!zipEntry.isDirectory() && this.isSubModule(zipEntry.getName())) {
                String subModulePath = zipEntry.getName().replace(MOD_FILE, "");
                this.excludedDirectories.add(subModulePath);
                continue;
            }
            allDirectories.add(GoVersionUtils.getParent(zipEntry.getName()));
        }
        if (!this.excludedDirectories.isEmpty()) {
            String moduleRootDir = allDirectories.stream().filter(dir -> dir.endsWith(this.subModuleName)).findFirst().orElse("");
            allDirectories.stream().filter(dir -> this.shouldExcludeDirectory(moduleRootDir, (String)dir)).forEach(this.excludedDirectories::add);
        }
    }

    private boolean shouldExcludeDirectory(String moduleRootDir, String directory) {
        return !directory.startsWith(moduleRootDir) || this.isSubFolderOfAnotherModule(moduleRootDir, directory);
    }

    private boolean isSubFolderOfAnotherModule(String moduleRootDir, String directory) {
        String currentDir = directory;
        while (StringUtils.isNotEmpty((CharSequence)currentDir)) {
            if (currentDir.equals(moduleRootDir)) {
                return false;
            }
            if (this.excludedDirectories.contains(currentDir)) {
                return true;
            }
            currentDir = GoVersionUtils.getParent(currentDir);
        }
        return false;
    }

    private boolean isSubModule(String entryName) {
        if (entryName.endsWith(MOD_FILE)) {
            if (this.shouldPackSubModule()) {
                return !entryName.substring(entryName.indexOf(47) + 1).endsWith(this.subModuleName + MOD_FILE);
            }
            return entryName.substring(entryName.indexOf(47) + 1).endsWith(this.subModuleName + MOD_FILE);
        }
        return false;
    }

    private boolean isVendorPackage(String entryName) {
        if (entryName.startsWith(VENDOR) || entryName.contains("/vendor/")) {
            return entryName.substring(entryName.indexOf(VENDOR) + VENDOR.length()).contains("/");
        }
        return false;
    }

    private boolean shouldPackSubModule() {
        return StringUtils.isNotEmpty((CharSequence)this.subModuleName);
    }

    private static String stripFirstPathElement(String path) {
        if (path == null) {
            return null;
        }
        int indexOfFirstSlash = path.indexOf(47);
        return indexOfFirstSlash < 0 ? "" : path.substring(indexOfFirstSlash + 1);
    }

    @Override
    public void close() throws IOException {
        this.zipFile.close();
    }
}

