/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.build.extractor.go.extractor;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ArrayListMultimap;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.commons.compress.archivers.zip.ZipFile;
import org.apache.commons.lang3.StringUtils;
import org.jfrog.build.api.Artifact;
import org.jfrog.build.api.Build;
import org.jfrog.build.api.Module;
import org.jfrog.build.api.builder.ArtifactBuilder;
import org.jfrog.build.api.builder.ModuleBuilder;
import org.jfrog.build.api.builder.ModuleType;
import org.jfrog.build.api.util.FileChecksumCalculator;
import org.jfrog.build.api.util.Log;
import org.jfrog.build.client.ArtifactoryUploadResponse;
import org.jfrog.build.extractor.clientConfiguration.ArtifactoryManagerBuilder;
import org.jfrog.build.extractor.clientConfiguration.client.artifactory.ArtifactoryManager;
import org.jfrog.build.extractor.clientConfiguration.deploy.DeployDetails;
import org.jfrog.build.extractor.go.GoDriver;
import org.jfrog.build.extractor.go.extractor.GoCommand;
import org.jfrog.build.extractor.go.extractor.GoZipBallStreamer;

public class GoPublish
extends GoCommand {
    private static final String LOCAL_PKG_FILENAME = "package";
    private static final String LOCAL_TMP_PKG_PREFIX = "tmp.";
    private static final String LOCAL_INFO_FILENAME = "package.info";
    private static final String GO_VERSION_PREFIX = "v";
    private static final String PKG_ZIP_FILE_EXTENSION = "zip";
    private static final String PKG_MOD_FILE_EXTENSION = "mod";
    private static final String PKG_INFO_FILE_EXTENSION = "info";
    private ArrayListMultimap<String, String> properties;
    private List<Artifact> artifactList = new ArrayList<Artifact>();
    private String deploymentRepo;
    private String version;

    public GoPublish(ArtifactoryManagerBuilder artifactoryManagerBuilder, ArrayListMultimap<String, String> properties, String repo, Path path, String version, String module, Log logger) throws IOException {
        super(artifactoryManagerBuilder, path, module, logger);
        this.goDriver = new GoDriver("go", null, path.toFile(), logger);
        this.moduleName = this.goDriver.getModuleName();
        this.properties = properties;
        this.deploymentRepo = repo;
        this.version = GO_VERSION_PREFIX + version;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Build execute() {
        try (ArtifactoryManager artifactoryManager = this.artifactoryManagerBuilder.build();){
            this.preparePrerequisites(this.deploymentRepo, artifactoryManager);
            this.publishPkg(artifactoryManager);
            Build build = this.createBuild();
            return build;
        }
        catch (Exception e) {
            this.logger.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    private void publishPkg(ArtifactoryManager artifactoryManager) throws Exception {
        this.createAndDeployZip(artifactoryManager);
        this.deployGoMod(artifactoryManager);
        this.createAndDeployInfo(artifactoryManager);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createAndDeployZip(ArtifactoryManager artifactoryManager) throws Exception {
        File tmpZipFile = this.archiveProjectDir();
        File deployableZipFile = File.createTempFile(LOCAL_PKG_FILENAME, PKG_ZIP_FILE_EXTENSION, this.path.toFile());
        try (GoZipBallStreamer pkgArchiver = new GoZipBallStreamer(new ZipFile(tmpZipFile), this.moduleName, this.version, this.logger);){
            pkgArchiver.writeDeployableZip(deployableZipFile);
            Artifact deployedPackage = this.deploy(artifactoryManager, deployableZipFile, PKG_ZIP_FILE_EXTENSION);
            this.artifactList.add(deployedPackage);
        }
        finally {
            Files.deleteIfExists(tmpZipFile.toPath());
            Files.deleteIfExists(deployableZipFile.toPath());
        }
    }

    private void deployGoMod(ArtifactoryManager artifactoryManager) throws Exception {
        String modLocalPath = this.getModFilePath();
        Artifact deployedMod = this.deploy(artifactoryManager, new File(modLocalPath), PKG_MOD_FILE_EXTENSION);
        this.artifactList.add(deployedMod);
    }

    private void createAndDeployInfo(ArtifactoryManager artifactoryManager) throws Exception {
        String infoLocalPath = this.path.toString() + File.separator + LOCAL_INFO_FILENAME;
        File infoFile = this.writeInfoFile(infoLocalPath);
        Artifact deployedInfo = this.deploy(artifactoryManager, infoFile, PKG_INFO_FILE_EXTENSION);
        this.artifactList.add(deployedInfo);
        infoFile.delete();
    }

    private File archiveProjectDir() throws IOException {
        File zipFile = File.createTempFile("tmp.package", PKG_ZIP_FILE_EXTENSION, this.path.toFile());
        try (ZipOutputStream zos = new ZipOutputStream(new FileOutputStream(zipFile));){
            List pathsList = Files.walk(this.path, new FileVisitOption[0]).filter(p -> !this.path.relativize((Path)p).startsWith(".git/") && !Files.isDirectory(p, new LinkOption[0]) && !p.toFile().getName().equals(zipFile.getName())).collect(Collectors.toList());
            for (Path filePath : pathsList) {
                ZipEntry zipEntry = new ZipEntry(this.path.getParent().relativize(filePath).toString());
                zos.putNextEntry(zipEntry);
                Files.copy(filePath, zos);
                zos.closeEntry();
            }
        }
        return zipFile;
    }

    private File writeInfoFile(String localInfoPath) throws IOException {
        File infoFile = new File(localInfoPath);
        ObjectMapper mapper = new ObjectMapper();
        HashMap<String, String> infoMap = new HashMap<String, String>();
        Date date = new Date();
        Instant instant = date.toInstant();
        infoMap.put("Version", this.version);
        infoMap.put("Time", instant.toString());
        mapper.writeValue(infoFile, infoMap);
        return infoFile;
    }

    private Artifact deploy(ArtifactoryManager artifactoryManager, File deployedFile, String extension) throws Exception {
        String artifactName = this.version + "." + extension;
        Map checksums = FileChecksumCalculator.calculateChecksums((File)deployedFile, (String[])new String[]{"MD5", "SHA1"});
        String remotePath = this.moduleName + "/@v";
        DeployDetails deployDetails = new DeployDetails.Builder().file(deployedFile).targetRepository(this.deploymentRepo).addProperties(this.properties).artifactPath(remotePath + "/" + artifactName).md5((String)checksums.get("MD5")).sha1((String)checksums.get("SHA1")).packageType(DeployDetails.PackageType.GO).build();
        ArtifactoryUploadResponse response = artifactoryManager.upload(deployDetails);
        return new ArtifactBuilder(this.moduleName + ":" + artifactName).md5(response.getChecksums().getMd5()).sha1(response.getChecksums().getSha1()).remotePath(remotePath).build();
    }

    private Build createBuild() {
        Build build = new Build();
        String moduleId = (String)StringUtils.defaultIfBlank((CharSequence)this.buildInfoModuleId, (CharSequence)this.moduleName);
        Module module = new ModuleBuilder().type(ModuleType.GO).id(moduleId).repository(this.deploymentRepo).artifacts(this.artifactList).build();
        build.setModules(Collections.singletonList(module));
        return build;
    }
}

