/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.build.extractor.go.extractor;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.nio.file.Path;
import org.apache.commons.lang.StringUtils;
import org.jfrog.build.api.util.Log;
import org.jfrog.build.client.ArtifactoryVersion;
import org.jfrog.build.client.Version;
import org.jfrog.build.extractor.clientConfiguration.ArtifactoryManagerBuilder;
import org.jfrog.build.extractor.clientConfiguration.client.artifactory.ArtifactoryManager;
import org.jfrog.build.extractor.go.GoDriver;
import org.jfrog.build.util.VersionCompatibilityType;
import org.jfrog.build.util.VersionException;

abstract class GoCommand
implements Serializable {
    protected static final String SHA1 = "SHA1";
    protected static final String MD5 = "MD5";
    protected static final String LOCAL_GO_MOD_FILENAME = "go.mod";
    protected static final String GO_CLIENT_CMD = "go";
    private static final long serialVersionUID = 1L;
    private static final ArtifactoryVersion MIN_SUPPORTED_ARTIFACTORY_VERSION = new ArtifactoryVersion("6.10.0");
    ArtifactoryManagerBuilder artifactoryManagerBuilder;
    GoDriver goDriver;
    Path path;
    String moduleName;
    String buildInfoModuleId;
    Log logger;

    GoCommand(ArtifactoryManagerBuilder artifactoryManagerBuilder, Path path, String buildInfoModuleId, Log logger) {
        this.artifactoryManagerBuilder = artifactoryManagerBuilder;
        this.logger = logger;
        this.path = path;
        this.buildInfoModuleId = buildInfoModuleId;
    }

    protected void preparePrerequisites(String repo, ArtifactoryManager artifactoryManager) throws VersionException, IOException {
        this.validateArtifactoryVersion(artifactoryManager);
        this.validateRepoExists(repo, artifactoryManager, "The provided repo must be specified");
    }

    private void validateArtifactoryVersion(ArtifactoryManager artifactoryManager) throws VersionException, IOException {
        ArtifactoryVersion version = artifactoryManager.getVersion();
        if (version.isNotFound()) {
            String message = "Couldn't execute go task. Check connection with Artifactory.";
            throw new VersionException(message, VersionCompatibilityType.NOT_FOUND);
        }
        if (!version.isAtLeast((Version)MIN_SUPPORTED_ARTIFACTORY_VERSION)) {
            String message = String.format("Couldn't execute Go task. Artifactory version is %s but must be at least %s.", version.toString(), MIN_SUPPORTED_ARTIFACTORY_VERSION.toString());
            throw new VersionException(message, VersionCompatibilityType.INCOMPATIBLE);
        }
    }

    private void validateRepoExists(String repo, ArtifactoryManager artifactoryManager, String repoNotSpecifiedMsg) throws IOException {
        if (StringUtils.isBlank((String)repo)) {
            throw new IllegalArgumentException(repoNotSpecifiedMsg);
        }
        if (!artifactoryManager.isRepositoryExist(repo)) {
            throw new IOException("Repo " + repo + " doesn't exist");
        }
    }

    protected String getModFilePath() {
        return this.path.toString() + File.separator + LOCAL_GO_MOD_FILENAME;
    }
}

