/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.build.extractor.go;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.jfrog.build.api.util.Log;
import org.jfrog.build.extractor.executor.CommandExecutor;
import org.jfrog.build.extractor.executor.CommandResults;

public class GoDriver
implements Serializable {
    private static final String GO_VERSION_CMD = "version";
    private static final String GO_MOD_GRAPH_CMD = "mod graph";
    private static final String GO_LIST_MODULE = "list -m";
    private static final long serialVersionUID = 1L;
    private CommandExecutor commandExecutor;
    private File workingDirectory;
    private Log logger;

    public GoDriver(String executablePath, Map<String, String> env, File workingDirectory, Log logger) {
        this.commandExecutor = new CommandExecutor(StringUtils.defaultIfEmpty((String)executablePath, (String)"go"), env);
        this.workingDirectory = workingDirectory;
        this.logger = logger;
    }

    public CommandResults runCmd(String args, boolean prompt) throws IOException {
        ArrayList<String> argsList = new ArrayList<String>(Arrays.asList(args.split(" ")));
        return this.runCmd(argsList, prompt);
    }

    public CommandResults runCmd(List<String> args, boolean prompt) throws IOException {
        CommandResults goCmdResult;
        try {
            goCmdResult = this.commandExecutor.exeCommand(this.workingDirectory, args, null, this.logger);
        }
        catch (IOException | InterruptedException e) {
            throw new IOException("Go execution failed", e);
        }
        if (!goCmdResult.isOk()) {
            throw new IOException(goCmdResult.getErr());
        }
        if (prompt) {
            this.logger.info(goCmdResult.getErr() + goCmdResult.getRes());
        }
        return goCmdResult;
    }

    public boolean isInstalled() {
        try {
            this.version(false);
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    public CommandResults version(boolean prompt) throws IOException {
        return this.runCmd(GO_VERSION_CMD, prompt);
    }

    public CommandResults modGraph(boolean prompt) throws IOException {
        return this.runCmd(GO_MOD_GRAPH_CMD, prompt);
    }

    public String getModuleName() throws IOException {
        CommandResults commandResults = this.runCmd(GO_LIST_MODULE, false);
        return commandResults.getRes().trim();
    }
}

