/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.build.extractor.docker.types;

import java.io.Serializable;
import org.jfrog.build.api.search.AqlSearchResult;
import org.jfrog.build.extractor.docker.DockerUtils;

public class DockerLayer
implements Serializable {
    private final String repo;
    private final String path;
    private final String fileName;
    private final String sha1;
    private final String digest;

    public DockerLayer(AqlSearchResult.SearchEntry entry) {
        this.repo = entry.getRepo();
        this.path = entry.getPath();
        this.fileName = entry.getName();
        this.sha1 = entry.getActualSha1();
        this.digest = !this.fileName.equals("manifest.json") ? DockerUtils.fileNameToDigest(this.fileName) : "sha1:" + this.sha1;
    }

    public String getFullPath() {
        return this.repo + "/" + this.path + "/" + this.fileName;
    }

    public String getPath() {
        return this.path;
    }

    public String getFileName() {
        return this.fileName;
    }

    public String getSha1() {
        return this.sha1;
    }

    public String getDigest() {
        return this.digest;
    }
}

