/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.build.extractor.docker.extractor;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.jfrog.build.api.util.Log;
import org.jfrog.build.extractor.BuildInfoExtractorUtils;
import org.jfrog.build.extractor.ci.BuildInfo;
import org.jfrog.build.extractor.ci.Module;
import org.jfrog.build.extractor.clientConfiguration.ArtifactoryClientConfiguration;
import org.jfrog.build.extractor.clientConfiguration.ArtifactoryManagerBuilder;
import org.jfrog.build.extractor.clientConfiguration.client.artifactory.ArtifactoryManager;
import org.jfrog.build.extractor.clientConfiguration.util.PathsUtils;
import org.jfrog.build.extractor.clientConfiguration.util.spec.UploadSpecHelper;
import org.jfrog.build.extractor.docker.DockerUtils;
import org.jfrog.build.extractor.docker.types.DockerImage;
import org.jfrog.build.extractor.docker.types.DockerLayer;
import org.jfrog.build.extractor.docker.types.DockerLayers;
import org.jfrog.build.extractor.packageManager.PackageManagerExtractor;
import org.jfrog.build.extractor.packageManager.PackageManagerUtils;

public class BuildDockerCreator
extends PackageManagerExtractor {
    private final ArrayListMultimap<String, String> artifactProperties;
    private final ArtifactoryManagerBuilder artifactoryManagerBuilder;
    private final ImageFileType imageFileType;
    private final String sourceRepo;
    private final String imageFile;
    private final Log logger;

    public BuildDockerCreator(ArtifactoryManagerBuilder artifactoryManagerBuilder, String imageFile, ImageFileType imageFileType, ArrayListMultimap<String, String> artifactProperties, String sourceRepo, Log logger) {
        this.artifactoryManagerBuilder = artifactoryManagerBuilder;
        this.artifactProperties = artifactProperties;
        this.sourceRepo = sourceRepo;
        this.imageFileType = imageFileType;
        this.imageFile = imageFile;
        this.logger = logger;
    }

    public static void main(String[] ignored) {
        try {
            ImageFileType imageFileType;
            String imageFile;
            ArtifactoryClientConfiguration clientConfiguration = PackageManagerUtils.createArtifactoryClientConfiguration();
            ArtifactoryManagerBuilder artifactoryManagerBuilder = (ArtifactoryManagerBuilder)new ArtifactoryManagerBuilder().setClientConfiguration(clientConfiguration, (ArtifactoryClientConfiguration.RepositoryConfiguration)clientConfiguration.publisher);
            ArtifactoryClientConfiguration.DockerHandler dockerHandler = clientConfiguration.dockerHandler;
            if (StringUtils.isNotBlank((CharSequence)dockerHandler.getKanikoImageFile())) {
                imageFile = dockerHandler.getKanikoImageFile();
                imageFileType = ImageFileType.KANIKO;
            } else if (StringUtils.isNotBlank((CharSequence)dockerHandler.getJibImageFile())) {
                imageFile = dockerHandler.getJibImageFile();
                imageFileType = ImageFileType.JIB;
            } else {
                throw new RuntimeException("kaniko.image.file or jib.image.file property is expected");
            }
            BuildDockerCreator dockerBuildCreate = new BuildDockerCreator(artifactoryManagerBuilder, imageFile, imageFileType, (ArrayListMultimap<String, String>)ArrayListMultimap.create((Multimap)clientConfiguration.publisher.getMatrixParams().asMultimap()), clientConfiguration.publisher.getRepoKey(), clientConfiguration.getLog());
            dockerBuildCreate.executeAndSaveBuildInfo(clientConfiguration);
        }
        catch (RuntimeException e) {
            ExceptionUtils.printRootCauseStackTrace((Throwable)e, (PrintStream)System.out);
            System.exit(1);
        }
    }

    public BuildInfo execute() {
        this.logger.info("Generating build info for: " + this.imageFile);
        try {
            List<ImageFileWithDigest> imageFilesWithDigest;
            ArrayList<Module> modules = new ArrayList<Module>();
            List<ImageFileWithDigest> list = imageFilesWithDigest = this.imageFileType == ImageFileType.KANIKO ? this.getKanikoImageFileWithDigests(this.imageFile) : this.getJibImageFilesWithDigests(this.imageFile);
            if (imageFilesWithDigest.isEmpty()) {
                throw new RuntimeException("No image files found at path '" + this.imageFile + "'");
            }
            for (ImageFileWithDigest imageFileWithDigest : imageFilesWithDigest) {
                DockerImage image = new DockerImage("", imageFileWithDigest.imageName, imageFileWithDigest.manifestSha256, this.sourceRepo, this.artifactoryManagerBuilder, "", "");
                Module module = image.generateBuildInfoModule(this.logger, DockerUtils.CommandType.Push);
                if (module.getArtifacts() == null || module.getArtifacts().size() == 0) {
                    this.logger.warn("Could not find docker image: " + imageFileWithDigest.imageName + " in Artifactory.");
                } else {
                    this.setImageLayersProps(image.getLayers(), this.artifactProperties, this.artifactoryManagerBuilder);
                }
                modules.add(module);
                this.logger.info("Successfully created build info for image: " + imageFileWithDigest.imageName);
            }
            BuildInfo buildInfo = new BuildInfo();
            buildInfo.setModules(modules);
            return buildInfo;
        }
        catch (Exception e) {
            this.logger.error(ExceptionUtils.getRootCauseMessage((Throwable)e), (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    private void setImageLayersProps(DockerLayers layers, ArrayListMultimap<String, String> artifactProperties, ArtifactoryManagerBuilder artifactoryManagerBuilder) throws IOException {
        if (layers == null) {
            return;
        }
        try (ArtifactoryManager artifactoryManager = artifactoryManagerBuilder.build();){
            for (DockerLayer layer : layers.getLayers()) {
                artifactoryManager.setProperties(layer.getFullPath(), artifactProperties, true);
            }
        }
    }

    private List<ImageFileWithDigest> getKanikoImageFileWithDigests(String kanikoImageFile) throws IOException {
        List<String> dataLines = Files.readAllLines(Paths.get(kanikoImageFile, new String[0]));
        if (dataLines.isEmpty()) {
            throw new IOException("Couldn't read image file \"" + kanikoImageFile + "\".");
        }
        List<ImageFileWithDigest> imageFileWithDigests = dataLines.stream().map(this::getImageFileWithDigest).filter(Objects::nonNull).collect(Collectors.toList());
        if (imageFileWithDigests.size() != dataLines.size()) {
            throw new RuntimeException("missing image-tag/sha256 in file: \"" + kanikoImageFile + "\"");
        }
        return imageFileWithDigests;
    }

    private List<ImageFileWithDigest> getJibImageFilesWithDigests(String jibImageFiles) {
        ObjectMapper mapper = BuildInfoExtractorUtils.createMapper();
        String baseDir = UploadSpecHelper.getWildcardBaseDir((File)new File(""), (String)jibImageFiles);
        String newPattern = UploadSpecHelper.prepareWildcardPattern((File)new File(""), (String)jibImageFiles, (String)baseDir);
        String regexPath = PathsUtils.pathToRegExp((String)newPattern);
        ArrayList<ImageFileWithDigest> imageFilesWithDigests = new ArrayList<ImageFileWithDigest>();
        Path baseDirPath = Paths.get(baseDir, new String[0]);
        try (Stream<Path> files = Files.find(baseDirPath, Integer.MAX_VALUE, (path, basicFileAttributes) -> baseDirPath.relativize((Path)path).toString().matches(regexPath), new FileVisitOption[0]);){
            files.forEach(jibImageFile -> {
                JsonNode jsonNode;
                try {
                    jsonNode = mapper.readTree(jibImageFile.toFile());
                }
                catch (IOException e) {
                    throw new RuntimeException("Couldn't read image file \"" + jibImageFiles + "\".");
                }
                JsonNode imageName = jsonNode.get("image");
                if (imageName == null || imageName.isNull()) {
                    throw new RuntimeException("Missing \"image\" in file: \"" + jibImageFiles + "\"");
                }
                JsonNode imageDigest = jsonNode.get("imageDigest");
                if (imageDigest == null || imageDigest.isNull()) {
                    throw new RuntimeException("Missing \"imageDigest\" in file: \"" + jibImageFiles + "\"");
                }
                imageFilesWithDigests.add(new ImageFileWithDigest(imageName.asText(), imageDigest.asText()));
            });
        }
        catch (IOException e) {
            throw new RuntimeException("Couldn't find JIB image files using the following pattern: '" + jibImageFiles + "'", e);
        }
        return imageFilesWithDigests;
    }

    private ImageFileWithDigest getImageFileWithDigest(String data) {
        String[] splitData = data.split("@");
        if (splitData.length != 2) {
            throw new RuntimeException("unexpected file format \"" + data + "\". The file should include one line in the following format: image-tag@sha256");
        }
        ImageFileWithDigest imageFileWithDigest = new ImageFileWithDigest(splitData[0], splitData[1]);
        if (imageFileWithDigest.imageName.isEmpty() || imageFileWithDigest.manifestSha256.isEmpty()) {
            return null;
        }
        return imageFileWithDigest;
    }

    private static class ImageFileWithDigest {
        final String imageName;
        final String manifestSha256;

        ImageFileWithDigest(String imageName, String manifestSha256) {
            this.imageName = imageName.trim();
            this.manifestSha256 = manifestSha256.trim();
        }
    }

    static enum ImageFileType {
        KANIKO,
        JIB;

    }
}

