/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.build.extractor.docker.types;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Properties;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.http.Header;
import org.jfrog.build.api.Artifact;
import org.jfrog.build.api.Dependency;
import org.jfrog.build.api.Module;
import org.jfrog.build.api.builder.ArtifactBuilder;
import org.jfrog.build.api.builder.DependencyBuilder;
import org.jfrog.build.api.builder.ModuleBuilder;
import org.jfrog.build.api.builder.ModuleType;
import org.jfrog.build.api.search.AqlSearchResult;
import org.jfrog.build.api.util.Log;
import org.jfrog.build.client.ArtifactoryVersion;
import org.jfrog.build.client.DownloadResponse;
import org.jfrog.build.client.Version;
import org.jfrog.build.extractor.clientConfiguration.ArtifactoryManagerBuilder;
import org.jfrog.build.extractor.clientConfiguration.client.artifactory.ArtifactoryManager;
import org.jfrog.build.extractor.docker.DockerUtils;
import org.jfrog.build.extractor.docker.types.DockerLayer;
import org.jfrog.build.extractor.docker.types.DockerLayers;

public class DockerImage
implements Serializable {
    private String imageId;
    private final String imageTag;
    private final String targetRepo;
    private final ArtifactoryVersion VIRTUAL_REPOS_SUPPORTED_VERSION = new ArtifactoryVersion("4.8.1");
    private final Properties buildInfoModuleProps = new Properties();
    private final String os;
    private final String architecture;
    private final ArtifactoryManagerBuilder artifactoryManagerBuilder;
    private String manifest;
    private String imagePath;
    private DockerLayers layers;
    private final String manifestSha256;

    public DockerImage(String imageId, String imageTag, String manifestSha256, String targetRepo, ArtifactoryManagerBuilder artifactoryManagerBuilder, String arch, String os) {
        this.imageId = imageId;
        this.imageTag = imageTag;
        this.targetRepo = targetRepo;
        this.artifactoryManagerBuilder = artifactoryManagerBuilder;
        this.architecture = arch;
        this.os = os;
        this.manifestSha256 = manifestSha256;
    }

    public DockerLayers getLayers() {
        return this.layers;
    }

    private void checkAndSetManifestAndImagePathCandidates(String candidateManifestPath, ArtifactoryManager artifactoryManager, Log logger) throws IOException {
        Pair<DownloadResponse, String> candidateDetails = this.getManifestFromArtifactory(artifactoryManager, candidateManifestPath, logger);
        DownloadResponse downloadResponse = (DownloadResponse)candidateDetails.getLeft();
        String manifestContent = downloadResponse.getContent();
        String manifestPath = (String)candidateDetails.getRight();
        if (StringUtils.isNotBlank((CharSequence)this.manifestSha256)) {
            if (!this.checkDownloadedManifest(downloadResponse, manifestPath)) {
                return;
            }
            this.imageId = DockerUtils.getConfigDigest(manifestContent);
        } else if (!DockerUtils.getConfigDigest(manifestContent).equals(this.imageId)) {
            return;
        }
        this.manifest = manifestContent;
        this.imagePath = manifestPath;
        this.loadLayers(manifestPath);
    }

    private boolean checkDownloadedManifest(DownloadResponse downloadResponse, String manifestPath) throws IOException {
        Header manifestSha256 = Arrays.stream(downloadResponse.getHeaders()).filter(header -> "X-Checksum-Sha256".equals(header.getName())).findFirst().orElseThrow(() -> new IOException(String.format("'%s' header is missing in GET '%s'.", "X-Checksum-Sha256", manifestPath)));
        return StringUtils.endsWith((CharSequence)this.manifestSha256, (CharSequence)manifestSha256.getValue());
    }

    private Pair<DownloadResponse, String> getManifestFromArtifactory(ArtifactoryManager artifactoryManager, String manifestPath, Log logger) throws IOException {
        String pathWithoutRepo = StringUtils.substringAfter((String)manifestPath, (String)"/");
        String downloadUrl = manifestPath + "/manifest.json";
        logger.info("Trying to download manifest from " + downloadUrl);
        try {
            return Pair.of((Object)artifactoryManager.download(downloadUrl), (Object)pathWithoutRepo);
        }
        catch (Exception e) {
            if (artifactoryManager.isLocalRepo(this.targetRepo)) {
                throw e;
            }
            downloadUrl = manifestPath + "/list.manifest.json";
            logger.info("Fallback for remote/virtual repository. Trying to download fat-manifest from " + downloadUrl);
            String digestsFromFatManifest = DockerUtils.getImageDigestFromFatManifest(artifactoryManager.download(downloadUrl).getContent(), this.os, this.architecture);
            if (digestsFromFatManifest.isEmpty()) {
                logger.info("Failed to get image digest from fat manifest");
                throw e;
            }
            logger.info("Found image digest from fat manifest. Trying to download the resulted manifest from path: " + manifestPath);
            manifestPath = StringUtils.substringBeforeLast((String)manifestPath, (String)"/") + "/" + digestsFromFatManifest.replace(":", "__");
            downloadUrl = manifestPath + "/manifest.json";
            logger.info("Trying to download manifest from " + downloadUrl);
            return Pair.of((Object)artifactoryManager.download(downloadUrl), (Object)StringUtils.substringAfter((String)manifestPath, (String)"/"));
        }
    }

    private void setBuildInfoModuleProps(ModuleBuilder moduleBuilder) {
        this.buildInfoModuleProps.setProperty("docker.image.id", DockerUtils.getShaValue(this.imageId));
        this.buildInfoModuleProps.setProperty("docker.captured.image", this.imageTag);
        moduleBuilder.properties(this.buildInfoModuleProps);
    }

    private DockerLayers createLayers(ArtifactoryManager artifactoryManager, String aql) throws IOException {
        AqlSearchResult result = artifactoryManager.searchArtifactsByAql(aql);
        DockerLayers layers = new DockerLayers();
        for (AqlSearchResult.SearchEntry entry : result.getResults()) {
            DockerLayer layer = new DockerLayer(entry);
            layers.addLayer(layer);
        }
        if (layers.getLayers().size() == 0) {
            throw new IllegalStateException(String.format("No docker layers found in Artifactory using AQL: %s after filtering layers in repos other than %s and with path other than %s", aql, this.targetRepo, this.imagePath));
        }
        return layers;
    }

    private void setDependenciesAndArtifacts(ModuleBuilder moduleBuilder, ArtifactoryManager artifactoryManager) throws IOException {
        DockerLayer historyLayer = this.layers.getByDigest(this.imageId);
        if (historyLayer == null) {
            throw new IllegalStateException("Could not find the history docker layer: " + this.imageId + " for image: " + this.imageTag + " in Artifactory.");
        }
        int dependencyLayerNum = DockerUtils.getNumberOfDependentLayers(artifactoryManager.download(historyLayer.getFullPath()).getContent());
        LinkedHashSet<Dependency> dependencies = new LinkedHashSet<Dependency>();
        LinkedHashSet<Artifact> artifacts = new LinkedHashSet<Artifact>();
        Iterator<String> it = DockerUtils.getLayersDigests(this.manifest).iterator();
        for (int i = 0; i < dependencyLayerNum; ++i) {
            String digest = it.next();
            DockerLayer layer = this.layers.getByDigest(digest);
            Dependency dependency = new DependencyBuilder().id(layer.getFileName()).sha1(layer.getSha1()).build();
            dependencies.add(dependency);
            Artifact artifact = new ArtifactBuilder(layer.getFileName()).sha1(layer.getSha1()).remotePath(layer.getPath()).build();
            artifacts.add(artifact);
        }
        moduleBuilder.dependencies(new ArrayList(dependencies));
        while (it.hasNext()) {
            String digest = it.next();
            DockerLayer layer = this.layers.getByDigest(digest);
            if (layer == null) continue;
            Artifact artifact = new ArtifactBuilder(layer.getFileName()).sha1(layer.getSha1()).remotePath(layer.getPath()).build();
            artifacts.add(artifact);
        }
        moduleBuilder.artifacts(new ArrayList(artifacts));
    }

    private void setDependencies(ModuleBuilder moduleBuilder) throws IOException {
        LinkedHashSet<Dependency> dependencies = new LinkedHashSet<Dependency>();
        for (String digest : DockerUtils.getLayersDigests(this.manifest)) {
            DockerLayer layer = this.layers.getByDigest(digest);
            Dependency dependency = new DependencyBuilder().id(layer.getFileName()).sha1(layer.getSha1()).build();
            dependencies.add(dependency);
        }
        moduleBuilder.dependencies(new ArrayList(dependencies));
    }

    private String getAqlQuery(boolean includeVirtualRepos, String Repo, String manifestPath) {
        StringBuilder aqlRequestForDockerSha = new StringBuilder("items.find({").append("\"path\":\"").append(manifestPath).append("\",").append("\"repo\":\"").append(Repo).append("\"})");
        if (includeVirtualRepos) {
            aqlRequestForDockerSha.append(".include(\"name\",\"repo\",\"path\",\"actual_sha1\",\"virtual_repos\")");
        } else {
            aqlRequestForDockerSha.append(".include(\"name\",\"repo\",\"path\",\"actual_sha1\")");
        }
        return aqlRequestForDockerSha.toString();
    }

    public Module generateBuildInfoModule(Log logger, DockerUtils.CommandType cmdType) throws IOException, InterruptedException {
        try (ArtifactoryManager artifactoryManager = this.artifactoryManagerBuilder.build();){
            ModuleBuilder moduleBuilder = new ModuleBuilder().type(ModuleType.DOCKER).id(this.imageTag.substring(this.imageTag.indexOf("/") + 1)).repository(this.targetRepo);
            try {
                this.findAndSetManifestFromArtifactory(artifactoryManager, logger, cmdType);
            }
            catch (IOException e) {
                logger.error("The manifest could not be fetched from Artifactory.");
                Module module = moduleBuilder.build();
                if (artifactoryManager != null) {
                    if (var4_4 != null) {
                        try {
                            artifactoryManager.close();
                        }
                        catch (Throwable throwable) {
                            var4_4.addSuppressed(throwable);
                        }
                    } else {
                        artifactoryManager.close();
                    }
                }
                return module;
            }
            logger.info("Fetching details of published docker layers from Artifactory...");
            if (cmdType == DockerUtils.CommandType.Push) {
                this.setDependenciesAndArtifacts(moduleBuilder, artifactoryManager);
            } else {
                this.setDependencies(moduleBuilder);
            }
            this.setBuildInfoModuleProps(moduleBuilder);
            Module module = moduleBuilder.build();
            return module;
        }
    }

    private void loadLayers(String manifestPath) throws IOException {
        try (ArtifactoryManager artifactoryManager = this.artifactoryManagerBuilder.build();){
            this.layers = this.getLayers(artifactoryManager, manifestPath);
            List markerLayers = this.layers.getLayers().stream().filter(layer -> layer.getFileName().endsWith(".marker")).collect(Collectors.toList());
            if (markerLayers.size() > 0) {
                for (DockerLayer markerLayer : markerLayers) {
                    String imageDigests = StringUtils.removeEnd((String)markerLayer.getDigest(), (String)".marker");
                    String imageName = StringUtils.substringBetween((String)this.imageTag, (String)"/", (String)":");
                    DockerUtils.downloadMarkerLayer(this.targetRepo, imageName, imageDigests, artifactoryManager);
                }
                this.layers = this.getLayers(artifactoryManager, manifestPath);
            }
        }
    }

    private DockerLayers getLayers(ArtifactoryManager artifactoryManager, String manifestPath) throws IOException {
        String searchableRepo = this.targetRepo;
        if (artifactoryManager.isRemoteRepo(this.targetRepo)) {
            searchableRepo = searchableRepo + "-cache";
        }
        String aql = this.getAqlQuery(artifactoryManager.getVersion().isAtLeast((Version)this.VIRTUAL_REPOS_SUPPORTED_VERSION), searchableRepo, manifestPath);
        return this.createLayers(artifactoryManager, aql);
    }

    private void findAndSetManifestFromArtifactory(ArtifactoryManager artifactoryManager, Log logger, DockerUtils.CommandType cmdType) throws IOException {
        String ImagePath = DockerUtils.getImagePath(this.imageTag);
        ArrayList<String> manifestPathCandidate = new ArrayList<String>(DockerUtils.getArtManifestPath(ImagePath, this.targetRepo, cmdType));
        logger.info("Searching manifest for image \"" + this.imageTag + "\" in \"" + artifactoryManager.getUrl() + "\" under \"" + this.targetRepo + "\" repository");
        int listLen = manifestPathCandidate.size();
        for (int i = 0; i < listLen; ++i) {
            try {
                logger.info("Searching manifest in path: " + manifestPathCandidate.get(i));
                this.checkAndSetManifestAndImagePathCandidates(manifestPathCandidate.get(i), artifactoryManager, logger);
                return;
            }
            catch (IOException e) {
                logger.info("The search failed with \"" + e.getMessage() + "\".");
                if (i != listLen - 1) continue;
                throw e;
            }
        }
    }
}

