/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.build.extractor.docker.extractor;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.util.EntityUtils;
import org.jfrog.build.api.Build;
import org.jfrog.build.api.Module;
import org.jfrog.build.api.util.Log;
import org.jfrog.build.extractor.clientConfiguration.ArtifactoryBuildInfoClientBuilder;
import org.jfrog.build.extractor.clientConfiguration.ArtifactoryClientConfiguration;
import org.jfrog.build.extractor.clientConfiguration.ArtifactoryDependenciesClientBuilder;
import org.jfrog.build.extractor.clientConfiguration.client.ArtifactoryBuildInfoClient;
import org.jfrog.build.extractor.clientConfiguration.util.DeploymentUrlUtils;
import org.jfrog.build.extractor.docker.DockerJavaWrapper;
import org.jfrog.build.extractor.docker.DockerUtils;
import org.jfrog.build.extractor.docker.extractor.DockerCommand;
import org.jfrog.build.extractor.docker.types.DockerImage;
import org.jfrog.build.extractor.docker.types.DockerLayer;
import org.jfrog.build.extractor.docker.types.DockerLayers;
import org.jfrog.build.extractor.packageManager.PackageManagerUtils;

public class DockerPush
extends DockerCommand {
    private final ArrayListMultimap<String, String> artifactProperties;

    public DockerPush(ArtifactoryBuildInfoClientBuilder buildInfoClientBuilder, ArtifactoryDependenciesClientBuilder dependenciesClientBuilder, String imageTag, String host, ArrayListMultimap<String, String> artifactProperties, String targetRepository, String username, String password, Log logger, Map<String, String> env) {
        super(buildInfoClientBuilder, dependenciesClientBuilder, imageTag, host, targetRepository, username, password, logger, env);
        this.artifactProperties = artifactProperties;
    }

    public static void main(String[] ignored) {
        try {
            ArtifactoryClientConfiguration clientConfiguration = PackageManagerUtils.createArtifactoryClientConfiguration();
            ArtifactoryBuildInfoClientBuilder buildInfoClientBuilder = (ArtifactoryBuildInfoClientBuilder)new ArtifactoryBuildInfoClientBuilder().setClientConfiguration(clientConfiguration, (ArtifactoryClientConfiguration.RepositoryConfiguration)clientConfiguration.publisher);
            ArtifactoryDependenciesClientBuilder dependenciesClientBuilder = (ArtifactoryDependenciesClientBuilder)new ArtifactoryDependenciesClientBuilder().setClientConfiguration(clientConfiguration, (ArtifactoryClientConfiguration.RepositoryConfiguration)clientConfiguration.publisher);
            ArtifactoryClientConfiguration.DockerHandler dockerHandler = clientConfiguration.dockerHandler;
            DockerPush dockerPush = new DockerPush(buildInfoClientBuilder, dependenciesClientBuilder, dockerHandler.getImageTag(), dockerHandler.getHost(), (ArrayListMultimap<String, String>)ArrayListMultimap.create((Multimap)clientConfiguration.publisher.getMatrixParams().asMultimap()), clientConfiguration.publisher.getRepoKey(), clientConfiguration.publisher.getUsername(), clientConfiguration.publisher.getPassword(), clientConfiguration.getLog(), clientConfiguration.getAllProperties());
            dockerPush.executeAndSaveBuildInfo(clientConfiguration);
        }
        catch (RuntimeException e) {
            ExceptionUtils.printRootCauseStackTrace((Throwable)e, (PrintStream)System.out);
            System.exit(1);
        }
    }

    public Build execute() {
        String message = "Pushing image: " + this.imageTag;
        if (StringUtils.isNotEmpty((String)this.host)) {
            message = message + " using docker daemon host: " + this.host;
        }
        this.logger.info(message);
        try {
            DockerJavaWrapper.pushImage(this.imageTag, this.username, this.password, this.host, this.env, this.logger);
            String imageId = DockerJavaWrapper.getImageIdFromTag(this.imageTag, this.host, this.env, this.logger);
            DockerImage image = new DockerImage(imageId, this.imageTag, this.targetRepository, this.buildInfoClientBuilder, this.dependenciesClientBuilder, "", "");
            Module module = image.generateBuildInfoModule(this.logger, DockerUtils.CommandType.Push);
            if (module.getArtifacts() == null || module.getArtifacts().size() == 0) {
                this.logger.warn("Could not find docker image: " + this.imageTag + " in Artifactory.");
            } else {
                this.setImageLayersProps(image.getLayers(), this.artifactProperties, this.buildInfoClientBuilder);
            }
            Build build = new Build();
            this.modulesList.add(module);
            build.setModules(this.modulesList);
            this.logger.info("Successfully pushed docker image: " + this.imageTag);
            return build;
        }
        catch (IOException | InterruptedException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void setImageLayersProps(DockerLayers layers, ArrayListMultimap<String, String> artifactProperties, ArtifactoryBuildInfoClientBuilder buildInfoClientBuilder) throws IOException {
        if (layers == null) {
            return;
        }
        String artifactsPropsStr = DeploymentUrlUtils.buildMatrixParamsString(artifactProperties, (boolean)false);
        try (ArtifactoryBuildInfoClient buildInfoClient = buildInfoClientBuilder.build();){
            for (DockerLayer layer : layers.getLayers()) {
                HttpEntity entity = null;
                try (CloseableHttpResponse httpResponse = buildInfoClient.executeUpdateFileProperty(layer.getFullPath(), artifactsPropsStr);){
                    entity = httpResponse.getEntity();
                    this.validateSetImageLayersResponse((HttpResponse)httpResponse);
                }
                catch (Throwable throwable) {
                    EntityUtils.consume(entity);
                    throw throwable;
                    return;
                }
                EntityUtils.consume((HttpEntity)entity);
            }
        }
    }

    private void validateSetImageLayersResponse(HttpResponse httpResponse) throws IOException {
        int code = httpResponse.getStatusLine().getStatusCode();
        if (code != 204) {
            String response = DockerUtils.entityToString(httpResponse.getEntity());
            throw new IOException("Failed while trying to set properties on docker layer: " + response);
        }
    }
}

