/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.build.client;

import java.io.IOException;
import java.io.InputStream;
import java.security.GeneralSecurityException;
import java.util.Properties;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.auth.AuthScheme;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.AuthCache;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.config.Lookup;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.DefaultHostnameVerifier;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.TrustAllStrategy;
import org.apache.http.conn.util.PublicSuffixMatcher;
import org.apache.http.conn.util.PublicSuffixMatcherLoader;
import org.apache.http.impl.auth.BasicScheme;
import org.apache.http.impl.client.BasicAuthCache;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.impl.cookie.DefaultCookieSpecProvider;
import org.apache.http.impl.cookie.IgnoreSpecProvider;
import org.apache.http.impl.cookie.NetscapeDraftSpecProvider;
import org.apache.http.impl.cookie.RFC6265CookieSpecProvider;
import org.apache.http.ssl.SSLContextBuilder;
import org.apache.http.ssl.TrustStrategy;
import org.jfrog.build.api.util.Log;
import org.jfrog.build.client.PreemptiveHttpClient;
import org.jfrog.build.client.ProxyConfiguration;

public class PreemptiveHttpClientBuilder {
    public static final int CONNECTION_POOL_SIZE = 10;
    private static final String CLIENT_VERSION;
    protected final BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
    protected PoolingHttpClientConnectionManager connectionManager;
    protected AuthCache authCache = new BasicAuthCache();
    protected String accessToken = "";
    protected int connectionRetries;
    protected Log log;
    private ProxyConfiguration proxyConfiguration;
    private String userAgent = "";
    private String userName = "";
    private String password = "";
    private SSLContext sslContext;
    private boolean insecureTls;
    private HttpHost proxy;
    private int timeout;

    public PreemptiveHttpClientBuilder setUserAgent(String userAgent) {
        this.userAgent = userAgent;
        return this;
    }

    public PreemptiveHttpClientBuilder setUserName(String userName) {
        this.userName = userName;
        return this;
    }

    public PreemptiveHttpClientBuilder setPassword(String password) {
        this.password = password;
        return this;
    }

    public PreemptiveHttpClientBuilder setAccessToken(String accessToken) {
        this.accessToken = accessToken;
        return this;
    }

    public PreemptiveHttpClientBuilder setTimeout(int timeout) {
        this.timeout = timeout;
        return this;
    }

    public PreemptiveHttpClientBuilder setProxyConfiguration(ProxyConfiguration proxyConfiguration) {
        this.proxyConfiguration = proxyConfiguration;
        if (proxyConfiguration != null) {
            this.proxy = new HttpHost(proxyConfiguration.host, proxyConfiguration.port);
        }
        return this;
    }

    public ProxyConfiguration getProxyConfiguration() {
        return this.proxyConfiguration;
    }

    public PreemptiveHttpClientBuilder setConnectionRetries(int connectionRetries) {
        this.connectionRetries = connectionRetries;
        return this;
    }

    public PreemptiveHttpClientBuilder setInsecureTls(boolean insecureTls) {
        this.insecureTls = insecureTls;
        return this;
    }

    public PreemptiveHttpClientBuilder setLog(Log log) {
        this.log = log;
        return this;
    }

    public PreemptiveHttpClientBuilder setSslContext(SSLContext sslContext) {
        this.sslContext = sslContext;
        return this;
    }

    public PreemptiveHttpClient build() {
        this.buildConnectionManager();
        HttpClientBuilder httpClientBuilder = this.createHttpClientBuilder();
        this.createCredentialsAndAuthCache();
        return new PreemptiveHttpClient(this.connectionManager, this.credentialsProvider, this.accessToken, this.authCache, httpClientBuilder, this.connectionRetries, this.log);
    }

    protected void createCredentialsAndAuthCache() {
        if (this.proxyConfiguration != null && this.proxyConfiguration.username != null) {
            this.credentialsProvider.setCredentials(new AuthScope(this.proxyConfiguration.host, this.proxyConfiguration.port), (Credentials)new UsernamePasswordCredentials(this.proxyConfiguration.username, this.proxyConfiguration.password));
            this.authCache = new BasicAuthCache();
            this.authCache.put(this.proxy, (AuthScheme)new BasicScheme());
        }
        if (StringUtils.isEmpty((CharSequence)this.accessToken)) {
            if (StringUtils.isEmpty((CharSequence)this.userName)) {
                this.userName = "anonymous";
                this.password = "";
            }
            this.credentialsProvider.setCredentials(new AuthScope(AuthScope.ANY_HOST, -1), (Credentials)new UsernamePasswordCredentials(this.userName, this.password));
        }
    }

    protected void buildConnectionManager() {
        try {
            this.connectionManager = this.createConnectionManager();
        }
        catch (GeneralSecurityException e) {
            throw new RuntimeException(e);
        }
        this.connectionManager.setMaxTotal(10);
        this.connectionManager.setDefaultMaxPerRoute(10);
    }

    protected HttpClientBuilder createHttpClientBuilder() {
        int timeoutMilliSeconds = this.timeout * 1000;
        RequestConfig requestConfig = RequestConfig.custom().setSocketTimeout(timeoutMilliSeconds).setConnectTimeout(timeoutMilliSeconds).setConnectionRequestTimeout(timeoutMilliSeconds).setCircularRedirectsAllowed(true).build();
        HttpClientBuilder builder = HttpClientBuilder.create().setConnectionManager((HttpClientConnectionManager)this.connectionManager).setDefaultRequestConfig(requestConfig);
        builder.addInterceptorFirst((HttpRequestInterceptor)new PreemptiveHttpClient.PreemptiveAuth());
        String userAgent = (String)StringUtils.defaultIfEmpty((CharSequence)this.userAgent, (CharSequence)("ArtifactoryBuildClient/" + CLIENT_VERSION));
        builder.setUserAgent(userAgent);
        this.setDefaultCookieSpecRegistry(builder);
        builder.setProxy(this.proxy);
        return builder;
    }

    private PoolingHttpClientConnectionManager createConnectionManager() throws GeneralSecurityException {
        if (!this.insecureTls && this.sslContext == null) {
            return new PoolingHttpClientConnectionManager();
        }
        DefaultHostnameVerifier hostnameVerifier = new DefaultHostnameVerifier();
        SSLContext sslContext = this.sslContext;
        if (this.insecureTls) {
            TrustAllStrategy strategy = TrustAllStrategy.INSTANCE;
            sslContext = SSLContextBuilder.create().loadTrustMaterial((TrustStrategy)strategy).build();
            hostnameVerifier = NoopHostnameVerifier.INSTANCE;
        }
        SSLConnectionSocketFactory sslConnectionSocketFactory = new SSLConnectionSocketFactory(sslContext, (HostnameVerifier)hostnameVerifier);
        Registry socketFactoryRegistry = RegistryBuilder.create().register("http", (Object)PlainConnectionSocketFactory.getSocketFactory()).register("https", (Object)sslConnectionSocketFactory).build();
        return new PoolingHttpClientConnectionManager(socketFactoryRegistry);
    }

    private void setDefaultCookieSpecRegistry(HttpClientBuilder clientBuilder) {
        PublicSuffixMatcher publicSuffixMatcher = PublicSuffixMatcherLoader.getDefault();
        clientBuilder.setPublicSuffixMatcher(publicSuffixMatcher);
        DefaultCookieSpecProvider defaultProvider = new DefaultCookieSpecProvider(DefaultCookieSpecProvider.CompatibilityLevel.DEFAULT, publicSuffixMatcher, new String[]{"EEE, dd-MMM-yy HH:mm:ss z", "EEE, dd-MMM-yy HH:mm:ss zzz", "EEE MMM d HH:mm:ss yyyy", "EEE, dd MMM yyyy HH:mm:ss zzz"}, false);
        RFC6265CookieSpecProvider laxStandardProvider = new RFC6265CookieSpecProvider(RFC6265CookieSpecProvider.CompatibilityLevel.RELAXED, publicSuffixMatcher);
        RFC6265CookieSpecProvider strictStandardProvider = new RFC6265CookieSpecProvider(RFC6265CookieSpecProvider.CompatibilityLevel.STRICT, publicSuffixMatcher);
        clientBuilder.setDefaultCookieSpecRegistry((Lookup)RegistryBuilder.create().register("default", (Object)defaultProvider).register("best-match", (Object)defaultProvider).register("compatibility", (Object)defaultProvider).register("standard", (Object)laxStandardProvider).register("standard-strict", (Object)strictStandardProvider).register("netscape", (Object)new NetscapeDraftSpecProvider()).register("ignoreCookies", (Object)new IgnoreSpecProvider()).build());
    }

    static {
        Properties properties = new Properties();
        try (InputStream is = PreemptiveHttpClient.class.getResourceAsStream("/bi.client.properties");){
            properties.load(is);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        CLIENT_VERSION = properties.getProperty("client.version", "unknown");
    }
}

