/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.build.client;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import javax.net.ssl.SSLException;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpException;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.HttpResponse;
import org.apache.http.ProtocolException;
import org.apache.http.auth.AuthScheme;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.AuthState;
import org.apache.http.auth.Credentials;
import org.apache.http.client.AuthCache;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.HttpRequestRetryHandler;
import org.apache.http.client.RedirectStrategy;
import org.apache.http.client.ServiceUnavailableRetryStrategy;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpRequestWrapper;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.methods.RequestBuilder;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.impl.auth.BasicScheme;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.DefaultHttpRequestRetryHandler;
import org.apache.http.impl.client.DefaultRedirectStrategy;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.protocol.HttpContext;
import org.jfrog.build.api.util.CommonUtils;
import org.jfrog.build.api.util.Log;

public class PreemptiveHttpClient
implements AutoCloseable {
    private static final boolean REQUEST_SENT_RETRY_ENABLED = true;
    private static final String ORIGINAL_HOST_CONTEXT_PARAM = "original.host.context.param";
    BasicCredentialsProvider basicCredentialsProvider;
    private final PoolingHttpClientConnectionManager connectionManager;
    private final String accessToken;
    private final AuthCache authCache;
    private final CloseableHttpClient httpClient;
    private final int connectionRetries;
    private Log log;

    public PreemptiveHttpClient(PoolingHttpClientConnectionManager connectionManager, BasicCredentialsProvider credentialsProvider, String accessToken, AuthCache authCache, HttpClientBuilder clientBuilder, int connectionRetries, Log log) {
        this.connectionManager = connectionManager;
        this.basicCredentialsProvider = credentialsProvider;
        this.accessToken = accessToken;
        this.authCache = authCache;
        this.connectionRetries = connectionRetries;
        this.log = log;
        int retryCount = connectionRetries < 0 ? 3 : connectionRetries;
        clientBuilder.setRetryHandler((HttpRequestRetryHandler)new PreemptiveRetryHandler(retryCount));
        clientBuilder.setServiceUnavailableRetryStrategy((ServiceUnavailableRetryStrategy)new PreemptiveRetryStrategy());
        clientBuilder.setRedirectStrategy((RedirectStrategy)new PreemptiveRedirectStrategy());
        this.httpClient = clientBuilder.build();
    }

    public CloseableHttpResponse execute(HttpUriRequest request) throws IOException {
        HttpClientContext clientContext = HttpClientContext.create();
        if (StringUtils.isNotEmpty((CharSequence)this.accessToken)) {
            clientContext.setUserToken((Object)this.accessToken);
        } else {
            clientContext.setCredentialsProvider((CredentialsProvider)this.basicCredentialsProvider);
        }
        if (this.authCache != null) {
            clientContext.setAuthCache(this.authCache);
        }
        return this.httpClient.execute(request, (HttpContext)clientContext);
    }

    @Override
    public void close() {
        try {
            this.httpClient.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.connectionManager.close();
    }

    public void setLog(Log log) {
        this.log = log;
    }

    private Set<Class<? extends IOException>> getNonRetriableClasses() {
        HashSet<Class<? extends IOException>> classSet = new HashSet<Class<? extends IOException>>();
        classSet.add(SSLException.class);
        return classSet;
    }

    private class PreemptiveRedirectStrategy
    extends DefaultRedirectStrategy {
        private final Set<String> redirectableMethods = CommonUtils.newHashSet((Object[])new String[]{"GET".toLowerCase(), "POST".toLowerCase(), "HEAD".toLowerCase(), "DELETE".toLowerCase(), "PUT".toLowerCase()});

        private PreemptiveRedirectStrategy() {
        }

        public HttpUriRequest getRedirect(HttpRequest request, HttpResponse response, HttpContext context) throws ProtocolException {
            String originalHost = this.getHost(request);
            context.setAttribute(PreemptiveHttpClient.ORIGINAL_HOST_CONTEXT_PARAM, (Object)originalHost);
            URI uri = this.getLocationURI(request, response, context);
            PreemptiveHttpClient.this.log.debug("Redirecting to " + uri);
            return RequestBuilder.copy((HttpRequest)request).setUri(uri).build();
        }

        private String getHost(HttpRequest request) {
            URI uri;
            try {
                uri = new URI(request.getRequestLine().getUri());
            }
            catch (URISyntaxException e) {
                throw new RuntimeException(e);
            }
            return uri.getHost();
        }

        protected boolean isRedirectable(String method) {
            String message = "The method " + method;
            if (this.redirectableMethods.contains(method.toLowerCase())) {
                PreemptiveHttpClient.this.log.debug(message + " can be redirected.");
                return true;
            }
            PreemptiveHttpClient.this.log.error(message + " cannot be redirected.");
            return false;
        }
    }

    private class PreemptiveRetryHandler
    extends DefaultHttpRequestRetryHandler {
        PreemptiveRetryHandler(int connectionRetries) {
            super(connectionRetries, true, (Collection)PreemptiveHttpClient.this.getNonRetriableClasses());
        }

        public boolean retryRequest(IOException exception, int executionCount, HttpContext context) {
            HttpClientContext clientContext = HttpClientContext.adapt((HttpContext)context);
            PreemptiveHttpClient.this.log.warn("Error occurred for request " + clientContext.getRequest().getRequestLine().toString() + ": " + exception.getMessage() + ".");
            if (executionCount > PreemptiveHttpClient.this.connectionRetries) {
                return false;
            }
            boolean shouldRetry = super.retryRequest(exception, executionCount, context);
            if (shouldRetry) {
                PreemptiveHttpClient.this.log.warn("Attempting retry #" + executionCount);
                return true;
            }
            return false;
        }
    }

    private class PreemptiveRetryStrategy
    implements ServiceUnavailableRetryStrategy {
        private PreemptiveRetryStrategy() {
        }

        public boolean retryRequest(HttpResponse response, int executionCount, HttpContext context) {
            if (response.getStatusLine().getStatusCode() > 500) {
                HttpClientContext clientContext = HttpClientContext.adapt((HttpContext)context);
                PreemptiveHttpClient.this.log.warn("Error occurred for request " + clientContext.getRequest().getRequestLine().toString() + ". Received status code " + response.getStatusLine().getStatusCode() + " and message: " + response.getStatusLine().getReasonPhrase() + ".");
                if (executionCount <= PreemptiveHttpClient.this.connectionRetries) {
                    PreemptiveHttpClient.this.log.warn("Attempting retry #" + executionCount);
                    return true;
                }
            }
            return false;
        }

        public long getRetryInterval() {
            return 0L;
        }
    }

    static class PreemptiveAuth
    implements HttpRequestInterceptor {
        PreemptiveAuth() {
        }

        public void process(HttpRequest request, HttpContext context) throws HttpException {
            if (!this.shouldSetAuthScheme(request, context)) {
                return;
            }
            HttpClientContext finalContext = (HttpClientContext)context;
            AuthState authState = finalContext.getTargetAuthState();
            if (authState.getAuthScheme() == null) {
                String accessToken = (String)finalContext.getUserToken(String.class);
                if (StringUtils.isNotEmpty((CharSequence)accessToken)) {
                    request.addHeader("Authorization", "Bearer " + accessToken);
                } else {
                    HttpHost targetHost;
                    CredentialsProvider credsProvider = finalContext.getCredentialsProvider();
                    Credentials creds = credsProvider.getCredentials(new AuthScope((targetHost = finalContext.getTargetHost()).getHostName(), targetHost.getPort()));
                    if (creds == null) {
                        throw new HttpException("No credentials for preemptive authentication");
                    }
                    BasicScheme authScheme = new BasicScheme();
                    authState.update((AuthScheme)authScheme, creds);
                }
            }
        }

        private boolean shouldSetAuthScheme(HttpRequest request, HttpContext context) {
            String host;
            String originalHost = (String)context.getAttribute(PreemptiveHttpClient.ORIGINAL_HOST_CONTEXT_PARAM);
            if (originalHost == null) {
                return true;
            }
            try {
                host = new URI(((HttpRequestWrapper)request).getOriginal().getRequestLine().getUri()).getHost();
            }
            catch (URISyntaxException e) {
                throw new RuntimeException(e);
            }
            return host.equals(originalHost);
        }
    }
}

