/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.build.api;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.jfrog.build.api.Agent;
import org.jfrog.build.api.BaseBuildBean;
import org.jfrog.build.api.BuildAgent;
import org.jfrog.build.api.BuildRetention;
import org.jfrog.build.api.Issues;
import org.jfrog.build.api.MatrixParameter;
import org.jfrog.build.api.Module;
import org.jfrog.build.api.Vcs;
import org.jfrog.build.api.dependency.BuildDependency;
import org.jfrog.build.api.release.PromotionStatus;

@JsonIgnoreProperties(ignoreUnknown=true, value={"project", "startedMillis"})
public class Build
extends BaseBuildBean {
    public static final String STARTED_FORMAT = "yyyy-MM-dd'T'HH:mm:ss.SSSZ";
    private String version = "1.0.1";
    private String name;
    private String number;
    private String project;
    private BuildAgent buildAgent;
    private Agent agent;
    private String started;
    private long startedMillis;
    private long durationMillis;
    private String principal;
    private String artifactoryPrincipal;
    private String artifactoryPluginVersion;
    private String url;
    private String parentName;
    private String parentNumber;
    private List<Vcs> vcs;
    @Deprecated
    private String parentBuildId;
    private BuildRetention buildRetention;
    private List<MatrixParameter> runParameters;
    private List<Module> modules;
    private List<PromotionStatus> statuses;
    private List<BuildDependency> buildDependencies;
    private Issues issues;

    public static String formatBuildStarted(long timestamp) {
        SimpleDateFormat dateFormat = new SimpleDateFormat(STARTED_FORMAT);
        return dateFormat.format(timestamp);
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getNumber() {
        return this.number;
    }

    public void setNumber(String number) {
        this.number = number;
    }

    public String getProject() {
        return this.project;
    }

    public void setProject(String project) {
        this.project = project;
    }

    public String getParentName() {
        return this.parentName;
    }

    public void setParentName(String parentName) {
        this.parentName = parentName;
    }

    public String getParentNumber() {
        return this.parentNumber;
    }

    public void setParentNumber(String parentNumber) {
        this.parentNumber = parentNumber;
    }

    public List<Vcs> getVcs() {
        return this.vcs;
    }

    public void setVcs(List<Vcs> vcs) {
        this.vcs = vcs;
    }

    public Agent getAgent() {
        return this.agent;
    }

    public void setAgent(Agent agent) {
        this.agent = agent;
    }

    public BuildAgent getBuildAgent() {
        return this.buildAgent;
    }

    public void setBuildAgent(BuildAgent buildAgent) {
        this.buildAgent = buildAgent;
    }

    public String getStarted() {
        return this.started;
    }

    public long getStartedMillis() {
        return this.startedMillis;
    }

    public void setStartedMillis(long startedMillis) {
        this.startedMillis = startedMillis;
    }

    public void setStarted(String started) {
        this.started = started;
    }

    public void setStartedDate(Date startedDate) {
        this.startedMillis = startedDate.getTime();
        this.started = Build.formatBuildStarted(this.startedMillis);
    }

    public long getDurationMillis() {
        return this.durationMillis;
    }

    public void setDurationMillis(long durationMillis) {
        this.durationMillis = durationMillis;
    }

    public String getPrincipal() {
        return this.principal;
    }

    public void setPrincipal(String principal) {
        this.principal = principal;
    }

    public String getArtifactoryPrincipal() {
        return this.artifactoryPrincipal;
    }

    public void setArtifactoryPrincipal(String artifactoryPrincipal) {
        this.artifactoryPrincipal = artifactoryPrincipal;
    }

    public String getArtifactoryPluginVersion() {
        return this.artifactoryPluginVersion;
    }

    public void setArtifactoryPluginVersion(String artifactoryPluginVersion) {
        this.artifactoryPluginVersion = artifactoryPluginVersion;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    @Deprecated
    public String getParentBuildId() {
        return this.parentBuildId;
    }

    @Deprecated
    public void setParentBuildId(String parentBuildId) {
        this.parentBuildId = parentBuildId;
    }

    public List<Module> getModules() {
        return this.modules;
    }

    public void setModules(List<Module> modules) {
        this.modules = modules;
    }

    public Module getModule(String moduleId) {
        if (this.modules != null) {
            for (Module module : this.modules) {
                if (!module.getId().equals(moduleId)) continue;
                return module;
            }
        }
        return null;
    }

    public BuildRetention getBuildRetention() {
        return this.buildRetention;
    }

    public void setBuildRetention(BuildRetention buildRetention) {
        this.buildRetention = buildRetention;
    }

    public List<MatrixParameter> getRunParameters() {
        return this.runParameters;
    }

    public void setRunParameters(List<MatrixParameter> runParameters) {
        this.runParameters = runParameters;
    }

    public List<PromotionStatus> getStatuses() {
        return this.statuses;
    }

    public void setStatuses(List<PromotionStatus> statuses) {
        this.statuses = statuses;
    }

    public void addStatus(PromotionStatus promotionStatus) {
        if (this.statuses == null) {
            this.statuses = new ArrayList<PromotionStatus>();
        }
        this.statuses.add(promotionStatus);
    }

    public List<BuildDependency> getBuildDependencies() {
        return this.buildDependencies;
    }

    public void setBuildDependencies(List<BuildDependency> buildDependencies) {
        this.buildDependencies = buildDependencies;
    }

    public Issues getIssues() {
        return this.issues;
    }

    public void setIssues(Issues issues) {
        this.issues = issues;
    }

    public String toString() {
        return "Build{version='" + this.version + '\'' + ", name='" + this.name + '\'' + ", number='" + this.number + '\'' + ", buildAgent=" + this.buildAgent + ", agent=" + this.agent + ", started='" + this.started + '\'' + ", durationMillis=" + this.durationMillis + ", principal='" + this.principal + '\'' + ", artifactoryPrincipal='" + this.artifactoryPrincipal + '\'' + ", artifactoryPluginVersion='" + this.artifactoryPluginVersion + '\'' + ", url='" + this.url + '\'' + ", parentName='" + this.parentName + '\'' + ", parentNumber='" + this.parentNumber + '\'' + ", vcs='" + this.vcs + '\'' + ", parentBuildId='" + this.parentBuildId + '\'' + ", buildRetention=" + this.buildRetention + ", runParameters=" + this.runParameters + ", modules=" + this.modules + ", statuses=" + this.statuses + ", buildDependencies=" + this.buildDependencies + ", issues=" + this.issues + '}';
    }
}

