/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.build.api.builder;

import com.google.common.collect.Lists;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import org.apache.commons.lang.StringUtils;
import org.jfrog.build.api.Agent;
import org.jfrog.build.api.Build;
import org.jfrog.build.api.BuildAgent;
import org.jfrog.build.api.BuildRetention;
import org.jfrog.build.api.BuildType;
import org.jfrog.build.api.Governance;
import org.jfrog.build.api.Issues;
import org.jfrog.build.api.LicenseControl;
import org.jfrog.build.api.Module;
import org.jfrog.build.api.release.PromotionStatus;

public class BuildInfoBuilder {
    private String version;
    private String name;
    private String started;
    private String number;
    private BuildType type;
    private Agent agent;
    private BuildAgent buildAgent;
    private long durationMillis;
    private String principal;
    private String artifactoryPrincipal;
    private String url;
    private String parentName;
    private String parentNumber;
    private String vcsRevision;
    private String vcsUrl;
    private List<Module> modules;
    private List<PromotionStatus> statuses;
    private Properties properties;
    private LicenseControl licenseControl;
    private BuildRetention buildRetention;
    private Issues issues;
    private Governance governance;

    public BuildInfoBuilder(String name) {
        this.name = name;
    }

    public Build build() {
        if (StringUtils.isBlank((String)this.name)) {
            throw new IllegalArgumentException("Build must have a name");
        }
        if (StringUtils.isBlank((String)this.number)) {
            throw new IllegalArgumentException("Build number must be set");
        }
        if (StringUtils.isBlank((String)this.started)) {
            throw new IllegalArgumentException("Build start time must be set");
        }
        Build build = new Build();
        if (StringUtils.isNotBlank((String)this.version)) {
            build.setVersion(this.version);
        }
        build.setName(this.name);
        build.setNumber(this.number);
        build.setType(this.type);
        build.setAgent(this.agent);
        build.setBuildAgent(this.buildAgent);
        build.setStarted(this.started);
        build.setDurationMillis(this.durationMillis);
        build.setPrincipal(this.principal);
        build.setArtifactoryPrincipal(this.artifactoryPrincipal);
        build.setUrl(this.url);
        build.setParentName(this.parentName);
        build.setParentNumber(this.parentNumber);
        build.setModules(this.modules);
        build.setStatuses(this.statuses);
        build.setProperties(this.properties);
        build.setVcsRevision(this.vcsRevision);
        build.setVcsUrl(this.vcsUrl);
        build.setLicenseControl(this.licenseControl);
        build.setBuildRetention(this.buildRetention);
        build.setIssues(this.issues);
        build.setGovernance(this.governance);
        return build;
    }

    public BuildInfoBuilder version(String version) {
        this.version = version;
        return this;
    }

    public BuildInfoBuilder name(String name) {
        this.name = name;
        return this;
    }

    public BuildInfoBuilder number(String number) {
        this.number = number;
        return this;
    }

    public BuildInfoBuilder type(BuildType type) {
        this.type = type;
        return this;
    }

    public BuildInfoBuilder agent(Agent agent) {
        this.agent = agent;
        return this;
    }

    public BuildInfoBuilder buildAgent(BuildAgent buildAgent) {
        this.buildAgent = buildAgent;
        return this;
    }

    public BuildInfoBuilder started(String started) {
        this.started = started;
        return this;
    }

    public BuildInfoBuilder startedDate(Date startedDate) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ");
        this.started = simpleDateFormat.format(startedDate);
        return this;
    }

    public BuildInfoBuilder durationMillis(long durationMillis) {
        this.durationMillis = durationMillis;
        return this;
    }

    public BuildInfoBuilder principal(String principal) {
        this.principal = principal;
        return this;
    }

    public BuildInfoBuilder artifactoryPrincipal(String artifactoryPrincipal) {
        this.artifactoryPrincipal = artifactoryPrincipal;
        return this;
    }

    public BuildInfoBuilder url(String url) {
        this.url = url;
        return this;
    }

    public BuildInfoBuilder parentName(String parentName) {
        this.parentName = parentName;
        return this;
    }

    public BuildInfoBuilder parentNumber(String parentNumber) {
        this.parentNumber = parentNumber;
        return this;
    }

    public BuildInfoBuilder vcsRevision(String vcsRevision) {
        this.vcsRevision = vcsRevision;
        return this;
    }

    public BuildInfoBuilder vcsUrl(String vcsUrl) {
        this.vcsUrl = vcsUrl;
        return this;
    }

    public BuildInfoBuilder modules(List<Module> modules) {
        this.modules = modules;
        return this;
    }

    public BuildInfoBuilder statuses(List<PromotionStatus> statuses) {
        this.statuses = statuses;
        return this;
    }

    public BuildInfoBuilder addStatus(PromotionStatus promotionStatus) {
        if (this.statuses == null) {
            this.statuses = Lists.newArrayList();
        }
        this.statuses.add(promotionStatus);
        return this;
    }

    public BuildInfoBuilder licenseControl(LicenseControl licenseControl) {
        this.licenseControl = licenseControl;
        return this;
    }

    public BuildInfoBuilder buildRetention(BuildRetention buildRetention) {
        this.buildRetention = buildRetention;
        return this;
    }

    public BuildInfoBuilder addModule(Module module) {
        if (this.modules == null) {
            this.modules = Lists.newArrayList();
        }
        this.modules.add(module);
        return this;
    }

    public BuildInfoBuilder properties(Properties properties) {
        this.properties = properties;
        return this;
    }

    public BuildInfoBuilder addProperty(Object key, Object value) {
        if (this.properties == null) {
            this.properties = new Properties();
        }
        this.properties.put(key, value);
        return this;
    }

    public BuildInfoBuilder issues(Issues issues) {
        this.issues = issues;
        return this;
    }

    public BuildInfoBuilder governance(Governance governance) {
        this.governance = governance;
        return this;
    }
}

