/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.build.api;

import com.google.common.collect.Lists;
import com.thoughtworks.xstream.annotations.XStreamAlias;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import org.jfrog.build.api.Agent;
import org.jfrog.build.api.BaseBuildBean;
import org.jfrog.build.api.BuildAgent;
import org.jfrog.build.api.BuildRetention;
import org.jfrog.build.api.BuildType;
import org.jfrog.build.api.Governance;
import org.jfrog.build.api.Issues;
import org.jfrog.build.api.LicenseControl;
import org.jfrog.build.api.Module;
import org.jfrog.build.api.dependency.BuildDependency;
import org.jfrog.build.api.release.PromotionStatus;

@XStreamAlias(value="build")
public class Build
extends BaseBuildBean {
    public static final String STARTED_FORMAT = "yyyy-MM-dd'T'HH:mm:ss.SSSZ";
    private String version = "1.0.1";
    private String name;
    private String number;
    @Deprecated
    private BuildType type;
    private BuildAgent buildAgent;
    private Agent agent;
    private String started;
    private long durationMillis;
    private String principal;
    private String artifactoryPrincipal;
    private String url;
    private String parentName;
    private String parentNumber;
    private String vcsRevision;
    @Deprecated
    private String parentBuildId;
    private LicenseControl licenseControl;
    private BuildRetention buildRetention;
    @XStreamAlias(value="modules")
    private List<Module> modules;
    private List<PromotionStatus> statuses;
    private List<BuildDependency> buildDependencies;
    private Issues issues;
    private Governance governance;

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getNumber() {
        return this.number;
    }

    public void setNumber(String number) {
        this.number = number;
    }

    public String getParentName() {
        return this.parentName;
    }

    public void setParentName(String parentName) {
        this.parentName = parentName;
    }

    public String getParentNumber() {
        return this.parentNumber;
    }

    public void setParentNumber(String parentNumber) {
        this.parentNumber = parentNumber;
    }

    public String getVcsRevision() {
        return this.vcsRevision;
    }

    public void setVcsRevision(String vcsRevision) {
        this.vcsRevision = vcsRevision;
    }

    @Deprecated
    public BuildType getType() {
        return this.type;
    }

    @Deprecated
    public void setType(BuildType type) {
        this.type = type;
    }

    public Agent getAgent() {
        return this.agent;
    }

    public void setAgent(Agent agent) {
        this.agent = agent;
    }

    public BuildAgent getBuildAgent() {
        return this.buildAgent;
    }

    public void setBuildAgent(BuildAgent buildAgent) {
        this.buildAgent = buildAgent;
    }

    public String getStarted() {
        return this.started;
    }

    public void setStarted(String started) {
        this.started = started;
    }

    public void setStartedDate(Date startedDate) {
        this.started = Build.formatBuildStarted(startedDate.getTime());
    }

    public long getDurationMillis() {
        return this.durationMillis;
    }

    public void setDurationMillis(long durationMillis) {
        this.durationMillis = durationMillis;
    }

    public String getPrincipal() {
        return this.principal;
    }

    public void setPrincipal(String principal) {
        this.principal = principal;
    }

    public String getArtifactoryPrincipal() {
        return this.artifactoryPrincipal;
    }

    public void setArtifactoryPrincipal(String artifactoryPrincipal) {
        this.artifactoryPrincipal = artifactoryPrincipal;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    @Deprecated
    public String getParentBuildId() {
        return this.parentBuildId;
    }

    @Deprecated
    public void setParentBuildId(String parentBuildId) {
        this.parentBuildId = parentBuildId;
    }

    public List<Module> getModules() {
        return this.modules;
    }

    public void setModules(List<Module> modules) {
        this.modules = modules;
    }

    public Module getModule(String moduleId) {
        if (this.modules != null) {
            for (Module module : this.modules) {
                if (!module.getId().equals(moduleId)) continue;
                return module;
            }
        }
        return null;
    }

    public LicenseControl getLicenseControl() {
        return this.licenseControl;
    }

    public void setLicenseControl(LicenseControl licenseControl) {
        this.licenseControl = licenseControl;
    }

    public void setBuildRetention(BuildRetention buildRetention) {
        this.buildRetention = buildRetention;
    }

    public BuildRetention getBuildRetention() {
        return this.buildRetention;
    }

    public List<PromotionStatus> getStatuses() {
        return this.statuses;
    }

    public void addStatus(PromotionStatus promotionStatus) {
        if (this.statuses == null) {
            this.statuses = Lists.newArrayList();
        }
        this.statuses.add(promotionStatus);
    }

    public void setStatuses(List<PromotionStatus> statuses) {
        this.statuses = statuses;
    }

    public static String formatBuildStarted(long timestamp) {
        SimpleDateFormat dateFormat = new SimpleDateFormat(STARTED_FORMAT);
        return dateFormat.format(timestamp);
    }

    public List<BuildDependency> getBuildDependencies() {
        return this.buildDependencies;
    }

    public void addBuildDependency(BuildDependency buildDependency) {
        if (this.buildDependencies == null) {
            this.buildDependencies = Lists.newArrayList();
        }
        this.buildDependencies.add(buildDependency);
    }

    public void setBuildDependencies(List<BuildDependency> buildDependencies) {
        this.buildDependencies = buildDependencies;
    }

    public Issues getIssues() {
        return this.issues;
    }

    public void setIssues(Issues issues) {
        this.issues = issues;
    }

    public Governance getGovernance() {
        return this.governance;
    }

    public void setGovernance(Governance governance) {
        this.governance = governance;
    }
}

