/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.build.api.builder;

import com.google.common.collect.Lists;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import org.jfrog.build.api.Dependency;

public class DependencyBuilder {
    private String id;
    private String type;
    private Set<String> scopes;
    private String sha1;
    private String sha256;
    private String md5;
    private String localPath;
    private String remotePath;
    private List<String> requiredBy;
    private Properties properties;

    public Dependency build() {
        Dependency dependency = new Dependency();
        dependency.setId(this.id);
        dependency.setType(this.type);
        dependency.setScopes(this.scopes);
        dependency.setSha1(this.sha1);
        dependency.setSha256(this.sha256);
        dependency.setMd5(this.md5);
        dependency.setLocalPath(this.localPath);
        dependency.setRemotePath(this.remotePath);
        dependency.setRequiredBy(this.requiredBy);
        dependency.setProperties(this.properties);
        return dependency;
    }

    public DependencyBuilder id(String id) {
        this.id = id;
        return this;
    }

    public DependencyBuilder type(String type) {
        this.type = type;
        return this;
    }

    public DependencyBuilder scopes(Set<String> scopes) {
        this.scopes = scopes;
        return this;
    }

    public DependencyBuilder addScope(String scope) {
        if (this.scopes == null) {
            this.scopes = new HashSet<String>();
        }
        this.scopes.add(scope);
        return this;
    }

    public DependencyBuilder sha1(String sha1) {
        this.sha1 = sha1;
        return this;
    }

    public DependencyBuilder sha256(String sha256) {
        this.sha256 = sha256;
        return this;
    }

    public DependencyBuilder md5(String md5) {
        this.md5 = md5;
        return this;
    }

    public DependencyBuilder localPath(String localPath) {
        this.localPath = localPath;
        return this;
    }

    public DependencyBuilder remotePath(String remotePath) {
        this.remotePath = remotePath;
        return this;
    }

    public DependencyBuilder requiredBy(List<String> requiredBy) {
        this.requiredBy = requiredBy;
        return this;
    }

    public DependencyBuilder addRequiredBy(String requiredBy) {
        if (this.requiredBy == null) {
            this.requiredBy = Lists.newArrayList();
        }
        this.requiredBy.add(requiredBy);
        return this;
    }

    public DependencyBuilder properties(Properties properties) {
        this.properties = properties;
        return this;
    }

    public DependencyBuilder addProperty(Object key, Object value) {
        if (this.properties == null) {
            this.properties = new Properties();
        }
        this.properties.put(key, value);
        return this;
    }
}

