/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.build.api;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.jfrog.build.api.Issue;
import org.jfrog.build.api.IssueTracker;

public class Issues
implements Serializable {
    private IssueTracker tracker;
    private boolean aggregateBuildIssues;
    private String aggregationBuildStatus;
    private Set<Issue> affectedIssues;

    public Issues() {
    }

    public Issues(IssueTracker tracker, boolean aggregateBuildIssues, String aggregationBuildStatus, Set<Issue> affectedIssues) {
        this.tracker = tracker;
        this.aggregateBuildIssues = aggregateBuildIssues;
        this.aggregationBuildStatus = aggregationBuildStatus;
        this.affectedIssues = affectedIssues;
    }

    public IssueTracker getTracker() {
        return this.tracker;
    }

    public void setTracker(IssueTracker tracker) {
        this.tracker = tracker;
    }

    public Set<Issue> getAffectedIssues() {
        return this.affectedIssues;
    }

    public void addIssue(Issue issue) {
        if (this.affectedIssues == null) {
            this.affectedIssues = new HashSet<Issue>();
        }
        this.affectedIssues.add(issue);
    }

    @JsonIgnore
    public boolean isEmpty() {
        if (this.tracker != null && StringUtils.isNotEmpty((String)this.aggregationBuildStatus)) {
            return false;
        }
        if (this.affectedIssues == null) {
            return true;
        }
        return this.affectedIssues.isEmpty();
    }

    public void setAffectedIssues(Set<Issue> affectedIssues) {
        this.affectedIssues = affectedIssues;
    }

    public boolean isAggregateBuildIssues() {
        return this.aggregateBuildIssues;
    }

    public void setAggregateBuildIssues(boolean aggregateBuildIssues) {
        this.aggregateBuildIssues = aggregateBuildIssues;
    }

    public String getAggregationBuildStatus() {
        return this.aggregationBuildStatus;
    }

    public void setAggregationBuildStatus(String aggregationBuildStatus) {
        this.aggregationBuildStatus = aggregationBuildStatus;
    }

    public void append(Issues other) {
        if (other == null || other.getTracker() == null || other.affectedIssues == null) {
            return;
        }
        if (this.getTracker() == null || this.affectedIssues == null) {
            this.setTracker(other.getTracker());
            this.aggregateBuildIssues = other.aggregateBuildIssues;
            this.aggregationBuildStatus = other.aggregationBuildStatus;
            this.affectedIssues = other.affectedIssues;
            return;
        }
        if (other.getTracker().getName().equals(this.getTracker().getName())) {
            this.appendAffectedIssues(other.affectedIssues);
        }
    }

    private void appendAffectedIssues(Set<Issue> otherAffectedIssues) {
        if (otherAffectedIssues == null) {
            return;
        }
        if (this.affectedIssues == null) {
            this.affectedIssues = otherAffectedIssues;
            return;
        }
        this.affectedIssues.addAll(otherAffectedIssues);
    }
}

