/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.access.rest;

import com.google.common.base.CaseFormat;
import com.google.common.collect.Sets;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Set;
import org.jfrog.common.JsonUtils;

public abstract class UpdateRequest<T>
implements InvocationHandler {
    private final T request;
    private final Set<String> populatedFields;

    protected UpdateRequest(T request) {
        this.request = request;
        this.populatedFields = Sets.newHashSet();
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        String name = method.getName();
        if ("toJsonMerge".equals(name)) {
            return JsonUtils.toJsonMerge(this.request, this.populatedFields);
        }
        if (name.startsWith("get") || "toString".equals(name)) {
            return method.invoke(this.request, args);
        }
        if ("addCustomData".equals(name)) {
            name = "customData";
        }
        this.populatedFields.add(CaseFormat.LOWER_CAMEL.to(CaseFormat.LOWER_UNDERSCORE, name));
        Object returnValue = method.invoke(this.request, args);
        if (this.request.getClass().isAssignableFrom(returnValue.getClass())) {
            return proxy;
        }
        return returnValue;
    }
}

