/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.access.rest.user;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonNaming;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nonnull;
import org.jfrog.access.model.Realm;
import org.jfrog.access.model.UserStatus;
import org.jfrog.access.rest.user.CustomDatumRequest;
import org.jfrog.access.rest.user.CustomDatumRequestImpl;
import org.jfrog.access.rest.user.UserRequest;

@JsonNaming(value=PropertyNamingStrategy.SnakeCaseStrategy.class)
public class UserRequestImpl
implements UserRequest {
    @JsonProperty
    private String username;
    @JsonProperty
    private String password;
    @JsonProperty
    private String email;
    @JsonProperty
    private String firstName;
    @JsonProperty
    private String lastName;
    @JsonProperty
    private Realm realm;
    @JsonProperty
    private Collection<String> allowedIps;
    @JsonProperty
    @JsonDeserialize(contentAs=CustomDatumRequestImpl.class)
    private Map<String, CustomDatumRequest> customData;
    @JsonProperty
    private Set<String> groups;
    @JsonProperty
    private UserStatus status = UserStatus.ENABLED;

    UserRequestImpl() {
    }

    public UserRequestImpl(String username, String password, String email, String firstName, String lastName, Realm realm, Collection<String> allowedIps, Map<String, CustomDatumRequest> customData, Set<String> groups, UserStatus status) {
        this.username = username;
        this.password = password;
        this.email = email;
        this.firstName = firstName;
        this.lastName = lastName;
        this.realm = realm;
        this.allowedIps = allowedIps;
        this.customData = customData;
        this.groups = groups;
        this.status = status;
    }

    @Override
    public String getUsername() {
        return this.username;
    }

    @Override
    public UserRequestImpl username(String username) {
        this.username = username;
        return this;
    }

    @Override
    public String getPassword() {
        return this.password;
    }

    @Override
    public UserRequestImpl password(String password) {
        this.password = password;
        return this;
    }

    @Override
    public String getEmail() {
        return this.email;
    }

    @Override
    public UserRequestImpl email(String email) {
        this.email = email;
        return this;
    }

    @Override
    public String getFirstName() {
        return this.firstName;
    }

    @Override
    public UserRequestImpl firstName(String firstName) {
        this.firstName = firstName;
        return this;
    }

    @Override
    public String getLastName() {
        return this.lastName;
    }

    @Override
    public UserRequestImpl lastName(String lastName) {
        this.lastName = lastName;
        return this;
    }

    @Override
    public Realm getRealm() {
        return this.realm;
    }

    @Override
    public UserRequestImpl realm(Realm realm) {
        this.realm = realm;
        return this;
    }

    @Override
    public Collection<String> getAllowedIps() {
        return this.allowedIps;
    }

    @Override
    public UserRequestImpl allowedIps(Collection<String> allowedIps) {
        this.allowedIps = allowedIps;
        return this;
    }

    @Override
    public Map<String, CustomDatumRequest> getCustomData() {
        return this.customData;
    }

    @Override
    public UserRequestImpl customData(Map<String, CustomDatumRequest> customData) {
        this.customData = customData;
        return this;
    }

    @Override
    public UserRequestImpl addCustomData(String key, String value) {
        return this.addCustomData(key, value, false);
    }

    @Override
    public UserRequestImpl addCustomData(String key, String value, boolean sensitive) {
        if (this.customData == null) {
            this.customData = Maps.newHashMap();
        }
        this.customData.put(key, new CustomDatumRequestImpl(value, sensitive));
        return this;
    }

    @Override
    @Nonnull
    public CustomDatumRequest getCustomData(String key) {
        return Optional.ofNullable(this.customData).map(customDataMap -> (CustomDatumRequest)customDataMap.get(key)).orElseGet(() -> new CustomDatumRequestImpl(null, false));
    }

    @Override
    public Set<String> getGroups() {
        return this.groups;
    }

    @Override
    public UserRequestImpl groups(Set<String> groups) {
        this.groups = groups;
        return this;
    }

    @Override
    public UserStatus getStatus() {
        return this.status;
    }

    @Override
    public UserRequestImpl status(UserStatus status) {
        this.status = status;
        return this;
    }
}

