/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.access.rest.permission;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import com.fasterxml.jackson.databind.annotation.JsonNaming;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import org.jfrog.access.common.Action;
import org.jfrog.access.rest.permission.PermissionActionsRequest;

@JsonNaming(value=PropertyNamingStrategy.SnakeCaseStrategy.class)
public class PermissionActionsRequestImpl
implements PermissionActionsRequest {
    @JsonProperty(value="users")
    private Map<String, List<Action>> userActions;
    @JsonProperty(value="groups")
    private Map<String, List<Action>> groupActions;

    @Override
    public Map<String, List<Action>> getUserActions() {
        return this.userActions;
    }

    PermissionActionsRequestImpl() {
    }

    @Override
    public PermissionActionsRequestImpl userActions(String user, List<Action> actions) {
        if (this.userActions == null) {
            this.userActions = Maps.newHashMap();
        }
        this.userActions.put(user, actions);
        return this;
    }

    @Override
    public PermissionActionsRequestImpl addUserAction(String user, Action action) {
        if (this.userActions == null) {
            this.userActions = Maps.newHashMap();
        }
        this.userActions.computeIfAbsent(user, a -> Lists.newArrayList()).add(action);
        return this;
    }

    @Override
    public PermissionActionsRequestImpl groupActions(String group, List<Action> actions) {
        if (this.groupActions == null) {
            this.groupActions = Maps.newHashMap();
        }
        this.groupActions.put(group, actions);
        return this;
    }

    @Override
    public PermissionActionsRequestImpl addGroupAction(String group, Action action) {
        if (this.groupActions == null) {
            this.groupActions = Maps.newHashMap();
        }
        this.groupActions.computeIfAbsent(group, a -> Lists.newArrayList()).add(action);
        return this;
    }

    @Override
    public Map<String, List<Action>> getGroupActions() {
        return this.groupActions;
    }
}

