/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.access.rest.imports;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import lombok.Generated;
import org.jfrog.access.model.Realm;
import org.jfrog.access.model.UserStatus;
import org.jfrog.access.rest.user.CustomDataBuilder;
import org.jfrog.access.rest.user.CustomDatumRequest;
import org.jfrog.access.rest.user.CustomDatumRequestImpl;
import org.jfrog.common.ArgUtils;

public class ImportUserRequest {
    @JsonProperty
    private final String username;
    @JsonProperty
    private final String password;
    @JsonProperty
    private final String email;
    @JsonProperty
    private final String firstName;
    @JsonProperty
    private final String lastName;
    @JsonProperty
    private final Realm realm;
    @JsonProperty
    private final Collection<String> allowedIps;
    @JsonProperty
    private final UserStatus status;
    @JsonProperty
    private final long failedLoginAttempts;
    @JsonProperty
    private final long created;
    @JsonProperty
    private final long modified;
    @JsonProperty
    private final long lastLoginTime;
    @JsonProperty
    private final String lastLoginIp;
    @JsonProperty
    private final long statusLastModified;
    @JsonProperty
    private final long passwordLastModified;
    @JsonProperty
    private final Map<String, CustomDatumRequest> customData;
    @JsonProperty
    private final Set<UserGroup> groups;

    public ImportUserRequest(String username, String password, String email, String firstName, String lastName, Realm realm, Collection<String> allowedIps, UserStatus status, long failedLoginAttempts, long created, long modified, long lastLoginTime, String lastLoginIp, long statusLastModified, long passwordLastModified, Map<String, CustomDatumRequest> customData, Set<UserGroup> groups) {
        this.username = ArgUtils.requireNonBlank((String)username, (String)"username is required");
        this.password = password;
        this.email = email;
        this.firstName = firstName;
        this.lastName = lastName;
        this.realm = realm;
        this.allowedIps = allowedIps;
        this.status = status != null ? status : UserStatus.ENABLED;
        this.failedLoginAttempts = failedLoginAttempts;
        this.created = created;
        this.modified = modified;
        this.lastLoginTime = lastLoginTime;
        this.lastLoginIp = lastLoginIp;
        this.statusLastModified = statusLastModified;
        this.passwordLastModified = passwordLastModified;
        this.customData = customData;
        this.groups = groups;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public String getEmail() {
        return this.email;
    }

    public String getFirstName() {
        return this.firstName;
    }

    public String getLastName() {
        return this.lastName;
    }

    public Realm getRealm() {
        return this.realm;
    }

    public Collection<String> getAllowedIps() {
        return this.allowedIps;
    }

    public UserStatus getStatus() {
        return this.status;
    }

    public long getFailedLoginAttempts() {
        return this.failedLoginAttempts;
    }

    public long getCreated() {
        return this.created;
    }

    public long getModified() {
        return this.modified;
    }

    public long getLastLoginTime() {
        return this.lastLoginTime;
    }

    public String getLastLoginIp() {
        return this.lastLoginIp;
    }

    public long getStatusLastModified() {
        return this.statusLastModified;
    }

    public long getPasswordLastModified() {
        return this.passwordLastModified;
    }

    public Map<String, CustomDatumRequest> getCustomData() {
        return this.customData;
    }

    public Set<UserGroup> getGroups() {
        return this.groups;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder
    implements CustomDataBuilder {
        private String username;
        private String password;
        private String email;
        private String firstName;
        private String lastName;
        private Realm realm;
        private Collection<String> allowedIps;
        private UserStatus status = UserStatus.ENABLED;
        private long failedLoginAttempts;
        private long created;
        private long modified;
        private long lastLoginTime;
        private String lastLoginIp;
        private long statusLastModified;
        private long passwordLastModified;
        private Map<String, CustomDatumRequest> customData;
        private Set<UserGroup> groups;

        public Builder username(String username) {
            this.username = username;
            return this;
        }

        public Builder password(String password) {
            this.password = password;
            return this;
        }

        public Builder email(String email) {
            this.email = email;
            return this;
        }

        public Builder firstName(String firstName) {
            this.firstName = firstName;
            return this;
        }

        public Builder lastName(String lastName) {
            this.lastName = lastName;
            return this;
        }

        public Builder realm(Realm realm) {
            this.realm = realm;
            return this;
        }

        public Builder allowedIps(Collection<String> allowedIps) {
            this.allowedIps = allowedIps;
            return this;
        }

        public Builder status(UserStatus status) {
            this.status = status;
            return this;
        }

        public Builder failedLoginAttempts(long failedLoginAttempts) {
            this.failedLoginAttempts = failedLoginAttempts;
            return this;
        }

        public Builder created(long created) {
            this.created = created;
            return this;
        }

        public Builder modified(long modified) {
            this.modified = modified;
            return this;
        }

        public Builder lastLoginTime(long lastLoginTime) {
            this.lastLoginTime = lastLoginTime;
            return this;
        }

        public Builder lastLoginIp(String lastLoginIp) {
            this.lastLoginIp = lastLoginIp;
            return this;
        }

        public Builder statusLastModified(long statusLastModified) {
            this.statusLastModified = statusLastModified;
            return this;
        }

        public Builder passwordLastModified(long passwordLastModified) {
            this.passwordLastModified = passwordLastModified;
            return this;
        }

        public Builder customData(Map<String, CustomDatumRequest> customData) {
            this.customData = customData;
            return this;
        }

        @Override
        public Builder addCustomData(String key, String value) {
            return this.addCustomData(key, value, false);
        }

        @Override
        public Builder addCustomData(String key, String value, boolean sensitive) {
            if (this.customData == null) {
                this.customData = Maps.newHashMap();
            }
            this.customData.put(key, new CustomDatumRequestImpl(value, sensitive));
            return this;
        }

        public Builder groups(Set<UserGroup> groups) {
            this.groups = groups;
            return this;
        }

        public Builder addGroup(String name, Realm realm) {
            if (this.groups == null) {
                this.groups = Sets.newHashSet();
            }
            this.groups.add(new UserGroup(name, realm));
            return this;
        }

        public ImportUserRequest build() {
            return new ImportUserRequest(ArgUtils.requireNonBlank((String)this.username, (String)"username is required"), this.password, this.email, this.firstName, this.lastName, this.realm, this.allowedIps, this.status, this.failedLoginAttempts, this.created, this.modified, this.lastLoginTime, this.lastLoginIp, this.statusLastModified, this.passwordLastModified, this.customData, this.groups);
        }
    }

    public static class UserGroup {
        private String name;
        private Realm realm;

        public UserGroup(String name, Realm realm) {
            this.name = ArgUtils.requireNonBlank((String)name, (String)"Group name cannot be empty");
            this.realm = realm;
        }

        @Generated
        public String getName() {
            return this.name;
        }

        @Generated
        public Realm getRealm() {
            return this.realm;
        }

        @Generated
        public void setName(String name) {
            this.name = name;
        }

        @Generated
        public void setRealm(Realm realm) {
            this.realm = realm;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof UserGroup)) {
                return false;
            }
            UserGroup other = (UserGroup)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            Realm this$realm = this.getRealm();
            Realm other$realm = other.getRealm();
            return !(this$realm == null ? other$realm != null : !this$realm.equals(other$realm));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof UserGroup;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            Realm $realm = this.getRealm();
            result = result * 59 + ($realm == null ? 43 : $realm.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "ImportUserRequest.UserGroup(name=" + this.getName() + ", realm=" + this.getRealm() + ")";
        }

        @Generated
        public UserGroup() {
        }
    }
}

