/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.access.rest.imports;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.jfrog.access.rest.imports.ImportGroupRequest;
import org.jfrog.access.rest.imports.ImportPermissionRequest;
import org.jfrog.access.rest.imports.ImportUserRequest;

public class ImportEntitiesRequest {
    private static final String ACCESS_CLIENT_VERSION = "4";
    @JsonProperty
    private final String version;
    @JsonProperty
    private final List<ImportGroupRequest> groups;
    @JsonProperty
    private final List<ImportUserRequest> users;
    @JsonProperty
    private final List<ImportPermissionRequest> permissions;

    public ImportEntitiesRequest(@Nullable List<ImportGroupRequest> groups, @Nullable List<ImportUserRequest> users, @Nullable List<ImportPermissionRequest> permissions) {
        this.version = ACCESS_CLIENT_VERSION;
        this.groups = groups;
        this.users = users;
        this.permissions = permissions;
    }

    public String getVersion() {
        return this.version;
    }

    public List<ImportGroupRequest> getGroups() {
        return this.groups == null ? null : Collections.unmodifiableList(this.groups);
    }

    public List<ImportUserRequest> getUsers() {
        return this.users == null ? null : Collections.unmodifiableList(this.users);
    }

    public List<ImportPermissionRequest> getPermissions() {
        return this.permissions == null ? null : Collections.unmodifiableList(this.permissions);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private final List<ImportGroupRequest> groups = Lists.newArrayList();
        private final List<ImportUserRequest> users = Lists.newArrayList();
        private final List<ImportPermissionRequest> permissions = Lists.newArrayList();

        private Builder() {
        }

        public Builder groups(@Nullable List<ImportGroupRequest> groups) {
            this.groups.clear();
            if (groups != null) {
                this.groups.addAll(groups);
            }
            return this;
        }

        public Builder addGroup(@Nonnull ImportGroupRequest group) {
            this.groups.add(group);
            return this;
        }

        public Builder users(@Nullable List<ImportUserRequest> users) {
            this.users.clear();
            if (users != null) {
                this.users.addAll(users);
            }
            return this;
        }

        public Builder addUser(@Nonnull ImportUserRequest user) {
            this.users.add(user);
            return this;
        }

        public Builder permissions(@Nullable List<ImportPermissionRequest> permissions) {
            this.permissions.clear();
            if (permissions != null) {
                this.permissions.addAll(permissions);
            }
            return this;
        }

        public Builder addPermission(@Nonnull ImportPermissionRequest permission) {
            this.permissions.add(permission);
            return this;
        }

        public ImportEntitiesRequest build() {
            return new ImportEntitiesRequest(this.groups, this.users, this.permissions);
        }
    }
}

