/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.access.rest.imports;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Sets;
import java.util.Set;
import lombok.Generated;
import org.jfrog.access.model.PermissionPrincipalType;
import org.jfrog.common.ArgUtils;

public class ImportPermissionRequest {
    @JsonProperty
    private final String name;
    @JsonProperty
    private final String displayName;
    @JsonProperty
    private final String resourceType;
    @JsonProperty
    private final String serviceId;
    @JsonProperty
    private final long created;
    @JsonProperty
    private final long modified;
    @JsonProperty
    private final String customData;
    @JsonProperty
    private final Set<PermissionAction> actions;

    public ImportPermissionRequest(String name, String displayName, String resourceType, String serviceId, long created, long modified, String customData, Set<PermissionAction> actions) {
        this.name = ArgUtils.requireNonBlank((String)name, (String)"name is required");
        this.displayName = displayName;
        this.resourceType = resourceType;
        this.serviceId = serviceId;
        this.created = created;
        this.modified = modified;
        this.customData = customData;
        this.actions = actions;
    }

    public String getName() {
        return this.name;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getResourceType() {
        return this.resourceType;
    }

    public String getServiceId() {
        return this.serviceId;
    }

    public long getCreated() {
        return this.created;
    }

    public long getModified() {
        return this.modified;
    }

    public String getCustomData() {
        return this.customData;
    }

    public Set<PermissionAction> getActions() {
        return this.actions;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private String name;
        private String displayName;
        private String resourceType;
        private String serviceId;
        private long created;
        private long modified;
        private String customData;
        private Set<PermissionAction> actions;

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        public Builder serviceId(String serviceId) {
            this.serviceId = serviceId;
            return this;
        }

        public Builder created(long created) {
            this.created = created;
            return this;
        }

        public Builder modified(long modified) {
            this.modified = modified;
            return this;
        }

        public Builder customData(String customData) {
            this.customData = customData;
            return this;
        }

        public Builder actions(Set<PermissionAction> actions) {
            this.actions = actions;
            return this;
        }

        public Builder addAction(String action, String principal, PermissionPrincipalType principalType) {
            if (this.actions == null) {
                this.actions = Sets.newHashSet();
            }
            this.actions.add(new PermissionAction(action, principal, principalType));
            return this;
        }

        public ImportPermissionRequest build() {
            return new ImportPermissionRequest(ArgUtils.requireNonBlank((String)this.name, (String)"name is required"), this.displayName, this.resourceType, this.serviceId, this.created, this.modified, this.customData, this.actions);
        }
    }

    public static class PermissionAction {
        private String action;
        private String principal;
        private PermissionPrincipalType principalType;

        public PermissionAction(String action, String principal, PermissionPrincipalType principalType) {
            this.action = ArgUtils.requireNonBlank((String)action, (String)"Action action cannot be empty");
            this.principal = ArgUtils.requireNonBlank((String)principal, (String)"Action principal cannot be empty");
            this.principalType = (PermissionPrincipalType)ArgUtils.requireNonNull((Object)principalType, (String)"Action principal type cannot be null");
        }

        @Generated
        public String getAction() {
            return this.action;
        }

        @Generated
        public String getPrincipal() {
            return this.principal;
        }

        @Generated
        public PermissionPrincipalType getPrincipalType() {
            return this.principalType;
        }

        @Generated
        public void setAction(String action) {
            this.action = action;
        }

        @Generated
        public void setPrincipal(String principal) {
            this.principal = principal;
        }

        @Generated
        public void setPrincipalType(PermissionPrincipalType principalType) {
            this.principalType = principalType;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof PermissionAction)) {
                return false;
            }
            PermissionAction other = (PermissionAction)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$action = this.getAction();
            String other$action = other.getAction();
            if (this$action == null ? other$action != null : !this$action.equals(other$action)) {
                return false;
            }
            String this$principal = this.getPrincipal();
            String other$principal = other.getPrincipal();
            if (this$principal == null ? other$principal != null : !this$principal.equals(other$principal)) {
                return false;
            }
            PermissionPrincipalType this$principalType = this.getPrincipalType();
            PermissionPrincipalType other$principalType = other.getPrincipalType();
            return !(this$principalType == null ? other$principalType != null : !this$principalType.equals(other$principalType));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof PermissionAction;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $action = this.getAction();
            result = result * 59 + ($action == null ? 43 : $action.hashCode());
            String $principal = this.getPrincipal();
            result = result * 59 + ($principal == null ? 43 : $principal.hashCode());
            PermissionPrincipalType $principalType = this.getPrincipalType();
            result = result * 59 + ($principalType == null ? 43 : $principalType.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "ImportPermissionRequest.PermissionAction(action=" + this.getAction() + ", principal=" + this.getPrincipal() + ", principalType=" + this.getPrincipalType() + ")";
        }

        @Generated
        public PermissionAction() {
        }
    }
}

