/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.access.client;

import java.util.Objects;
import javax.annotation.Nonnull;
import org.jfrog.access.client.AccessAuth;
import org.jfrog.access.client.AccessAuthSwitch;

public class AccessAuthCredentials
extends AccessAuth {
    private final String username;
    private final CharSequence password;

    public AccessAuthCredentials(@Nonnull String username, @Nonnull CharSequence password) {
        this.username = Objects.requireNonNull(username, "username is required");
        this.password = Objects.requireNonNull(password, "password is required");
    }

    public String getUsername() {
        return this.username;
    }

    public CharSequence getPassword() {
        return this.password;
    }

    @Override
    public <T> T accept(@Nonnull AccessAuthSwitch<T> authSwitch) {
        return authSwitch.caseOf(this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AccessAuthCredentials that = (AccessAuthCredentials)o;
        if (!this.username.equals(that.username)) {
            return false;
        }
        return this.password.equals(that.password);
    }

    public int hashCode() {
        int result = this.username.hashCode();
        result = 31 * result + this.password.hashCode();
        return result;
    }
}

