/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.qodana;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URL;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.file.Files;
import java.nio.file.attribute.PosixFilePermission;
import java.security.MessageDigest;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.qodana.ChecksumsKt;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\n\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\nH\u0002J\u0010\u0010\u000f\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0018\u0010\u0010\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\n2\b\b\u0002\u0010\u0012\u001a\u00020\bJ\u0018\u0010\u0013\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\bH\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/qodana/Installer;", "", "()V", "log", "Ljava/util/logging/Logger;", "getLog", "()Ljava/util/logging/Logger;", "calculateChecksum", "", "file", "Ljava/io/File;", "download", "", "url", "executablePath", "setFilePermissions", "setup", "path", "version", "verifyChecksum", "expectedChecksum", "Companion", "plugin"})
@SourceDebugExtension(value={"SMAP\nQodana.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Qodana.kt\norg/jetbrains/qodana/Installer\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,156:1\n1#2:157\n*E\n"})
public final class Installer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Logger log;
    @NotNull
    private static final String LATEST_VERSION = "v2025.2.2";
    @NotNull
    private static final String RELEASE_DOWNLOAD_URL = "https://github.com/JetBrains/qodana-cli/releases/download/%s/qodana_%s_%s";

    public Installer() {
        Logger logger = Logger.getLogger(Installer.class.getName());
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(Installer::class.java.name)");
        this.log = logger;
    }

    @NotNull
    public final Logger getLog() {
        return this.log;
    }

    @NotNull
    public final String setup(@NotNull File path, @NotNull String version) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)version, (String)"version");
        String downloadURL = org.jetbrains.qodana.Installer$Companion.getQodanaUrl$default(Companion, null, null, version, 3, null);
        boolean useNightly = Intrinsics.areEqual((Object)version, (Object)"nightly");
        if (path.exists()) {
            try {
                if (!useNightly) {
                    this.verifyChecksum(path, Companion.getChecksum(version));
                }
                String string = path.getAbsolutePath();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"path.absolutePath");
                return string;
            }
            catch (IOException e) {
                this.log.warning("Checksum verification failed. Redownloading the binary.");
                path.delete();
            }
        }
        try {
            this.download(downloadURL, path);
            if (!useNightly) {
                this.verifyChecksum(path, Companion.getChecksum(version));
            }
        }
        catch (IOException e) {
            throw new IOException("Unable to download latest qodana binary", e);
        }
        String string = path.getAbsolutePath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"path.absolutePath");
        return string;
    }

    public static /* synthetic */ String setup$default(Installer installer, File file, String string, int n, Object object) {
        if ((n & 2) != 0) {
            string = Companion.getLatestVersion();
        }
        return installer.setup(file, string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void download(String url, File executablePath) {
        executablePath.getParentFile().mkdirs();
        this.log.info("Downloading: " + url + " to " + executablePath);
        URL website = new URL(url);
        Closeable closeable = Channels.newChannel(website.openStream());
        Throwable throwable = null;
        try {
            ReadableByteChannel rbc = (ReadableByteChannel)closeable;
            boolean bl = false;
            Closeable closeable2 = new FileOutputStream(executablePath);
            Throwable throwable2 = null;
            try {
                FileOutputStream fos = (FileOutputStream)closeable2;
                boolean bl2 = false;
                fos.getChannel().transferFrom(rbc, 0L, Long.MAX_VALUE);
                this.setFilePermissions(executablePath);
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable3) {
                throwable2 = throwable3;
                throw throwable3;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable2);
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable4) {
            throwable = throwable4;
            throw throwable4;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    private final void setFilePermissions(File file) {
        if (Intrinsics.areEqual((Object)Companion.getPlatformName(), (Object)"windows")) {
            return;
        }
        Set perms = new HashSet();
        perms.add(PosixFilePermission.OWNER_READ);
        perms.add(PosixFilePermission.OWNER_WRITE);
        perms.add(PosixFilePermission.OWNER_EXECUTE);
        perms.add(PosixFilePermission.GROUP_EXECUTE);
        perms.add(PosixFilePermission.OTHERS_EXECUTE);
        Files.setPosixFilePermissions(file.toPath(), perms);
    }

    private final void verifyChecksum(File file, String expectedChecksum) {
        String checksum = this.calculateChecksum(file);
        if (!Intrinsics.areEqual((Object)checksum, (Object)expectedChecksum)) {
            throw new IOException("Checksum verification failed. Expected: " + expectedChecksum + ", but got: " + checksum);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final String calculateChecksum(File file) {
        MessageDigest digest = MessageDigest.getInstance("SHA-256");
        Closeable closeable = new FileInputStream(file);
        Throwable throwable = null;
        try {
            FileInputStream object = (FileInputStream)closeable;
            boolean bl = false;
            byte[] byteArray = new byte[1024];
            int bytesCount = 0;
            while (true) {
                int n;
                int it = n = object.read(byteArray);
                boolean bl2 = false;
                bytesCount = it;
                if (n == -1) break;
                digest.update(byteArray, 0, bytesCount);
            }
            Unit throwable2 = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        byte[] bytes = digest.digest();
        StringBuilder sb = new StringBuilder();
        Intrinsics.checkNotNullExpressionValue((Object)bytes, (String)"bytes");
        for (byte unit : bytes) {
            String string = "%02x";
            Object[] objectArray = new Object[]{unit};
            String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
            sb.append(string2);
        }
        String string = sb.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"sb.toString()");
        return string;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u000b\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0006\u001a\u00020\u0004J\u0010\u0010\u0007\u001a\u00020\u00042\b\b\u0002\u0010\b\u001a\u00020\u0004J\u0006\u0010\t\u001a\u00020\u0004J\u0006\u0010\n\u001a\u00020\u0004J\u0006\u0010\u000b\u001a\u00020\u0004J$\u0010\f\u001a\u00020\u00042\b\b\u0002\u0010\r\u001a\u00020\u00042\b\b\u0002\u0010\u000e\u001a\u00020\u00042\b\b\u0002\u0010\b\u001a\u00020\u0004R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/qodana/Installer$Companion;", "", "()V", "LATEST_VERSION", "", "RELEASE_DOWNLOAD_URL", "getArchName", "getChecksum", "version", "getExtension", "getLatestVersion", "getPlatformName", "getQodanaUrl", "platform", "arch", "plugin"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String getQodanaUrl(@NotNull String platform, @NotNull String arch, @NotNull String version) {
            Intrinsics.checkNotNullParameter((Object)platform, (String)"platform");
            Intrinsics.checkNotNullParameter((Object)arch, (String)"arch");
            Intrinsics.checkNotNullParameter((Object)version, (String)"version");
            StringBuilder stringBuilder = new StringBuilder();
            String string = Installer.RELEASE_DOWNLOAD_URL;
            Object[] objectArray = new Object[]{version, platform, arch};
            String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
            return stringBuilder.append(string2).append(this.getExtension()).toString();
        }

        public static /* synthetic */ String getQodanaUrl$default(Companion companion, String string, String string2, String string3, int n, Object object) {
            if ((n & 1) != 0) {
                string = companion.getPlatformName();
            }
            if ((n & 2) != 0) {
                string2 = companion.getArchName();
            }
            if ((n & 4) != 0) {
                string3 = Installer.LATEST_VERSION;
            }
            return companion.getQodanaUrl(string, string2, string3);
        }

        @NotNull
        public final String getExtension() {
            return Intrinsics.areEqual((Object)this.getPlatformName(), (Object)"windows") ? ".exe" : "";
        }

        @NotNull
        public final String getLatestVersion() {
            return Installer.LATEST_VERSION;
        }

        @NotNull
        public final String getArchName() {
            String string;
            String string2 = System.getProperty("os.arch");
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getProperty(\"os.arch\")");
            String string3 = string2.toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toLowerCase(...)");
            String arch = string3;
            if (StringsKt.contains$default((CharSequence)arch, (CharSequence)"x86_64", (boolean)false, (int)2, null) || StringsKt.contains$default((CharSequence)arch, (CharSequence)"amd64", (boolean)false, (int)2, null)) {
                string = "x86_64";
            } else if (StringsKt.contains$default((CharSequence)arch, (CharSequence)"arm64", (boolean)false, (int)2, null) || StringsKt.contains$default((CharSequence)arch, (CharSequence)"aarch64", (boolean)false, (int)2, null)) {
                string = "arm64";
            } else {
                throw new IllegalArgumentException("Unsupported architecture: " + arch);
            }
            return string;
        }

        @NotNull
        public final String getPlatformName() {
            String string;
            String string2 = System.getProperty("os.name");
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getProperty(\"os.name\")");
            String string3 = string2.toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toLowerCase(...)");
            String systemName = string3;
            if (StringsKt.contains$default((CharSequence)systemName, (CharSequence)"windows", (boolean)false, (int)2, null)) {
                string = "windows";
            } else if (StringsKt.contains$default((CharSequence)systemName, (CharSequence)"mac os x", (boolean)false, (int)2, null) || StringsKt.contains$default((CharSequence)systemName, (CharSequence)"darwin", (boolean)false, (int)2, null) || StringsKt.contains$default((CharSequence)systemName, (CharSequence)"osx", (boolean)false, (int)2, null)) {
                string = "darwin";
            } else if (StringsKt.contains$default((CharSequence)systemName, (CharSequence)"linux", (boolean)false, (int)2, null) || StringsKt.contains$default((CharSequence)systemName, (CharSequence)"freebsd", (boolean)false, (int)2, null)) {
                string = "linux";
            } else {
                throw new IllegalArgumentException("Unsupported OS: " + systemName);
            }
            return string;
        }

        @NotNull
        public final String getChecksum(@NotNull String version) {
            Intrinsics.checkNotNullParameter((Object)version, (String)"version");
            String platform = this.getPlatformName();
            String arch = this.getArchName();
            Map<String, String> map = ChecksumsKt.getCHECKSUMS().get(StringsKt.removePrefix((String)version, (CharSequence)"v"));
            if (map == null || (map = map.get(platform + '_' + arch)) == null) {
                throw new IllegalArgumentException("Unsupported combination of version, platform and architecture: " + version + ' ' + platform + '_' + arch);
            }
            return map;
        }

        public static /* synthetic */ String getChecksum$default(Companion companion, String string, int n, Object object) {
            if ((n & 1) != 0) {
                string = companion.getLatestVersion();
            }
            return companion.getChecksum(string);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

