/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.zip.signer.signer;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.nio.charset.Charset;
import java.security.PrivateKey;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle.openssl.PEMDecryptorProvider;
import org.bouncycastle.openssl.PEMEncryptedKeyPair;
import org.bouncycastle.openssl.PEMKeyPair;
import org.bouncycastle.openssl.PEMParser;
import org.bouncycastle.openssl.PasswordException;
import org.bouncycastle.openssl.jcajce.JcaPEMKeyConverter;
import org.bouncycastle.openssl.jcajce.JceOpenSSLPKCS8DecryptorProviderBuilder;
import org.bouncycastle.openssl.jcajce.JcePEMDecryptorProviderBuilder;
import org.bouncycastle.operator.InputDecryptorProvider;
import org.bouncycastle.pkcs.PKCS8EncryptedPrivateKeyInfo;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0019\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\tH\u0007J\u001a\u0010\u0004\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\b\u001a\u0004\u0018\u00010\tH\u0007J\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000b2\b\u0010\b\u001a\u0004\u0018\u00010\tJ\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\tJ\u001a\u0010\f\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u00102\b\u0010\b\u001a\u0004\u0018\u00010\tH\u0002J\u001a\u0010\u0011\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\u00012\b\u0010\b\u001a\u0004\u0018\u00010\tH\u0002\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/zip/signer/signer/PrivateKeyUtils;", "", "<init>", "()V", "loadPrivateKey", "Ljava/security/PrivateKey;", "file", "Ljava/io/File;", "password", "", "encodedPrivateKey", "", "loadKeyPair", "Lorg/bouncycastle/openssl/PEMKeyPair;", "key", "reader", "Ljava/io/Reader;", "extractKeyFromPemObject", "pemObject", "lib"})
public final class PrivateKeyUtils {
    @NotNull
    public static final PrivateKeyUtils INSTANCE = new PrivateKeyUtils();

    private PrivateKeyUtils() {
    }

    @JvmStatic
    @NotNull
    public static final PrivateKey loadPrivateKey(@NotNull File file, @Nullable char[] password) throws IOException {
        Intrinsics.checkNotNullParameter(file, "file");
        return PrivateKeyUtils.loadPrivateKey(FilesKt.readText$default(file, null, 1, null), password);
    }

    @JvmStatic
    @NotNull
    public static final PrivateKey loadPrivateKey(@NotNull String encodedPrivateKey, @Nullable char[] password) throws IOException {
        Intrinsics.checkNotNullParameter(encodedPrivateKey, "encodedPrivateKey");
        PEMKeyPair keyPair = INSTANCE.loadKeyPair(new StringReader(encodedPrivateKey), password);
        PrivateKey privateKey = new JcaPEMKeyConverter().getPrivateKey(keyPair.getPrivateKeyInfo());
        Intrinsics.checkNotNullExpressionValue(privateKey, "getPrivateKey(...)");
        return privateKey;
    }

    @NotNull
    public final PEMKeyPair loadKeyPair(@NotNull String key, @Nullable char[] password) {
        Intrinsics.checkNotNullParameter(key, "key");
        return this.loadKeyPair(new StringReader(key), password);
    }

    @NotNull
    public final PEMKeyPair loadKeyPair(@NotNull File file, @Nullable char[] password) {
        Intrinsics.checkNotNullParameter(file, "file");
        File file2 = file;
        Charset charset = Charsets.UTF_8;
        int n = 8192;
        Object object = file2;
        object = new InputStreamReader((InputStream)new FileInputStream((File)object), charset);
        return this.loadKeyPair(object instanceof BufferedReader ? (BufferedReader)object : new BufferedReader((Reader)object, n), password);
    }

    private final PEMKeyPair loadKeyPair(Reader reader, char[] password) {
        PEMParser parser = new PEMParser(reader);
        Object pemObject = parser.readObject();
        if (pemObject instanceof ASN1ObjectIdentifier) {
            pemObject = parser.readObject();
        }
        Object object = pemObject;
        Intrinsics.checkNotNull(object);
        return this.extractKeyFromPemObject(object, password);
    }

    private final PEMKeyPair extractKeyFromPemObject(Object pemObject, char[] password) {
        PEMKeyPair pEMKeyPair;
        Object object = pemObject;
        if (object instanceof PEMEncryptedKeyPair) {
            if (password == null) {
                throw new PasswordException("Can't read private key. Password is missing");
            }
            PEMDecryptorProvider decryptorProvider = new JcePEMDecryptorProviderBuilder().build(password);
            PEMKeyPair pEMKeyPair2 = ((PEMEncryptedKeyPair)pemObject).decryptKeyPair(decryptorProvider);
            Intrinsics.checkNotNull(pEMKeyPair2);
            pEMKeyPair = pEMKeyPair2;
        } else if (object instanceof PEMKeyPair) {
            pEMKeyPair = (PEMKeyPair)pemObject;
        } else if (object instanceof PKCS8EncryptedPrivateKeyInfo) {
            if (password == null) {
                throw new PasswordException("Can't read private key. Password is missing");
            }
            InputDecryptorProvider decryptorProvider = new JceOpenSSLPKCS8DecryptorProviderBuilder().build(password);
            PrivateKeyInfo privateKey = ((PKCS8EncryptedPrivateKeyInfo)pemObject).decryptPrivateKeyInfo(decryptorProvider);
            pEMKeyPair = new PEMKeyPair(null, privateKey);
        } else if (object instanceof PrivateKeyInfo) {
            pEMKeyPair = new PEMKeyPair(null, (PrivateKeyInfo)pemObject);
        } else {
            throw new IllegalArgumentException("Failed to parse private key");
        }
        return pEMKeyPair;
    }
}

