/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.zip.signer.datasource;

import java.nio.ByteBuffer;
import java.nio.channels.WritableByteChannel;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.zip.signer.datasource.DataSource;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0006\u001a\u00020\bH\u0016J\u0018\u0010\t\u001a\u00020\u00032\u0006\u0010\n\u001a\u00020\b2\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J \u0010\u000b\u001a\u00020\f2\u0006\u0010\n\u001a\u00020\b2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u0003H\u0016J \u0010\u000e\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\n\u001a\u00020\b2\u0006\u0010\u0006\u001a\u00020\bH\u0016J\u0018\u0010\u0011\u001a\u00020\u00002\u0006\u0010\n\u001a\u00020\b2\u0006\u0010\u0006\u001a\u00020\bH\u0016J\u0018\u0010\u0012\u001a\u00020\f2\u0006\u0010\n\u001a\u00020\b2\u0006\u0010\u0006\u001a\u00020\bH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/zip/signer/datasource/ByteBufferDataSource;", "Lorg/jetbrains/zip/signer/datasource/DataSource;", "buffer", "Ljava/nio/ByteBuffer;", "<init>", "(Ljava/nio/ByteBuffer;)V", "size", "", "", "getByteBuffer", "offset", "copyTo", "", "dest", "feed", "writableByteChannel", "Ljava/nio/channels/WritableByteChannel;", "slice", "checkChunkValid", "lib"})
public final class ByteBufferDataSource
implements DataSource {
    @NotNull
    private final ByteBuffer buffer;
    private final int size;

    public ByteBufferDataSource(@NotNull ByteBuffer buffer) {
        Intrinsics.checkNotNullParameter(buffer, "buffer");
        this.buffer = buffer;
        this.size = this.buffer.remaining();
    }

    @Override
    public long size() {
        return this.size;
    }

    @Override
    @NotNull
    public ByteBuffer getByteBuffer(long offset, int size) {
        this.checkChunkValid(offset, size);
        int chunkPosition = (int)offset;
        int chunkLimit = chunkPosition + size;
        this.buffer.position(0);
        this.buffer.limit(chunkLimit);
        this.buffer.position(chunkPosition);
        ByteBuffer byteBuffer = this.buffer.slice();
        Intrinsics.checkNotNullExpressionValue(byteBuffer, "slice(...)");
        return byteBuffer;
    }

    @Override
    public void copyTo(long offset, int size, @NotNull ByteBuffer dest) {
        Intrinsics.checkNotNullParameter(dest, "dest");
        dest.put(this.getByteBuffer(offset, size));
    }

    @Override
    public void feed(@NotNull WritableByteChannel writableByteChannel, long offset, long size) {
        Intrinsics.checkNotNullParameter(writableByteChannel, "writableByteChannel");
        if (size < 0L || size > (long)this.size) {
            throw new IndexOutOfBoundsException("size: " + size + ", source size: " + size);
        }
        writableByteChannel.write(this.getByteBuffer(offset, (int)size));
    }

    @Override
    @NotNull
    public ByteBufferDataSource slice(long offset, long size) {
        if (offset == 0L && (int)size == this.size) {
            return this;
        }
        if (size < 0L || size > (long)this.size) {
            throw new IndexOutOfBoundsException("size: " + size + ", source size: " + size);
        }
        return new ByteBufferDataSource(this.getByteBuffer(offset, (int)size));
    }

    private final void checkChunkValid(long offset, long size) {
        long endOffset = offset + size;
        if (offset < 0L) {
            throw new IndexOutOfBoundsException("offset: " + offset);
        }
        if (size < 0L) {
            throw new IndexOutOfBoundsException("size: " + size);
        }
        if (offset > (long)this.size) {
            throw new IndexOutOfBoundsException("offset (" + offset + ") > source size (" + size + ')');
        }
        if (endOffset < offset) {
            throw new IndexOutOfBoundsException("offset (" + offset + ") + size (" + size + ") overflow");
        }
        if (endOffset > (long)this.size) {
            throw new IndexOutOfBoundsException("offset (" + offset + ") + size (" + size + ") > source size (" + size + ')');
        }
    }
}

