/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.zip.signer;

import com.sampullara.cli.Args;
import java.io.File;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.util.List;
import kotlin.ExperimentalUnsignedTypes;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.zip.signer.SigningOptions;
import org.jetbrains.zip.signer.VerifyOptions;
import org.jetbrains.zip.signer.signer.CertificateUtils;
import org.jetbrains.zip.signer.signer.PublicKeyUtils;
import org.jetbrains.zip.signer.signer.SignerInfo;
import org.jetbrains.zip.signer.signer.SignerInfoLoader;
import org.jetbrains.zip.signer.signing.DefaultSignatureProvider;
import org.jetbrains.zip.signer.signing.ZipSigner;
import org.jetbrains.zip.signer.verifier.InvalidSignatureResult;
import org.jetbrains.zip.signer.verifier.MissingSignatureResult;
import org.jetbrains.zip.signer.verifier.SuccessfulVerificationResult;
import org.jetbrains.zip.signer.verifier.ZipVerificationResult;
import org.jetbrains.zip.signer.verifier.ZipVerifier;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0007\b\u00c7\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001b\u0010\u0004\u001a\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0007\u00a2\u0006\u0002\u0010\tJ\u001b\u0010\n\u001a\u00020\u00052\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0002\u00a2\u0006\u0002\u0010\tJ\u001b\u0010\f\u001a\u00020\u00052\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0002\u00a2\u0006\u0002\u0010\tJ\u0010\u0010\r\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\bH\u0002\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/zip/signer/ZipSigningTool;", "", "<init>", "()V", "main", "", "args", "", "", "([Ljava/lang/String;)V", "sign", "params", "verify", "exitWithError", "message", "cli"})
@ExperimentalUnsignedTypes
@SourceDebugExtension(value={"SMAP\nZipSigningTool.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ZipSigningTool.kt\norg/jetbrains/zip/signer/ZipSigningTool\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,150:1\n1#2:151\n*E\n"})
public final class ZipSigningTool {
    @NotNull
    public static final ZipSigningTool INSTANCE = new ZipSigningTool();

    private ZipSigningTool() {
    }

    @JvmStatic
    public static final void main(@NotNull String[] args) {
        Intrinsics.checkNotNullParameter(args, "args");
        if (args.length == 0) {
            System.err.println("Command is not specified: `sign` and `verify` commands are supported.");
            System.exit(1);
            throw new RuntimeException("System.exit returned normally, while it was supposed to halt JVM.");
        }
        String command = args[0];
        String[] restParameters = ArraysKt.copyOfRange(args, 1, args.length);
        String string = command;
        if (Intrinsics.areEqual(string, "sign")) {
            INSTANCE.sign(restParameters);
        } else if (Intrinsics.areEqual(string, "verify")) {
            INSTANCE.verify(restParameters);
        } else {
            System.err.println("Unknown command `" + command + "`: `sign` commands are supported.");
            System.exit(1);
            throw new RuntimeException("System.exit returned normally, while it was supposed to halt JVM.");
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void sign(String[] params) {
        char[] privateKeyPassword;
        SignerInfo signerInfo;
        SigningOptions options = new SigningOptions();
        Args.parseOrExit(options, params);
        if (options.getKeyStore() != null) {
            String string = options.getKeyStore();
            if (string == null) {
                throw new IllegalArgumentException("'ks' property not specified");
            }
            String keyStore = string;
            String string2 = options.getKeyStorePassword();
            if (string2 == null) {
                throw new IllegalArgumentException("'ks-pass' property not specified");
            }
            String password = string2;
            File file = new File(keyStore);
            char[] cArray = password.toCharArray();
            Intrinsics.checkNotNullExpressionValue(cArray, "toCharArray(...)");
            signerInfo = SignerInfoLoader.loadSignerInfoFromKeystore$default(SignerInfoLoader.INSTANCE, file, cArray, null, options.getKeyStoreAlias(), options.getKeyStoreType(), options.getKeyStoreProviderName(), 4, null);
        } else if (options.getPrivateKey() != null) {
            String string;
            char[] cArray;
            String string3 = options.getPrivateKey();
            if (string3 == null) {
                throw new IllegalArgumentException("'key' property not specified");
            }
            String privateKey = string3;
            String string4 = options.getPrivateKeyPassword();
            if (string4 != null) {
                char[] cArray2 = string4.toCharArray();
                cArray = cArray2;
                Intrinsics.checkNotNullExpressionValue(cArray2, "toCharArray(...)");
            } else {
                cArray = privateKeyPassword = null;
            }
            if ((string = options.getCertificate()) == null) {
                String string5 = options.getCertificateFile();
                if (string5 != null) {
                    String it = string5;
                    boolean bl = false;
                    string = FilesKt.readText$default(new File(it), null, 1, null);
                } else {
                    string = null;
                }
            }
            String certificate = string;
            signerInfo = SignerInfoLoader.INSTANCE.loadSignerInfoFromText(privateKey, certificate, privateKeyPassword);
        } else {
            File file;
            char[] cArray;
            String string = options.getPrivateKeyFile();
            if (string == null) {
                throw new IllegalArgumentException("'key-file' property not specified");
            }
            String privateKeyFile = string;
            String string6 = options.getPrivateKeyPassword();
            if (string6 != null) {
                char[] cArray3 = string6.toCharArray();
                cArray = cArray3;
                Intrinsics.checkNotNullExpressionValue(cArray3, "toCharArray(...)");
            } else {
                cArray = null;
            }
            privateKeyPassword = cArray;
            SignerInfoLoader signerInfoLoader = SignerInfoLoader.INSTANCE;
            File file2 = new File(privateKeyFile);
            String string7 = options.getCertificateFile();
            if (string7 != null) {
                void it;
                String string8 = string7;
                File file3 = file2;
                SignerInfoLoader signerInfoLoader2 = signerInfoLoader;
                boolean bl = false;
                File file4 = new File((String)it);
                signerInfoLoader = signerInfoLoader2;
                file2 = file3;
                file = file4;
            } else {
                file = null;
            }
            signerInfo = signerInfoLoader.loadSignerInfoFromFiles(file2, file, privateKeyPassword);
        }
        SignerInfo signerInfo2 = signerInfo;
        List<X509Certificate> certificates = signerInfo2.component1();
        PrivateKey privateKey = signerInfo2.component2();
        File file = new File(options.getInputFilePath());
        File file5 = new File(options.getOutputFilePath());
        PublicKey publicKey = certificates.get(0).getPublicKey();
        Intrinsics.checkNotNullExpressionValue(publicKey, "getPublicKey(...)");
        ZipSigner.sign(file, file5, certificates, new DefaultSignatureProvider(PublicKeyUtils.INSTANCE.getSuggestedSignatureAlgorithm(publicKey), privateKey));
    }

    private final void verify(String[] params) {
        VerifyOptions options = new VerifyOptions();
        Args.parseOrExit(options, params);
        X509Certificate certificateAuthority = CollectionsKt.first(CertificateUtils.loadCertificatesFromFile(new File(options.getCertificateFile())));
        ZipVerificationResult verificationResult = ZipVerifier.verify(new File(options.getInputFilePath()));
        if (verificationResult instanceof SuccessfulVerificationResult) {
            if (!((SuccessfulVerificationResult)verificationResult).isSignedBy(certificateAuthority)) {
                this.exitWithError("Zip archive is not signed by provided certificate authority");
            }
        } else if (verificationResult instanceof MissingSignatureResult) {
            this.exitWithError("Provided zip archive is not signed");
        } else if (verificationResult instanceof InvalidSignatureResult) {
            this.exitWithError("Signature of zip archive is invalid");
        } else {
            throw new NoWhenBranchMatchedException();
        }
    }

    private final void exitWithError(String message) {
        System.err.println(message);
        System.exit(-1);
        throw new RuntimeException("System.exit returned normally, while it was supposed to halt JVM.");
    }
}

