/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.datalore.plot.base.stat.regression;

import java.util.List;
import jetbrains.datalore.plot.base.stat.math3.ForsythePolynomialGenerator;
import jetbrains.datalore.plot.base.stat.math3.PolynomialFunction;
import jetbrains.datalore.plot.base.stat.math3.PolynomialFunctionKt;
import jetbrains.datalore.plot.base.stat.math3.TDistribution;
import jetbrains.datalore.plot.base.stat.regression.EvalResult;
import jetbrains.datalore.plot.base.stat.regression.RegressionEvaluator;
import jetbrains.datalore.plot.base.stat.regression.RegressionUtilKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0013\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u00192\u00020\u0001:\u0001\u0019B5\u0012\u000e\u0010\u0002\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00040\u0003\u0012\u000e\u0010\u0005\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00040\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0004\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ \u0010\u0011\u001a\u00020\r2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0013H\u0002J \u0010\u0015\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0013H\u0002J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0004H\u0016R\u000e\u0010\n\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Ljetbrains/datalore/plot/base/stat/regression/PolynomialRegression;", "Ljetbrains/datalore/plot/base/stat/regression/RegressionEvaluator;", "xs", "", "", "ys", "confidenceLevel", "deg", "", "(Ljava/util/List;Ljava/util/List;DI)V", "meanX", "n", "p", "Ljetbrains/datalore/plot/base/stat/math3/PolynomialFunction;", "sumXX", "sy", "tcritical", "calcPolynomial", "xVals", "", "yVals", "coefficient", "evalX", "Ljetbrains/datalore/plot/base/stat/regression/EvalResult;", "x", "Companion", "plot-base-portable"})
public final class PolynomialRegression
extends RegressionEvaluator {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final PolynomialFunction p;
    private final int n;
    private final double meanX;
    private final double sumXX;
    private final double sy;
    private final double tcritical;

    /*
     * WARNING - void declaration
     */
    public PolynomialRegression(@NotNull List<Double> xs, @NotNull List<Double> ys, double confidenceLevel, int deg) {
        PolynomialRegression $this$_init__u24lambda_u2d4;
        double d;
        double d2;
        Intrinsics.checkNotNullParameter(xs, (String)"xs");
        Intrinsics.checkNotNullParameter(ys, (String)"ys");
        super(xs, ys, confidenceLevel);
        boolean bl = deg >= 2;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean $i$a$-require-PolynomialRegression$32 = false;
            String string = "Degree of polynomial must be at least 2";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        Pair<double[], double[]> pair = RegressionUtilKt.averageByX(xs, ys);
        double[] xVals = (double[])pair.component1();
        double[] yVals = (double[])pair.component2();
        this.n = xVals.length;
        boolean $i$a$-require-PolynomialRegression$32 = this.n > deg;
        boolean bl4 = false;
        boolean bl5 = false;
        if (!$i$a$-require-PolynomialRegression$32) {
            boolean bl6 = false;
            String string = "The number of valid data points must be greater than deg";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        this.p = this.calcPolynomial(deg, xVals, yVals);
        this.meanX = ArraysKt.average((double[])xVals);
        double[] $i$a$-require-PolynomialRegression$32 = xVals;
        PolynomialRegression polynomialRegression = this;
        bl4 = false;
        double d3 = 0.0;
        double[] dArray = $i$a$-require-PolynomialRegression$32;
        int n = dArray.length;
        for (int i = 0; i < n; ++i) {
            void it;
            double d4;
            d2 = d4 = dArray[i];
            d = d3;
            boolean bl7 = false;
            void var21_37 = it - this.meanX;
            int n2 = 2;
            boolean bl8 = false;
            double d5 = Math.pow((double)var21_37, n2);
            d3 = d + d5;
        }
        polynomialRegression.sumXX = d = d3;
        double df = (double)(this.n - deg) - 1.0;
        PolynomialRegression polynomialRegression2 = this;
        boolean bl9 = false;
        boolean bl10 = false;
        PolynomialRegression polynomialRegression3 = polynomialRegression2;
        polynomialRegression = this;
        boolean bl11 = false;
        Iterable iterable = ArraysKt.zip((double[])xVals, (double[])yVals);
        boolean bl12 = false;
        d2 = 0.0;
        for (Object t : iterable) {
            void $dstr$x$y;
            Pair pair2 = (Pair)t;
            double d6 = d2;
            boolean bl13 = false;
            double x = ((Number)$dstr$x$y.component1()).doubleValue();
            double y = ((Number)$dstr$x$y.component2()).doubleValue();
            double d7 = y - $this$_init__u24lambda_u2d4.p.value(x);
            int n3 = 2;
            boolean bl14 = false;
            double d8 = Math.pow(d7, n3);
            d2 = d6 + d8;
        }
        double sse = d2;
        double d9 = sse / df;
        boolean bl15 = false;
        d = Math.sqrt(d9);
        polynomialRegression.sy = d;
        polynomialRegression2 = this;
        bl9 = false;
        bl10 = false;
        $this$_init__u24lambda_u2d4 = polynomialRegression2;
        polynomialRegression = this;
        boolean bl16 = false;
        double alpha = 1.0 - confidenceLevel;
        d = new TDistribution(df, 0.0, 2, null).inverseCumulativeProbability(1.0 - alpha / 2.0);
        polynomialRegression.tcritical = d;
    }

    private final PolynomialFunction calcPolynomial(int deg, double[] xVals, double[] yVals) {
        ForsythePolynomialGenerator fpg = new ForsythePolynomialGenerator(xVals);
        double[] dArray = new double[]{0.0};
        PolynomialFunction res = new PolynomialFunction(dArray);
        int n = 0;
        if (n <= deg) {
            int i;
            do {
                i = n++;
                PolynomialFunction p = fpg.getPolynomial(i);
                double s = this.coefficient(p, xVals, yVals);
                res = res.plus(PolynomialFunctionKt.times(s, p));
            } while (i != deg);
        }
        return res;
    }

    private final double coefficient(PolynomialFunction p, double[] xVals, double[] yVals) {
        double ww = 0.0;
        double w = 0.0;
        int n = 0;
        int n2 = xVals.length;
        if (n < n2) {
            do {
                int i = n++;
                double x = xVals[i];
                double y = yVals[i];
                double pval = p.value(x);
                ww += pval * pval;
                w += y * pval;
            } while (n < n2);
        }
        return w / ww;
    }

    @Override
    @NotNull
    public EvalResult evalX(double x) {
        PolynomialRegression polynomialRegression = this;
        boolean bl = false;
        boolean bl2 = false;
        PolynomialRegression $this$evalX_u24lambda_u2d6 = polynomialRegression;
        boolean bl3 = false;
        double d = x - $this$evalX_u24lambda_u2d6.meanX;
        int n = 2;
        boolean bl4 = false;
        double dxSquare = Math.pow(d, n);
        d = 1.0 / (double)$this$evalX_u24lambda_u2d6.n + dxSquare / $this$evalX_u24lambda_u2d6.sumXX;
        n = 0;
        double se = $this$evalX_u24lambda_u2d6.sy * Math.sqrt(d);
        double halfConfidenceInterval = this.tcritical * se;
        double yHat = this.p.value(x);
        return new EvalResult(yHat, yHat - halfConfidenceInterval, yHat + halfConfidenceInterval, se);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J.\u0010\u0003\u001a\u00020\u00042\u000e\u0010\u0005\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u00062\u000e\u0010\b\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u00062\u0006\u0010\t\u001a\u00020\n\u00a8\u0006\u000b"}, d2={"Ljetbrains/datalore/plot/base/stat/regression/PolynomialRegression$Companion;", "", "()V", "canBeComputed", "", "xs", "", "", "ys", "deg", "", "plot-base-portable"})
    public static final class Companion {
        private Companion() {
        }

        public final boolean canBeComputed(@NotNull List<Double> xs, @NotNull List<Double> ys, int deg) {
            Intrinsics.checkNotNullParameter(xs, (String)"xs");
            Intrinsics.checkNotNullParameter(ys, (String)"ys");
            Pair<double[], double[]> pair = RegressionUtilKt.averageByX(xs, ys);
            double[] xVals = (double[])pair.component1();
            return xVals.length > deg;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

