/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.datalore.plot.base.stat.math3;

import jetbrains.datalore.plot.base.stat.math3.AllowedSolution;
import jetbrains.datalore.plot.base.stat.math3.BracketedUnivariateSolver;
import jetbrains.datalore.plot.base.stat.math3.BrentSolver;
import jetbrains.datalore.plot.base.stat.math3.UnivariateFunction;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0013\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u000e\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J2\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\b2\b\b\u0002\u0010\u000b\u001a\u00020\fH\u0007JD\u0010\r\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u00062\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00060\u00112\u0006\u0010\u0012\u001a\u00020\b2\u0006\u0010\u0013\u001a\u00020\b2\u0006\u0010\u0014\u001a\u00020\b2\u0006\u0010\u0015\u001a\u00020\u0016J\u001e\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0019\u001a\u00020\b2\u0006\u0010\u001a\u001a\u00020\bJ\u001e\u0010\u001b\u001a\u00020\u00182\u0006\u0010\u001c\u001a\u00020\b2\u0006\u0010\u001d\u001a\u00020\b2\u0006\u0010\u001e\u001a\u00020\bJ\u0016\u0010\u001f\u001a\u00020\b2\u0006\u0010 \u001a\u00020\b2\u0006\u0010!\u001a\u00020\bJ\u001e\u0010\"\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010#\u001a\u00020\b2\u0006\u0010$\u001a\u00020\bJ&\u0010\"\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010#\u001a\u00020\b2\u0006\u0010$\u001a\u00020\b2\u0006\u0010%\u001a\u00020\bJ\u001e\u0010&\u001a\u00020'2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0019\u001a\u00020\b2\u0006\u0010\u001a\u001a\u00020\bJ\u0016\u0010(\u001a\u00020'2\u0006\u0010\u0019\u001a\u00020\b2\u0006\u0010\u001a\u001a\u00020\bJ\u001e\u0010)\u001a\u00020'2\u0006\u0010\u0019\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u001a\u001a\u00020\b\u00a8\u0006*"}, d2={"Ljetbrains/datalore/plot/base/stat/math3/UnivariateSolverUtils;", "", "()V", "bracket", "", "function", "Ljetbrains/datalore/plot/base/stat/math3/UnivariateFunction;", "initial", "", "lowerBound", "upperBound", "maximumIterations", "", "forceSide", "maxEval", "f", "bracketing", "Ljetbrains/datalore/plot/base/stat/math3/BracketedUnivariateSolver;", "baseRoot", "min", "max", "allowedSolution", "Ljetbrains/datalore/plot/base/stat/math3/AllowedSolution;", "isBracketing", "", "lower", "upper", "isSequence", "start", "mid", "end", "midpoint", "a", "b", "solve", "x0", "x1", "absoluteAccuracy", "verifyBracketing", "", "verifyInterval", "verifySequence", "plot-base-portable"})
public final class UnivariateSolverUtils {
    @NotNull
    public static final UnivariateSolverUtils INSTANCE = new UnivariateSolverUtils();

    private UnivariateSolverUtils() {
    }

    public final double solve(@NotNull UnivariateFunction function, double x0, double x1) {
        Intrinsics.checkNotNullParameter((Object)function, (String)"function");
        BrentSolver solver = new BrentSolver(0.0, 1, null);
        return solver.solve(Integer.MAX_VALUE, function, x0, x1);
    }

    public final double solve(@NotNull UnivariateFunction function, double x0, double x1, double absoluteAccuracy) {
        Intrinsics.checkNotNullParameter((Object)function, (String)"function");
        BrentSolver solver = new BrentSolver(absoluteAccuracy);
        return solver.solve(Integer.MAX_VALUE, function, x0, x1);
    }

    public final double forceSide(int maxEval, @NotNull UnivariateFunction f, @NotNull BracketedUnivariateSolver<UnivariateFunction> bracketing, double baseRoot, double min, double max, @NotNull AllowedSolution allowedSolution) {
        Intrinsics.checkNotNullParameter((Object)f, (String)"f");
        Intrinsics.checkNotNullParameter(bracketing, (String)"bracketing");
        Intrinsics.checkNotNullParameter((Object)((Object)allowedSolution), (String)"allowedSolution");
        if (allowedSolution == AllowedSolution.ANY_SIDE) {
            return baseRoot;
        }
        double d = bracketing.getAbsoluteAccuracy();
        double d2 = baseRoot * bracketing.getRelativeAccuracy();
        boolean bl = false;
        d2 = Math.abs(d2);
        bl = false;
        double step = Math.max(d, d2);
        d2 = baseRoot - step;
        bl = false;
        double xLo = Math.max(min, d2);
        double fLo = f.value(xLo);
        double d3 = baseRoot + step;
        boolean bl2 = false;
        double xHi = Math.min(max, d3);
        double fHi = f.value(xHi);
        int remainingEval = maxEval - 2;
        while (remainingEval > 0) {
            int n;
            boolean bl3;
            if (fLo >= 0.0 && fHi <= 0.0 || fLo <= 0.0 && fHi >= 0.0) {
                return bracketing.solve(remainingEval, f, xLo, xHi, baseRoot, allowedSolution);
            }
            boolean changeLo = false;
            boolean changeHi = false;
            if (fLo < fHi) {
                if (fLo >= 0.0) {
                    changeLo = true;
                } else {
                    changeHi = true;
                }
            } else if (fLo > fHi) {
                if (fLo <= 0.0) {
                    changeLo = true;
                } else {
                    changeHi = true;
                }
            } else {
                changeLo = true;
                changeHi = true;
            }
            if (changeLo) {
                double d4 = xLo - step;
                bl3 = false;
                xLo = Math.max(min, d4);
                fLo = f.value(xLo);
                n = remainingEval;
                remainingEval = n + -1;
            }
            if (!changeHi) continue;
            double d5 = xHi + step;
            bl3 = false;
            xHi = Math.min(max, d5);
            fHi = f.value(xHi);
            n = remainingEval;
            remainingEval = n + -1;
        }
        String string = "NoBracketing";
        boolean bl4 = false;
        throw (Throwable)new IllegalStateException(string.toString());
    }

    @JvmOverloads
    @NotNull
    public final double[] bracket(@NotNull UnivariateFunction function, double initial, double lowerBound, double upperBound, int maximumIterations) {
        Intrinsics.checkNotNullParameter((Object)function, (String)"function");
        if (maximumIterations <= 0) {
            String string = "NotStrictlyPositive";
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string.toString());
        }
        this.verifySequence(lowerBound, initial, upperBound);
        double a = initial;
        double b = initial;
        double fa = 0.0;
        double fb = 0.0;
        int numIterations = 0;
        do {
            double d = a - 1.0;
            boolean bl = false;
            a = Math.max(d, lowerBound);
            d = b + 1.0;
            bl = false;
            b = Math.min(d, upperBound);
        } while ((fa = function.value(a)) * (fb = function.value(b)) > 0.0 && ++numIterations < maximumIterations && (a > lowerBound || b < upperBound));
        if (fa * fb > 0.0) {
            String string = "NoBracketing";
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string.toString());
        }
        double[] dArray = new double[]{a, b};
        return dArray;
    }

    public static /* synthetic */ double[] bracket$default(UnivariateSolverUtils univariateSolverUtils, UnivariateFunction univariateFunction, double d, double d2, double d3, int n, int n2, Object object) {
        if ((n2 & 0x10) != 0) {
            n = Integer.MAX_VALUE;
        }
        return univariateSolverUtils.bracket(univariateFunction, d, d2, d3, n);
    }

    public final double midpoint(double a, double b) {
        return (a + b) * 0.5;
    }

    public final boolean isBracketing(@NotNull UnivariateFunction function, double lower, double upper) {
        Intrinsics.checkNotNullParameter((Object)function, (String)"function");
        double fLo = function.value(lower);
        double fHi = function.value(upper);
        return fLo >= 0.0 && fHi <= 0.0 || fLo <= 0.0 && fHi >= 0.0;
    }

    public final boolean isSequence(double start, double mid, double end) {
        return start < mid && mid < end;
    }

    public final void verifyInterval(double lower, double upper) {
        if (lower >= upper) {
            String string = "NumberIsTooLarge";
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string.toString());
        }
    }

    public final void verifySequence(double lower, double initial, double upper) {
        this.verifyInterval(lower, initial);
        this.verifyInterval(initial, upper);
    }

    public final void verifyBracketing(@NotNull UnivariateFunction function, double lower, double upper) {
        Intrinsics.checkNotNullParameter((Object)function, (String)"function");
        this.verifyInterval(lower, upper);
        if (!this.isBracketing(function, lower, upper)) {
            String string = "NoBracketing";
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string.toString());
        }
    }

    @JvmOverloads
    @NotNull
    public final double[] bracket(@NotNull UnivariateFunction function, double initial, double lowerBound, double upperBound) {
        Intrinsics.checkNotNullParameter((Object)function, (String)"function");
        return UnivariateSolverUtils.bracket$default(this, function, initial, lowerBound, upperBound, 0, 16, null);
    }
}

