/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.datalore.vis.svgMapper;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import jetbrains.datalore.base.registration.Registration;
import jetbrains.datalore.mapper.core.Synchronizer;
import jetbrains.datalore.mapper.core.SynchronizerContext;
import jetbrains.datalore.vis.svg.SvgAttributeSpec;
import jetbrains.datalore.vis.svg.SvgElement;
import jetbrains.datalore.vis.svg.SvgNode;
import jetbrains.datalore.vis.svg.SvgTextNode;
import jetbrains.datalore.vis.svg.slim.SvgSlimElements;
import jetbrains.datalore.vis.svg.slim.SvgSlimNode;
import jetbrains.datalore.vis.svgMapper.TargetPeer;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002B#\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00028\u0000\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00000\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\b\u0010\u0011\u001a\u00020\u000eH\u0016J\u0015\u0010\u0012\u001a\u00028\u00002\u0006\u0010\u0003\u001a\u00020\u0013H\u0002\u00a2\u0006\u0002\u0010\u0014J\u0015\u0010\u0015\u001a\u00028\u00002\u0006\u0010\u0003\u001a\u00020\u0004H\u0002\u00a2\u0006\u0002\u0010\u0016J\u0015\u0010\u0017\u001a\u00028\u00002\u0006\u0010\u0003\u001a\u00020\u0018H\u0002\u00a2\u0006\u0002\u0010\u0019J\u0015\u0010\u001a\u001a\u00028\u00002\u0006\u0010\u0003\u001a\u00020\u001bH\u0002\u00a2\u0006\u0002\u0010\u001cR\u0016\u0010\t\u001a\n\u0012\u0004\u0012\u00020\u000b\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u00028\u0000X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\fR\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00000\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Ljetbrains/datalore/vis/svgMapper/SvgNodeSubtreeGeneratingSynchronizer;", "T", "Ljetbrains/datalore/mapper/core/Synchronizer;", "source", "Ljetbrains/datalore/vis/svg/SvgNode;", "target", "targetPeer", "Ljetbrains/datalore/vis/svgMapper/TargetPeer;", "(Ljetbrains/datalore/vis/svg/SvgNode;Ljava/lang/Object;Ljetbrains/datalore/vis/svgMapper/TargetPeer;)V", "myHandlersRegs", "", "Ljetbrains/datalore/base/registration/Registration;", "Ljava/lang/Object;", "attach", "", "ctx", "Ljetbrains/datalore/mapper/core/SynchronizerContext;", "detach", "generateElement", "Ljetbrains/datalore/vis/svg/SvgElement;", "(Ljetbrains/datalore/vis/svg/SvgElement;)Ljava/lang/Object;", "generateNode", "(Ljetbrains/datalore/vis/svg/SvgNode;)Ljava/lang/Object;", "generateSlimNode", "Ljetbrains/datalore/vis/svg/slim/SvgSlimNode;", "(Ljetbrains/datalore/vis/svg/slim/SvgSlimNode;)Ljava/lang/Object;", "generateTextNode", "Ljetbrains/datalore/vis/svg/SvgTextNode;", "(Ljetbrains/datalore/vis/svg/SvgTextNode;)Ljava/lang/Object;", "vis-svg-mapper"})
public final class SvgNodeSubtreeGeneratingSynchronizer<T>
implements Synchronizer {
    @NotNull
    private final SvgNode source;
    private final T target;
    @NotNull
    private final TargetPeer<T> targetPeer;
    @Nullable
    private List<Registration> myHandlersRegs;

    public SvgNodeSubtreeGeneratingSynchronizer(@NotNull SvgNode source, T target, @NotNull TargetPeer<T> targetPeer) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter(targetPeer, (String)"targetPeer");
        this.source = source;
        this.target = target;
        this.targetPeer = targetPeer;
    }

    @Override
    public void attach(@NotNull SynchronizerContext ctx2) {
        Intrinsics.checkNotNullParameter((Object)ctx2, (String)"ctx");
        this.myHandlersRegs = new ArrayList();
        boolean bl = !(this.source instanceof SvgSlimNode);
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = Intrinsics.stringPlus((String)"Slim SVG node is not expected: ", (Object)Reflection.getOrCreateKotlinClass(this.source.getClass()).getSimpleName());
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        this.targetPeer.appendChild(this.target, this.generateNode(this.source));
    }

    @Override
    public void detach() {
        List<Registration> list2 = this.myHandlersRegs;
        Intrinsics.checkNotNull(list2);
        for (Registration handlerReg : list2) {
            handlerReg.remove();
        }
        this.myHandlersRegs = null;
        this.targetPeer.removeAllChildren(this.target);
    }

    private final T generateNode(SvgNode source) {
        T t;
        SvgNode svgNode = source;
        if (svgNode instanceof SvgSlimNode) {
            t = this.generateSlimNode((SvgSlimNode)((Object)source));
        } else if (svgNode instanceof SvgElement) {
            t = this.generateElement((SvgElement)source);
        } else if (svgNode instanceof SvgTextNode) {
            t = this.generateTextNode((SvgTextNode)source);
        } else {
            throw new IllegalStateException(Intrinsics.stringPlus((String)"Can't generate dom for svg node ", (Object)Reflection.getOrCreateKotlinClass(source.getClass()).getSimpleName()));
        }
        return t;
    }

    private final T generateElement(SvgElement source) {
        T target = this.targetPeer.newSvgElement(source);
        for (SvgAttributeSpec<?> key : source.getAttributeKeys()) {
            this.targetPeer.setAttribute(target, key.getName(), String.valueOf(source.getAttribute(key.getName()).get()));
        }
        Set eventSpecs = (Set)source.handlersSet().get();
        Collection collection = eventSpecs;
        boolean bl = false;
        if (!collection.isEmpty()) {
            this.targetPeer.hookEventHandlers(source, target, eventSpecs);
        }
        for (SvgNode child : source.children()) {
            this.targetPeer.appendChild(target, this.generateNode(child));
        }
        return target;
    }

    private final T generateTextNode(SvgTextNode source) {
        return this.targetPeer.newSvgTextNode(source);
    }

    private final T generateSlimNode(SvgSlimNode source) {
        T target = this.targetPeer.newSvgSlimNode(source);
        if (Intrinsics.areEqual((Object)source.getElementName(), (Object)SvgSlimElements.INSTANCE.getGROUP())) {
            for (SvgSlimNode child : source.getSlimChildren()) {
                this.targetPeer.appendChild(target, this.generateSlimNode(child));
            }
        }
        for (SvgSlimNode.Attr attr : source.getAttributes()) {
            this.targetPeer.setAttribute(target, attr.getKey(), attr.getValue());
        }
        return target;
    }
}

