/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.datalore.plot.server.config.transform.bistro.corr;

import jetbrains.datalore.plot.server.config.transform.bistro.corr.CorrPlotOptionsBuilder;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\b\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u0006H\u0002J \u0010\t\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u0006H\u0002J&\u0010\u000b\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\u0004J\u0014\u0010\r\u001a\u0004\u0018\u00010\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u000eH\u0002J(\u0010\u0010\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u0004H\u0002J\u001e\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u0006J\u001e\u0010\u0012\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u0006J\u001c\u0010\u0013\u001a\u00020\u00042\b\u0010\u0014\u001a\u0004\u0018\u00010\u000e2\b\u0010\u0015\u001a\u0004\u0018\u00010\u000eH\u0002\u00a8\u0006\u0016"}, d2={"Ljetbrains/datalore/plot/server/config/transform/bistro/corr/OptionsConfigurator;", "", "()V", "adjustDiag", "", "tiles", "Ljetbrains/datalore/plot/server/config/transform/bistro/corr/CorrPlotOptionsBuilder$LayerParams;", "points", "labels", "adjustTypeColorSize", "", "configure", "flipY", "flip", "", "type", "flipType", "getCombinedMatrixType", "getKeepMatrixDiag", "overlap", "type0", "type1", "plot-config-portable"})
public final class OptionsConfigurator {
    @NotNull
    public static final OptionsConfigurator INSTANCE = new OptionsConfigurator();

    private OptionsConfigurator() {
    }

    public final void configure(@NotNull CorrPlotOptionsBuilder.LayerParams tiles, @NotNull CorrPlotOptionsBuilder.LayerParams points2, @NotNull CorrPlotOptionsBuilder.LayerParams labels, boolean flipY) {
        Intrinsics.checkNotNullParameter((Object)tiles, (String)"tiles");
        Intrinsics.checkNotNullParameter((Object)points2, (String)"points");
        Intrinsics.checkNotNullParameter((Object)labels, (String)"labels");
        this.adjustTypeColorSize(tiles, points2, labels);
        this.flipType(tiles, points2, labels, flipY);
        this.adjustDiag(tiles, points2, labels);
    }

    private final void adjustTypeColorSize(CorrPlotOptionsBuilder.LayerParams tiles, CorrPlotOptionsBuilder.LayerParams points2, CorrPlotOptionsBuilder.LayerParams labels) {
        Object object;
        boolean hasTiles = tiles.getAdded();
        boolean hasPoints = points2.getAdded();
        boolean hasLabels = labels.getAdded();
        Object tilesType = tiles.getType();
        String pointsType = points2.getType();
        String labelsType = labels.getType();
        if (hasTiles && hasPoints) {
            if (tilesType == null && pointsType == null) {
                tilesType = "lower";
                pointsType = "upper";
            } else if (tilesType == null) {
                if (Intrinsics.areEqual((Object)pointsType, (Object)"lower")) {
                    tilesType = "upper";
                } else {
                    object = new String[]{"upper", "full"};
                    if (CollectionsKt.contains((Iterable)CollectionsKt.listOf((Object[])object), (Object)pointsType)) {
                        tilesType = "lower";
                    }
                }
            } else if (pointsType == null) {
                pointsType = this.flip((String)tilesType);
            }
        }
        if (hasLabels && labelsType == null && labels.getColor() == null) {
            if (hasPoints) {
                if (pointsType == null) {
                    labelsType = "lower";
                    pointsType = "upper";
                } else {
                    labelsType = this.flip(pointsType);
                }
            }
            if (hasTiles) {
                if (tilesType == null && labelsType == null) {
                    tilesType = "lower";
                    labelsType = "upper";
                } else if (tilesType == null) {
                    tilesType = this.flip(labelsType);
                } else {
                    labelsType = this.flip((String)tilesType);
                }
            }
        }
        if (hasLabels && labels.getColor() == null) {
            if (hasTiles) {
                object = labelsType;
                Object object2 = object == null ? "full" : object;
                object = tilesType;
                if (this.overlap((String)object2, (String)(object == null ? "full" : object))) {
                    labels.setColor("white");
                }
            }
            if (hasPoints) {
                object = labelsType;
                Object object3 = object == null ? "full" : object;
                object = pointsType;
                if (this.overlap((String)object3, (String)(object == null ? "full" : object))) {
                    labels.setColor("white");
                }
            }
        }
        if (hasPoints && hasLabels && labels.getMapSize() == null) {
            object = labelsType;
            Object object4 = object == null ? "full" : object;
            object = pointsType;
            if (this.overlap((String)object4, (String)(object == null ? "full" : object))) {
                labels.setMapSize(true);
            }
        }
        if (hasTiles) {
            object = tilesType;
            tiles.setType((String)(object == null ? "full" : object));
        }
        if (hasPoints) {
            object = pointsType;
            points2.setType((String)(object == null ? "full" : object));
        }
        if (hasLabels) {
            object = labelsType;
            labels.setType((String)(object == null ? "full" : object));
        }
    }

    private final boolean adjustDiag(CorrPlotOptionsBuilder.LayerParams tiles, CorrPlotOptionsBuilder.LayerParams points2, CorrPlotOptionsBuilder.LayerParams labels) {
        boolean tilesDiag = OptionsConfigurator.adjustDiag$adjust(tiles);
        boolean pointsDiag = OptionsConfigurator.adjustDiag$adjust(points2);
        boolean labelsDiag = OptionsConfigurator.adjustDiag$adjust(labels);
        return tilesDiag || pointsDiag || labelsDiag;
    }

    private final void flipType(CorrPlotOptionsBuilder.LayerParams tiles, CorrPlotOptionsBuilder.LayerParams points2, CorrPlotOptionsBuilder.LayerParams labels, boolean flip) {
        if (flip) {
            if (tiles.getAdded()) {
                tiles.setType(this.flip(tiles.getType()));
            }
            if (points2.getAdded()) {
                points2.setType(this.flip(points2.getType()));
            }
            if (labels.getAdded()) {
                labels.setType(this.flip(labels.getType()));
            }
        }
    }

    private final String flip(String type) {
        if (Intrinsics.areEqual((Object)type, (Object)"upper")) {
            return "lower";
        }
        if (Intrinsics.areEqual((Object)type, (Object)"lower")) {
            return "upper";
        }
        return type;
    }

    private final boolean overlap(String type0, String type1) {
        if (type0 == null || type1 == null) {
            return false;
        }
        if (Intrinsics.areEqual((Object)type0, (Object)"full") || Intrinsics.areEqual((Object)type1, (Object)"full")) {
            return true;
        }
        return Intrinsics.areEqual((Object)type0, (Object)type1);
    }

    @NotNull
    public final String getCombinedMatrixType(@NotNull CorrPlotOptionsBuilder.LayerParams tiles, @NotNull CorrPlotOptionsBuilder.LayerParams points2, @NotNull CorrPlotOptionsBuilder.LayerParams labels) {
        String type;
        String string;
        Intrinsics.checkNotNullParameter((Object)tiles, (String)"tiles");
        Intrinsics.checkNotNullParameter((Object)points2, (String)"points");
        Intrinsics.checkNotNullParameter((Object)labels, (String)"labels");
        if (tiles.getAdded()) {
            String string2 = tiles.getType();
            string = string2;
            Intrinsics.checkNotNull((Object)string2);
        } else {
            string = type = null;
        }
        if (points2.getAdded()) {
            String string3 = points2.getType();
            Intrinsics.checkNotNull((Object)string3);
            type = OptionsConfigurator.getCombinedMatrixType$combined(type, string3);
        }
        if (labels.getAdded()) {
            String string4 = labels.getType();
            Intrinsics.checkNotNull((Object)string4);
            type = OptionsConfigurator.getCombinedMatrixType$combined(type, string4);
        }
        String string5 = type;
        Intrinsics.checkNotNull((Object)string5);
        return string5;
    }

    public final boolean getKeepMatrixDiag(@NotNull CorrPlotOptionsBuilder.LayerParams tiles, @NotNull CorrPlotOptionsBuilder.LayerParams points2, @NotNull CorrPlotOptionsBuilder.LayerParams labels) {
        boolean bl;
        boolean pointsDiag;
        boolean bl2;
        boolean tilesDiag;
        boolean bl3;
        Intrinsics.checkNotNullParameter((Object)tiles, (String)"tiles");
        Intrinsics.checkNotNullParameter((Object)points2, (String)"points");
        Intrinsics.checkNotNullParameter((Object)labels, (String)"labels");
        if (tiles.getAdded()) {
            Boolean bl4 = tiles.getDiag();
            Intrinsics.checkNotNull((Object)bl4);
            bl3 = bl4;
        } else {
            bl3 = tilesDiag = false;
        }
        if (points2.getAdded()) {
            Boolean bl5 = points2.getDiag();
            Intrinsics.checkNotNull((Object)bl5);
            bl2 = bl5;
        } else {
            bl2 = pointsDiag = false;
        }
        if (labels.getAdded()) {
            Boolean bl6 = labels.getDiag();
            Intrinsics.checkNotNull((Object)bl6);
            bl = bl6;
        } else {
            bl = false;
        }
        boolean labelsDiag = bl;
        return tilesDiag || pointsDiag || labelsDiag;
    }

    private static final boolean adjustDiag$adjust(CorrPlotOptionsBuilder.LayerParams params) {
        boolean bl;
        if (params.getAdded()) {
            Boolean bl2 = params.getDiag();
            params.setDiag(bl2 == null ? Boolean.valueOf(Intrinsics.areEqual((Object)params.getType(), (Object)"full")) : bl2);
            bl2 = params.getDiag();
            if (bl2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.Boolean");
            }
            bl = bl2;
        } else {
            bl = false;
        }
        return bl;
    }

    private static final String getCombinedMatrixType$combined(String type, String otherType) {
        return type == null || Intrinsics.areEqual((Object)otherType, (Object)"full") ? otherType : (Intrinsics.areEqual((Object)type, (Object)"full") ? type : (INSTANCE.overlap(type, otherType) ? type : "full"));
    }
}

