/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.datalore.plot.server.config.transform.bistro.corr;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import jetbrains.datalore.plot.base.DataFrame;
import jetbrains.datalore.plot.base.data.DataFrameUtil;
import jetbrains.datalore.plot.common.data.SeriesUtil;
import jetbrains.datalore.plot.server.config.transform.bistro.corr.CorrVar;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0005\b\u00c0\u0002\u0018\u00002\u00020\u0001:\u0001\u001fB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J`\u0010\u0003\u001a\u001a\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0004\u0012\u00020\u00070\u00042\u001a\u0010\b\u001a\u0016\u0012\u0004\u0012\u00020\u0006\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010\t0\u00042$\u0010\n\u001a \u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\t\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\t\u0012\u0004\u0012\u00020\u00070\u000bJN\u0010\f\u001a\u00020\u00072\u000e\u0010\r\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00070\t2\u000e\u0010\u000e\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00070\t2$\u0010\n\u001a \u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\t\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\t\u0012\u0004\u0012\u00020\u00070\u000bH\u0002J:\u0010\u000f\u001a\u001a\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0004\u0012\u00020\u00070\u00042\u001a\u0010\u0010\u001a\u0016\u0012\u0004\u0012\u00020\u0006\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010\t0\u0004J>\u0010\u0011\u001a\u0016\u0012\u0004\u0012\u00020\u0006\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010\t0\u00042\u0006\u0010\u0012\u001a\u00020\u00132\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00060\t2\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00060\tJt\u0010\u0016\u001a\u001a\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\t\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\t0\u00052\u001e\u0010\u0017\u001a\u001a\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0004\u0012\u00020\u00070\u00042\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00060\t2\u0006\u0010\u0019\u001a\u00020\u00062\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u00072\u0006\u0010\u001d\u001a\u00020\u001b2\u0006\u0010\u001e\u001a\u00020\u001b\u00a8\u0006 "}, d2={"Ljetbrains/datalore/plot/server/config/transform/bistro/corr/CorrUtil;", "", "()V", "computeCorrelations", "", "Lkotlin/Pair;", "", "", "data", "", "corrFun", "Lkotlin/Function2;", "correlation", "xs", "ys", "correlationsFromCoefficients", "coeff", "correlationsToDataframe", "cm", "Ljetbrains/datalore/plot/server/config/transform/bistro/corr/CorrUtil$CorrMatrix;", "xSeries", "ySeries", "matrixXYSeries", "correlations", "variablesInOrder", "type", "nullDiag", "", "threshold", "dropDiagNA", "dropOtherNA", "CorrMatrix", "plot-config-portable"})
public final class CorrUtil {
    @NotNull
    public static final CorrUtil INSTANCE = new CorrUtil();

    private CorrUtil() {
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Map<Pair<String, String>, Double> computeCorrelations(@NotNull Map<String, ? extends List<? extends Object>> data, @NotNull Function2<? super List<Double>, ? super List<Double>, Double> corrFun) {
        void $this$mapKeysTo$iv$iv;
        Object object;
        Object object2;
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter(data, (String)"data");
        Intrinsics.checkNotNullParameter(corrFun, (String)"corrFun");
        DataFrame df = DataFrameUtil.INSTANCE.fromMap(data);
        Iterable $this$filter$iv = df.variables();
        boolean $i$f$filter22 = false;
        Iterable iterable = $this$filter$iv;
        Object destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo2 = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            DataFrame.Variable it = (DataFrame.Variable)element$iv$iv;
            boolean bl = false;
            if (!df.isNumeric(it)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List numerics = (List)destination$iv$iv;
        LinkedHashMap correlations2 = new LinkedHashMap();
        for (DataFrame.Variable variable : numerics) {
            destination$iv$iv = correlations2;
            Pair $i$f$filterTo2 = TuplesKt.to((Object)variable, (Object)variable);
            Double d = 1.0;
            boolean element$iv$iv = false;
            destination$iv$iv.put($i$f$filterTo2, d);
        }
        Iterator $i$f$filter22 = numerics.iterator();
        int variable = 0;
        while ($i$f$filter22.hasNext()) {
            int i = variable++;
            DataFrame.Variable vx = (DataFrame.Variable)$i$f$filter22.next();
            List<Double> xs = df.getNumeric(vx);
            int element$iv$iv = 0;
            if (element$iv$iv >= i) continue;
            do {
                int j = element$iv$iv++;
                DataFrame.Variable vy = (DataFrame.Variable)numerics.get(j);
                List<Double> ys = df.getNumeric(vy);
                object2 = correlations2;
                Pair pair2 = TuplesKt.to((Object)vx, (Object)vy);
                object = this.correlation(xs, ys, corrFun);
                boolean bl = false;
                object2.put(pair2, object);
            } while (element$iv$iv < i);
        }
        Map $this$mapKeys$iv = correlations2;
        boolean $i$f$mapKeys = false;
        Map i = $this$mapKeys$iv;
        Map destination$iv$iv2 = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapKeys$iv.size()));
        boolean $i$f$mapKeysTo = false;
        Iterable $this$associateByTo$iv$iv$iv = $this$mapKeysTo$iv$iv.entrySet();
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            void it$iv$iv;
            void it;
            object2 = (Map.Entry)element$iv$iv$iv;
            Map map2 = destination$iv$iv2;
            boolean bl = false;
            Pair pair3 = new Pair((Object)((DataFrame.Variable)((Pair)it.getKey()).getFirst()).getLabel(), (Object)((DataFrame.Variable)((Pair)it.getKey()).getSecond()).getLabel());
            object = (Map.Entry)element$iv$iv$iv;
            Pair pair4 = pair3;
            Map map3 = map2;
            boolean bl2 = false;
            object2 = it$iv$iv.getValue();
            map3.put(pair4, object2);
        }
        return destination$iv$iv2;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Map<Pair<String, String>, Double> correlationsFromCoefficients(@NotNull Map<String, ? extends List<? extends Object>> coeff) {
        Intrinsics.checkNotNullParameter(coeff, (String)"coeff");
        LinkedHashMap correlations2 = new LinkedHashMap();
        Map<String, ? extends List<? extends Object>> $this$forEach$iv = coeff;
        boolean $i$f$forEach = false;
        Map<String, ? extends List<? extends Object>> map2 = $this$forEach$iv;
        boolean bl = false;
        Iterator<Map.Entry<String, ? extends List<? extends Object>>> iterator2 = map2.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry<String, ? extends List<? extends Object>> element$iv;
            Map.Entry<String, ? extends List<? extends Object>> $dstr$vx$vxCoeffs = element$iv = iterator2.next();
            boolean bl2 = false;
            Map.Entry<String, ? extends List<? extends Object>> entry = $dstr$vx$vxCoeffs;
            boolean bl3 = false;
            String vx = entry.getKey();
            Map.Entry<String, ? extends List<? extends Object>> entry2 = $dstr$vx$vxCoeffs;
            boolean bl4 = false;
            List<? extends Object> vxCoeffs = entry2.getValue();
            Iterable $this$forEachIndexed$iv = coeff.keySet();
            boolean $i$f$forEachIndexed = false;
            int index$iv = 0;
            for (Object item$iv : $this$forEachIndexed$iv) {
                void vy;
                int n = index$iv++;
                boolean bl5 = false;
                if (n < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                String string = (String)item$iv;
                int vyIndex = n;
                boolean bl6 = false;
                Map map3 = correlations2;
                Pair pair2 = TuplesKt.to((Object)vx, (Object)vy);
                Object object = vxCoeffs.get(vyIndex);
                if (object == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Double");
                }
                object = (double)((Double)object);
                boolean bl7 = false;
                map3.put(pair2, object);
            }
        }
        return correlations2;
    }

    private final double correlation(List<Double> xs, List<Double> ys, Function2<? super List<Double>, ? super List<Double>, Double> corrFun) {
        List<List<Double>> filtered = SeriesUtil.INSTANCE.filterFinite(xs, ys);
        List<Double> xs2 = filtered.get(0);
        List<Double> ys2 = filtered.get(1);
        return ((Number)corrFun.invoke(xs2, ys2)).doubleValue();
    }

    @NotNull
    public final Pair<List<String>, List<String>> matrixXYSeries(@NotNull Map<Pair<String, String>, Double> correlations2, @NotNull List<String> variablesInOrder, @NotNull String type, boolean nullDiag, double threshold, boolean dropDiagNA, boolean dropOtherNA) {
        Intrinsics.checkNotNullParameter(correlations2, (String)"correlations");
        Intrinsics.checkNotNullParameter(variablesInOrder, (String)"variablesInOrder");
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        ArrayList<String> xs = new ArrayList<String>();
        ArrayList<String> ys = new ArrayList<String>();
        CorrMatrix cm2 = new CorrMatrix(correlations2, nullDiag, threshold);
        Iterator<String> iterator2 = variablesInOrder.iterator();
        int n = 0;
        while (iterator2.hasNext()) {
            int ix = n++;
            String x2 = iterator2.next();
            String string = type;
            List<String> iterY = Intrinsics.areEqual((Object)string, (Object)"upper") ? variablesInOrder.subList(ix, variablesInOrder.size()) : (Intrinsics.areEqual((Object)string, (Object)"lower") ? variablesInOrder.subList(0, ix + 1) : variablesInOrder);
            for (String y2 : iterY) {
                Double v = cm2.value(x2, y2);
                if (v == null && (dropDiagNA && Intrinsics.areEqual((Object)x2, (Object)y2) || dropOtherNA && !Intrinsics.areEqual((Object)x2, (Object)y2))) continue;
                xs.add(x2);
                ys.add(y2);
            }
        }
        return new Pair(xs, ys);
    }

    @NotNull
    public final Map<String, List<Object>> correlationsToDataframe(@NotNull CorrMatrix cm2, @NotNull List<String> xSeries, @NotNull List<String> ySeries) {
        Intrinsics.checkNotNullParameter((Object)cm2, (String)"cm");
        Intrinsics.checkNotNullParameter(xSeries, (String)"xSeries");
        Intrinsics.checkNotNullParameter(ySeries, (String)"ySeries");
        ArrayList<String> corrX = new ArrayList<String>();
        ArrayList<String> corrY = new ArrayList<String>();
        ArrayList<Double> corr = new ArrayList<Double>();
        ArrayList<Double> corrAbs = new ArrayList<Double>();
        for (Pair pair2 : CollectionsKt.zip((Iterable)xSeries, (Iterable)ySeries)) {
            String y2;
            String x2 = (String)pair2.component1();
            Double d = cm2.value(x2, y2 = (String)pair2.component2());
            if (d == null) continue;
            double v = d;
            corrX.add(x2);
            corrY.add(y2);
            corr.add(v);
            double d2 = v;
            boolean bl = false;
            corrAbs.add(Math.abs(d2));
        }
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)CorrVar.INSTANCE.getX(), corrX), TuplesKt.to((Object)CorrVar.INSTANCE.getY(), corrY), TuplesKt.to((Object)CorrVar.INSTANCE.getCORR(), corr), TuplesKt.to((Object)CorrVar.INSTANCE.getCORR_ABS(), corrAbs)};
        return MapsKt.mapOf((Pair[])pairArray);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u000b\b\u0000\u0018\u00002\u00020\u0001B5\u0012\u001e\u0010\u0002\u001a\u001a\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u0004\u0012\u0004\u0012\u00020\u00060\u0003\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\nJ(\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u00042\u0012\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u0004H\u0002J$\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\r\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u0005H\u0002J\u001d\u0010\u000f\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0012R&\u0010\u0002\u001a\u001a\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u0004\u0012\u0004\u0012\u00020\u00060\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Ljetbrains/datalore/plot/server/config/transform/bistro/corr/CorrUtil$CorrMatrix;", "", "correlations", "", "Lkotlin/Pair;", "", "", "nullDiag", "", "threshold", "(Ljava/util/Map;ZD)V", "toKey", "pair", "s0", "s1", "value", "x", "y", "(Ljava/lang/String;Ljava/lang/String;)Ljava/lang/Double;", "plot-config-portable"})
    public static final class CorrMatrix {
        private final boolean nullDiag;
        private final double threshold;
        @NotNull
        private final Map<Pair<String, String>, Double> correlations;

        /*
         * WARNING - void declaration
         */
        public CorrMatrix(@NotNull Map<Pair<String, String>, Double> correlations2, boolean nullDiag, double threshold) {
            Map map2;
            void $this$mapKeysTo$iv$iv;
            void $this$mapKeys$iv;
            Intrinsics.checkNotNullParameter(correlations2, (String)"correlations");
            this.nullDiag = nullDiag;
            this.threshold = threshold;
            Map<Pair<String, String>, Double> map3 = correlations2;
            CorrMatrix corrMatrix = this;
            boolean $i$f$mapKeys = false;
            void var7_7 = $this$mapKeys$iv;
            Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapKeys$iv.size()));
            boolean $i$f$mapKeysTo = false;
            Iterable $this$associateByTo$iv$iv$iv = $this$mapKeysTo$iv$iv.entrySet();
            boolean $i$f$associateByTo = false;
            for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
                void it$iv$iv;
                void it;
                Map.Entry entry = (Map.Entry)element$iv$iv$iv;
                map2 = destination$iv$iv;
                boolean bl = false;
                Pair<String, String> pair2 = this.toKey((Pair<String, String>)((Pair)it.getKey()));
                Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
                Pair<String, String> pair3 = pair2;
                Map map4 = map2;
                boolean bl2 = false;
                Object v = it$iv$iv.getValue();
                map4.put(pair3, v);
            }
            corrMatrix.correlations = map2 = destination$iv$iv;
        }

        private final Pair<String, String> toKey(String s0, String s1) {
            return s0.compareTo(s1) < 0 ? TuplesKt.to((Object)s0, (Object)s1) : TuplesKt.to((Object)s1, (Object)s0);
        }

        private final Pair<String, String> toKey(Pair<String, String> pair2) {
            return this.toKey((String)pair2.getFirst(), (String)pair2.getSecond());
        }

        /*
         * WARNING - void declaration
         */
        @Nullable
        public final Double value(@NotNull String x2, @NotNull String y2) {
            Object object;
            Intrinsics.checkNotNullParameter((Object)x2, (String)"x");
            Intrinsics.checkNotNullParameter((Object)y2, (String)"y");
            if (Intrinsics.areEqual((Object)x2, (Object)y2) && this.nullDiag) {
                object = null;
            } else {
                Double v = this.correlations.get(this.toKey(x2, y2));
                if (v == null) {
                    object = null;
                } else {
                    void var3_3;
                    double d = v;
                    boolean bl = false;
                    object = Math.abs(d) < this.threshold ? null : var3_3;
                }
            }
            return object;
        }
    }
}

