/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.datalore.plot.builder.presentation;

import jetbrains.datalore.base.geometry.DoubleVector;
import jetbrains.datalore.plot.builder.presentation.LabelSpec;
import jetbrains.datalore.plot.builder.presentation.Serializable;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\u0018\u0000 \u00152\u00020\u00012\u00020\u0002:\u0001\u0015B\u0007\b\u0016\u00a2\u0006\u0002\u0010\u0003B#\b\u0017\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\tJ\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\b\u0010\u0013\u001a\u00020\u0005H\u0016J\u0010\u0010\u0014\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u0012H\u0016R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0014\u0010\u000e\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\r\u00a8\u0006\u0016"}, d2={"Ljetbrains/datalore/plot/builder/presentation/LabelMetrics;", "Ljetbrains/datalore/plot/builder/presentation/LabelSpec;", "Ljetbrains/datalore/plot/builder/presentation/Serializable;", "()V", "fontSize", "", "bold", "", "monospaced", "(DZZ)V", "getFontSize", "()D", "isBold", "()Z", "isMonospaced", "dimensions", "Ljetbrains/datalore/base/geometry/DoubleVector;", "labelLength", "", "height", "width", "Companion", "plot-builder-portable"})
public final class LabelMetrics
implements LabelSpec,
Serializable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final double fontSize;
    private final boolean isBold;
    private final boolean isMonospaced;
    private static final double FONT_SIZE_TO_GLYPH_WIDTH_RATIO = 0.67;
    private static final double FONT_SIZE_TO_GLYPH_WIDTH_RATIO_MONOSPACED = 0.6;
    private static final double FONT_WEIGHT_BOLD_TO_NORMAL_WIDTH_RATIO = 1.075;
    private static final double LABEL_PADDING = 0.0;

    @Override
    public double getFontSize() {
        return this.fontSize;
    }

    @Override
    public boolean isBold() {
        return this.isBold;
    }

    @Override
    public boolean isMonospaced() {
        return this.isMonospaced;
    }

    public LabelMetrics() {
        this.fontSize = 0.0;
        this.isBold = false;
        this.isMonospaced = false;
    }

    @JvmOverloads
    public LabelMetrics(double fontSize, boolean bold, boolean monospaced) {
        this.fontSize = fontSize;
        this.isBold = bold;
        this.isMonospaced = monospaced;
    }

    public /* synthetic */ LabelMetrics(double d, boolean bl, boolean bl2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            bl = false;
        }
        if ((n & 4) != 0) {
            bl2 = false;
        }
        this(d, bl, bl2);
    }

    @Override
    @NotNull
    public DoubleVector dimensions(int labelLength) {
        return new DoubleVector(this.width(labelLength), this.height());
    }

    @Override
    public double width(int labelLength) {
        double ratio = 0.67;
        if (this.isMonospaced()) {
            ratio = 0.6;
        }
        double width2 = (double)labelLength * this.getFontSize() * ratio + 0.0;
        return this.isBold() ? width2 * 1.075 : width2;
    }

    @Override
    public double height() {
        return this.getFontSize() + 0.0;
    }

    @JvmOverloads
    public LabelMetrics(double fontSize, boolean bold) {
        this(fontSize, bold, false, 4, null);
    }

    @JvmOverloads
    public LabelMetrics(double fontSize) {
        this(fontSize, false, false, 6, null);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Ljetbrains/datalore/plot/builder/presentation/LabelMetrics$Companion;", "", "()V", "FONT_SIZE_TO_GLYPH_WIDTH_RATIO", "", "FONT_SIZE_TO_GLYPH_WIDTH_RATIO_MONOSPACED", "FONT_WEIGHT_BOLD_TO_NORMAL_WIDTH_RATIO", "LABEL_PADDING", "plot-builder-portable"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

