/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.datalore.base.values;

import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import jetbrains.datalore.base.values.Color;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.Intrinsics;
import kotlin.random.Random;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\u0011\n\u0002\b\n\n\u0002\u0010\u0013\n\u0000\n\u0002\u0010\u000b\n\u0002\b\f\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\n\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0016\u0010\r\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\bJ\u001e\u0010\u0010\u001a\u0004\u0018\u00010\b2\b\u0010\u0011\u001a\u0004\u0018\u00010\b2\b\b\u0002\u0010\u0012\u001a\u00020\u0004H\u0007J!\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\b0\u00142\u0006\u0010\u0015\u001a\u00020\f2\u0006\u0010\u0016\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0017J\u000e\u0010\u0018\u001a\u00020\b2\u0006\u0010\u0019\u001a\u00020\u0007J\u0016\u0010\u001a\u001a\u00020\b2\u0006\u0010\u001b\u001a\u00020\u00042\u0006\u0010\u001c\u001a\u00020\u0004J\u0006\u0010\u001d\u001a\u00020\u0004J\u000e\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u000e\u001a\u00020\bJ\u000e\u0010 \u001a\u00020!2\u0006\u0010\u0019\u001a\u00020\u0007J\u001a\u0010\"\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\b2\b\b\u0002\u0010\u0012\u001a\u00020\u0004H\u0007J\u000e\u0010#\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\bJ\u001e\u0010$\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\b2\u0006\u0010%\u001a\u00020\u00042\u0006\u0010&\u001a\u00020\bJ\u000e\u0010'\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\u0007J\"\u0010(\u001a\u00020\b2\u0006\u0010)\u001a\u00020\u00042\u0006\u0010\u001b\u001a\u00020\u00042\b\b\u0002\u0010\u001c\u001a\u00020\u0004H\u0007J\u000e\u0010*\u001a\u00020!2\u0006\u0010\u0011\u001a\u00020\bJ\u0016\u0010+\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\b2\u0006\u0010,\u001a\u00020\u0004R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006-"}, d2={"Ljetbrains/datalore/base/values/Colors;", "", "()V", "DEFAULT_FACTOR", "", "namedColors", "", "", "Ljetbrains/datalore/base/values/Color;", "variantColors", "colorLuminance", "componentValue", "", "contrast", "color", "other", "darker", "c", "factor", "distributeEvenly", "", "count", "saturation", "(ID)[Ljetbrains/datalore/base/values/Color;", "forName", "colorName", "generateColor", "s", "v", "generateHueColor", "hsvFromRgb", "", "isColorName", "", "lighter", "luminance", "mimicTransparency", "alpha", "background", "parseColor", "rgbFromHsv", "h", "solid", "withOpacity", "opacity", "base-portable"})
public final class Colors {
    @NotNull
    public static final Colors INSTANCE;
    private static final double DEFAULT_FACTOR = 0.7;
    @NotNull
    private static final Map<String, Color> variantColors;
    @NotNull
    private static final Map<String, Color> namedColors;

    private Colors() {
    }

    @NotNull
    public final Color parseColor(@NotNull String c) {
        Color color;
        Intrinsics.checkNotNullParameter((Object)c, (String)"c");
        if (StringsKt.indexOf$default((CharSequence)c, (char)'(', (int)0, (boolean)false, (int)6, null) > 0) {
            color = Color.Companion.parseRGB(c);
        } else if (StringsKt.startsWith$default((String)c, (String)"#", (boolean)false, (int)2, null)) {
            color = Color.Companion.parseHex(c);
        } else if (this.isColorName(c)) {
            color = this.forName(c);
        } else {
            throw new IllegalArgumentException(Intrinsics.stringPlus((String)"Error persing color value: ", (Object)c));
        }
        return color;
    }

    public final boolean isColorName(@NotNull String colorName) {
        Intrinsics.checkNotNullParameter((Object)colorName, (String)"colorName");
        String string = colorName;
        boolean bl = false;
        String string2 = string.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"(this as java.lang.Strin\u2026.toLowerCase(Locale.ROOT)");
        return namedColors.containsKey(string2);
    }

    @NotNull
    public final Color forName(@NotNull String colorName) {
        Intrinsics.checkNotNullParameter((Object)colorName, (String)"colorName");
        String string = colorName;
        boolean bl = false;
        String string2 = string.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"(this as java.lang.Strin\u2026.toLowerCase(Locale.ROOT)");
        Color color = namedColors.get(string2);
        if (color == null) {
            throw new IllegalArgumentException();
        }
        return color;
    }

    public final double generateHueColor() {
        return (double)360 * Random.Default.nextDouble();
    }

    @NotNull
    public final Color generateColor(double s2, double v) {
        return this.rgbFromHsv((double)360 * Random.Default.nextDouble(), s2, v);
    }

    @JvmOverloads
    @NotNull
    public final Color rgbFromHsv(double h, double s2, double v) {
        double hd = h / (double)60;
        double c = v * s2;
        double d = hd % (double)2 - 1.0;
        boolean bl = false;
        double x2 = c * (1.0 - Math.abs(d));
        double r = 0.0;
        double g = 0.0;
        double b = 0.0;
        if (hd < 1.0) {
            r = c;
            g = x2;
        } else if (hd < 2.0) {
            r = x2;
            g = c;
        } else if (hd < 3.0) {
            g = c;
            b = x2;
        } else if (hd < 4.0) {
            g = x2;
            b = c;
        } else if (hd < 5.0) {
            r = x2;
            b = c;
        } else {
            r = c;
            b = x2;
        }
        double m = v - c;
        return new Color((int)((double)255 * (r + m)), (int)((double)255 * (g + m)), (int)((double)255 * (b + m)), 0, 8, null);
    }

    public static /* synthetic */ Color rgbFromHsv$default(Colors colors, double d, double d2, double d3, int n, Object object) {
        if ((n & 4) != 0) {
            d3 = 1.0;
        }
        return colors.rgbFromHsv(d, d2, d3);
    }

    @NotNull
    public final double[] hsvFromRgb(@NotNull Color color) {
        Intrinsics.checkNotNullParameter((Object)color, (String)"color");
        double scale = 0.003921568859368563;
        double r = (double)color.getRed() * scale;
        double g = (double)color.getGreen() * scale;
        double b = (double)color.getBlue() * scale;
        boolean bl = false;
        double d = Math.min(g, b);
        boolean bl2 = false;
        double min = Math.min(r, d);
        bl2 = false;
        double d2 = Math.max(g, b);
        boolean bl3 = false;
        double max = Math.max(r, d2);
        double v = max == 0.0 ? 0.0 : 1.0 - min / max;
        double h = 0.0;
        double div = (double)1.0f / ((double)6 * (max - min));
        h = max == min ? 0.0 : (max == r ? (g >= b ? (g - b) * div : 1.0 + (g - b) * div) : (max == g ? (double)0.33333334f + (b - r) * div : (double)0.6666667f + (r - g) * div));
        double[] dArray = new double[]{(double)360 * h, v, max};
        return dArray;
    }

    @JvmOverloads
    @Nullable
    public final Color darker(@Nullable Color c, double factor) {
        Color color;
        Color color2 = c;
        if (color2 == null) {
            color = null;
        } else {
            Color color3 = color2;
            boolean bl = false;
            boolean bl2 = false;
            Color it = color3;
            boolean bl3 = false;
            int n = (int)((double)c.getRed() * factor);
            int n2 = 0;
            boolean bl4 = false;
            int n3 = Math.max(n, n2);
            n = (int)((double)c.getGreen() * factor);
            n2 = 0;
            bl4 = false;
            int n4 = Math.max(n, n2);
            n = (int)((double)c.getBlue() * factor);
            n2 = 0;
            bl4 = false;
            Color color4 = new Color(n3, n4, Math.max(n, n2), c.getAlpha());
            color = color4;
        }
        return color;
    }

    public static /* synthetic */ Color darker$default(Colors colors, Color color, double d, int n, Object object) {
        if ((n & 2) != 0) {
            d = 0.7;
        }
        return colors.darker(color, d);
    }

    @JvmOverloads
    @NotNull
    public final Color lighter(@NotNull Color c, double factor) {
        Intrinsics.checkNotNullParameter((Object)c, (String)"c");
        int r = c.getRed();
        int g = c.getGreen();
        int b = c.getBlue();
        int alpha = c.getAlpha();
        int i = (int)(1.0 / (1.0 - factor));
        if (r == 0 && g == 0 && b == 0) {
            return new Color(i, i, i, alpha);
        }
        if (r > 0 && r < i) {
            r = i;
        }
        if (g > 0 && g < i) {
            g = i;
        }
        if (b > 0 && b < i) {
            b = i;
        }
        int n = (int)((double)r / factor);
        int n2 = 255;
        boolean bl = false;
        int n3 = Math.min(n, n2);
        n = (int)((double)g / factor);
        n2 = 255;
        bl = false;
        int n4 = Math.min(n, n2);
        n = (int)((double)b / factor);
        n2 = 255;
        bl = false;
        return new Color(n3, n4, Math.min(n, n2), alpha);
    }

    public static /* synthetic */ Color lighter$default(Colors colors, Color color, double d, int n, Object object) {
        if ((n & 2) != 0) {
            d = 0.7;
        }
        return colors.lighter(color, d);
    }

    @NotNull
    public final Color mimicTransparency(@NotNull Color color, double alpha, @NotNull Color background) {
        Intrinsics.checkNotNullParameter((Object)color, (String)"color");
        Intrinsics.checkNotNullParameter((Object)background, (String)"background");
        int red = (int)((double)color.getRed() * alpha + (double)background.getRed() * (1.0 - alpha));
        int green = (int)((double)color.getGreen() * alpha + (double)background.getGreen() * (1.0 - alpha));
        int blue = (int)((double)color.getBlue() * alpha + (double)background.getBlue() * (1.0 - alpha));
        return new Color(red, green, blue, 0, 8, null);
    }

    @NotNull
    public final Color withOpacity(@NotNull Color c, double opacity) {
        Color color;
        Intrinsics.checkNotNullParameter((Object)c, (String)"c");
        if (opacity < 1.0) {
            int n = 0;
            int n2 = 255;
            double d = (double)255 * opacity;
            boolean bl = false;
            int n3 = (int)Math.rint(d);
            boolean bl2 = false;
            n2 = Math.min(n2, n3);
            n3 = 0;
            color = c.changeAlpha(Math.max(n, n2));
        } else {
            color = c;
        }
        return color;
    }

    public final double contrast(@NotNull Color color, @NotNull Color other) {
        Intrinsics.checkNotNullParameter((Object)color, (String)"color");
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return (this.luminance(color) + 0.05) / (this.luminance(other) + 0.05);
    }

    public final double luminance(@NotNull Color color) {
        Intrinsics.checkNotNullParameter((Object)color, (String)"color");
        return 0.2126 * this.colorLuminance(color.getRed()) + 0.7152 * this.colorLuminance(color.getGreen()) + 0.0722 * this.colorLuminance(color.getBlue());
    }

    private final double colorLuminance(int componentValue) {
        double d;
        if (componentValue <= 10) {
            d = (double)componentValue / 3294.0;
        } else {
            double d2 = (double)componentValue / 269.0 + 0.0513;
            double d3 = 2.4;
            boolean bl = false;
            d = Math.pow(d2, d3);
        }
        return d;
    }

    public final boolean solid(@NotNull Color c) {
        Intrinsics.checkNotNullParameter((Object)c, (String)"c");
        return c.getAlpha() == 255;
    }

    @NotNull
    public final Color[] distributeEvenly(int count2, double saturation) {
        Color[] result = new Color[count2];
        int sector = 360 / count2;
        int n = 0;
        if (n < count2) {
            do {
                int i = n++;
                result[i] = Colors.rgbFromHsv$default(this, sector * i, saturation, 0.0, 4, null);
            } while (n < count2);
        }
        return result;
    }

    @JvmOverloads
    @NotNull
    public final Color rgbFromHsv(double h, double s2) {
        return Colors.rgbFromHsv$default(this, h, s2, 0.0, 4, null);
    }

    @JvmOverloads
    @Nullable
    public final Color darker(@Nullable Color c) {
        return Colors.darker$default(this, c, 0.0, 2, null);
    }

    @JvmOverloads
    @NotNull
    public final Color lighter(@NotNull Color c) {
        Intrinsics.checkNotNullParameter((Object)c, (String)"c");
        return Colors.lighter$default(this, c, 0.0, 2, null);
    }

    static {
        Map.Entry it$iv$iv;
        boolean bl;
        Map map2;
        String string;
        String string2;
        Object it;
        Map map3;
        Map.Entry entry;
        Map<String, Color> $this$mapKeysTo$iv$iv;
        Map<String, Color> $this$mapKeys$iv;
        INSTANCE = new Colors();
        Object object = new Pair[]{TuplesKt.to((Object)"dark_blue", (Object)Color.Companion.getDARK_BLUE()), TuplesKt.to((Object)"dark_green", (Object)Color.Companion.getDARK_GREEN()), TuplesKt.to((Object)"dark_magenta", (Object)Color.Companion.getDARK_MAGENTA()), TuplesKt.to((Object)"light_blue", (Object)Color.Companion.getLIGHT_BLUE()), TuplesKt.to((Object)"light_gray", (Object)Color.Companion.getLIGHT_GRAY()), TuplesKt.to((Object)"light_green", (Object)Color.Companion.getLIGHT_GREEN()), TuplesKt.to((Object)"light_yellow", (Object)Color.Companion.getLIGHT_YELLOW()), TuplesKt.to((Object)"light_magenta", (Object)Color.Companion.getLIGHT_MAGENTA()), TuplesKt.to((Object)"light_cyan", (Object)Color.Companion.getLIGHT_CYAN()), TuplesKt.to((Object)"light_pink", (Object)Color.Companion.getLIGHT_PINK()), TuplesKt.to((Object)"very_light_gray", (Object)Color.Companion.getVERY_LIGHT_GRAY()), TuplesKt.to((Object)"very_light_yellow", (Object)Color.Companion.getVERY_LIGHT_YELLOW())};
        variantColors = MapsKt.mapOf((Pair[])object);
        object = new Pair[]{TuplesKt.to((Object)"white", (Object)Color.Companion.getWHITE()), TuplesKt.to((Object)"black", (Object)Color.Companion.getBLACK()), TuplesKt.to((Object)"gray", (Object)Color.Companion.getGRAY()), TuplesKt.to((Object)"red", (Object)Color.Companion.getRED()), TuplesKt.to((Object)"green", (Object)Color.Companion.getGREEN()), TuplesKt.to((Object)"blue", (Object)Color.Companion.getBLUE()), TuplesKt.to((Object)"yellow", (Object)Color.Companion.getYELLOW()), TuplesKt.to((Object)"magenta", (Object)Color.Companion.getMAGENTA()), TuplesKt.to((Object)"cyan", (Object)Color.Companion.getCYAN()), TuplesKt.to((Object)"orange", (Object)Color.Companion.getORANGE()), TuplesKt.to((Object)"pink", (Object)Color.Companion.getPINK())};
        Map map4 = MapsKt.plus((Map)MapsKt.mapOf((Pair[])object), variantColors);
        object = variantColors;
        Map map5 = map4;
        boolean $i$f$mapKeys = false;
        void var2_3 = $this$mapKeys$iv;
        Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapKeys$iv.size()));
        boolean $i$f$mapKeysTo = false;
        Iterable $this$associateByTo$iv$iv$iv = $this$mapKeysTo$iv$iv.entrySet();
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            entry = (Map.Entry)element$iv$iv$iv;
            map3 = destination$iv$iv;
            boolean bl2 = false;
            string2 = StringsKt.replace$default((String)((String)it.getKey()), (char)'_', (char)'-', (boolean)false, (int)4, null);
            Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
            string = string2;
            map2 = map3;
            bl = false;
            it = it$iv$iv.getValue();
            map2.put(string, it);
        }
        map3 = destination$iv$iv;
        $this$mapKeys$iv = variantColors;
        map5 = MapsKt.plus((Map)map5, (Map)map3);
        $i$f$mapKeys = false;
        $this$mapKeysTo$iv$iv = $this$mapKeys$iv;
        destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapKeys$iv.size()));
        $i$f$mapKeysTo = false;
        $this$associateByTo$iv$iv$iv = $this$mapKeysTo$iv$iv.entrySet();
        $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            it = (Map.Entry)element$iv$iv$iv;
            map3 = destination$iv$iv;
            boolean bl3 = false;
            string2 = StringsKt.replace$default((String)((String)it.getKey()), (String)"_", (String)"", (boolean)false, (int)4, null);
            it$iv$iv = (Map.Entry)element$iv$iv$iv;
            string = string2;
            map2 = map3;
            bl = false;
            entry = it$iv$iv.getValue();
            map2.put(string, entry);
        }
        map3 = destination$iv$iv;
        namedColors = MapsKt.plus((Map)map5, (Map)map3);
    }
}

