/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.datalore.plot.config.transform.encode;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jetbrains.datalore.base.gcommon.base.Preconditions;
import jetbrains.datalore.plot.base.DataFrame;
import jetbrains.datalore.plot.base.data.DataFrameUtil;
import jetbrains.datalore.plot.common.base64.BinaryUtil;
import jetbrains.datalore.plot.common.data.SeriesUtil;
import jetbrains.datalore.plot.config.transform.encode.DataFrameEncoding;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0000\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0006\u001a\u00020\u00072\u000e\u0010\b\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\tJ(\u0010\n\u001a\u0012\u0012\u0004\u0012\u00020\u0004\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000b0\t2\u0010\u0010\b\u001a\f\u0012\u0004\u0012\u00020\u0004\u0012\u0002\b\u00030\tJ\u0018\u0010\f\u001a\f\u0012\u0004\u0012\u00020\u0004\u0012\u0002\b\u00030\t2\u0006\u0010\r\u001a\u00020\u0007J&\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00010\t2\u0012\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00010\tJ\u0016\u0010\u0010\u001a\u00020\u00112\u000e\u0010\b\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\tJ\u000e\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u0001R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Ljetbrains/datalore/plot/config/transform/encode/DataFrameEncoding;", "", "()V", "DATA_FRAME_KEY", "", "DATA_SPEC_KEY", "decode", "Ljetbrains/datalore/plot/base/DataFrame;", "map", "", "decode1", "", "encode", "data", "encode1", "dataSpec", "isEncodedDataFrame", "", "isEncodedDataSpec", "o", "plot-config"})
public final class DataFrameEncoding {
    private static final String DATA_FRAME_KEY = "__data_frame_encoded";
    private static final String DATA_SPEC_KEY = "__data_spec_encoded";
    public static final DataFrameEncoding INSTANCE;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean isEncodedDataFrame(@NotNull Map<?, ?> map2) {
        Intrinsics.checkNotNullParameter(map2, (String)"map");
        if (map2.size() != 1) return false;
        Map<?, ?> map3 = map2;
        String string = DATA_FRAME_KEY;
        boolean bl = false;
        if (!map3.containsKey(string)) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean isEncodedDataSpec(@NotNull Object o) {
        Intrinsics.checkNotNullParameter((Object)o, (String)"o");
        if (!(o instanceof Map)) return false;
        if (((Map)o).size() != 1) return false;
        Map map2 = (Map)o;
        String string = DATA_SPEC_KEY;
        boolean bl = false;
        if (!map2.containsKey(string)) return false;
        return true;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final DataFrame decode(@NotNull Map<?, ?> map2) {
        Intrinsics.checkNotNullParameter(map2, (String)"map");
        Preconditions.INSTANCE.checkArgument(this.isEncodedDataFrame(map2), "Not a data frame");
        Map<?, ?> map3 = map2;
        String string = DATA_FRAME_KEY;
        boolean bl = false;
        Object obj = map3.get(string);
        if (obj == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.collections.List<*>");
        }
        List encodedData = (List)obj;
        Object e = encodedData.get(0);
        if (e == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.collections.List<*>");
        }
        List varNames = (List)e;
        Object e2 = encodedData.get(1);
        if (e2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.collections.List<*>");
        }
        List varLabels = (List)e2;
        Object e3 = encodedData.get(2);
        if (e3 == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.collections.List<*>");
        }
        List isNumeric = (List)e3;
        DataFrame.Builder b = new DataFrame.Builder();
        int n = 0;
        int n2 = ((Collection)varNames).size();
        while (n < n2) {
            void i;
            Object e4 = varNames.get((int)i);
            if (e4 == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.String");
            }
            String name = (String)e4;
            Object e5 = varLabels.get((int)i);
            if (e5 == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.String");
            }
            String label = (String)e5;
            Object e6 = isNumeric.get((int)i);
            if (e6 == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.Boolean");
            }
            boolean numeric2 = (Boolean)e6;
            DataFrame.Variable variable = DataFrameUtil.INSTANCE.createVariable(name, label);
            Object o = encodedData.get(3 + i);
            if (numeric2) {
                Object e7 = o;
                if (e7 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.String");
                }
                List<Double> v = BinaryUtil.INSTANCE.decodeList((String)e7);
                b.putNumeric(variable, v);
            } else {
                Object e8 = o;
                if (e8 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.collections.List<*>");
                }
                b.put(variable, (List)e8);
            }
            ++i;
        }
        return b.build();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Map<String, List<?>> decode1(@NotNull Map<String, ?> map2) {
        Intrinsics.checkNotNullParameter(map2, (String)"map");
        Preconditions.INSTANCE.checkArgument(this.isEncodedDataSpec(map2), "Not an encoded data spec");
        Object obj = map2.get(DATA_SPEC_KEY);
        if (obj == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.collections.List<*>");
        }
        List encodedData = (List)obj;
        Object e = encodedData.get(0);
        if (e == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.collections.List<*>");
        }
        List varNames = (List)e;
        Object e2 = encodedData.get(1);
        if (e2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.collections.List<*>");
        }
        List isNumeric = (List)e2;
        int seriesStart = 2;
        HashMap decoded = new HashMap();
        int n = 0;
        int n2 = ((Collection)varNames).size();
        while (n < n2) {
            List<Double> list2;
            void i;
            Object e3 = varNames.get((int)i);
            if (e3 == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.String");
            }
            String name = (String)e3;
            Object e4 = isNumeric.get((int)i);
            if (e4 == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.Boolean");
            }
            boolean numeric2 = (Boolean)e4;
            Object o = encodedData.get(seriesStart + i);
            if (numeric2) {
                Object e5 = o;
                if (e5 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.String");
                }
                list2 = BinaryUtil.INSTANCE.decodeList((String)e5);
            } else {
                Object e6 = o;
                if (e6 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.collections.List<*>");
                }
                list2 = (List<Double>)e6;
            }
            List<Double> v = list2;
            ((Map)decoded).put(name, v);
            ++i;
        }
        return decoded;
    }

    @NotNull
    public final Map<String, ?> encode(@NotNull DataFrame data) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        HashMap map2 = new HashMap();
        ArrayList<Object> encodedData = new ArrayList<Object>();
        ((Map)map2).put(DATA_FRAME_KEY, encodedData);
        ArrayList<String> varNames = new ArrayList<String>();
        ArrayList<String> varLabels = new ArrayList<String>();
        ArrayList<Boolean> isNumeric = new ArrayList<Boolean>();
        encodedData.add(varNames);
        encodedData.add(varLabels);
        encodedData.add(isNumeric);
        ArrayList variables = new ArrayList(data.variables());
        CollectionsKt.sortWith((List)variables, (Comparator)encode.1.INSTANCE);
        for (DataFrame.Variable variable : variables) {
            varNames.add(variable.getName());
            varLabels.add(variable.getLabel());
            DataFrame.Variable variable2 = variable;
            Intrinsics.checkNotNullExpressionValue((Object)variable2, (String)"variable");
            boolean numeric2 = data.isNumeric(variable2);
            isNumeric.add(numeric2);
            List<Double> v = data.get(variable);
            if (numeric2) {
                List<Double> list2 = v;
                if (list2 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.collections.List<kotlin.Double>");
                }
                String b64 = BinaryUtil.INSTANCE.encodeList(list2);
                encodedData.add(b64);
                continue;
            }
            encodedData.add(v);
        }
        return map2;
    }

    @NotNull
    public final Map<String, Object> encode1(@NotNull Map<String, ? extends Object> dataSpec) {
        Intrinsics.checkNotNullParameter(dataSpec, (String)"dataSpec");
        HashMap encoded = new HashMap();
        ArrayList<Object> encodedData = new ArrayList<Object>();
        ((Map)encoded).put(DATA_SPEC_KEY, encodedData);
        ArrayList<String> varNames = new ArrayList<String>();
        ArrayList<Boolean> isNumeric = new ArrayList<Boolean>();
        encodedData.add(varNames);
        encodedData.add(isNumeric);
        ArrayList variables = new ArrayList(dataSpec.keySet());
        CollectionsKt.sort((List)variables);
        for (String variable : variables) {
            Object v = dataSpec.get(variable);
            if (!(v instanceof List)) continue;
            SeriesUtil.CheckedDoubleList checkedDoubles = SeriesUtil.INSTANCE.checkedDoubles((List)v);
            boolean numeric2 = checkedDoubles.notEmptyAndCanBeCast();
            varNames.add(variable);
            isNumeric.add(numeric2);
            if (numeric2) {
                String b64 = BinaryUtil.INSTANCE.encodeList((List<Double>)checkedDoubles.cast());
                encodedData.add(b64);
                continue;
            }
            encodedData.add(v);
        }
        return encoded;
    }

    private DataFrameEncoding() {
    }

    static {
        DataFrameEncoding dataFrameEncoding;
        INSTANCE = dataFrameEncoding = new DataFrameEncoding();
    }
}

