/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.datalore.plot.config;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import jetbrains.datalore.base.gcommon.base.Preconditions;
import jetbrains.datalore.base.geometry.DoubleVector;
import jetbrains.datalore.plot.config.OptionsAccessor;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.TypeIntrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\rB\u0015\u0012\u000e\u0010\u0002\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0003\u00a2\u0006\u0002\u0010\u0004R\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00068F\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u001e\u0010\n\u001a\u0012\u0012\u0004\u0012\u00020\u00070\u000bj\b\u0012\u0004\u0012\u00020\u0007`\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Ljetbrains/datalore/plot/config/BunchConfig;", "Ljetbrains/datalore/plot/config/OptionsAccessor;", "opts", "", "(Ljava/util/Map;)V", "bunchItems", "", "Ljetbrains/datalore/plot/config/BunchConfig$BunchItem;", "getBunchItems", "()Ljava/util/List;", "myItems", "Ljava/util/ArrayList;", "Lkotlin/collections/ArrayList;", "BunchItem", "plot-config-portable"})
public final class BunchConfig
extends OptionsAccessor {
    private final ArrayList<BunchItem> myItems;

    @NotNull
    public final List<BunchItem> getBunchItems() {
        return this.myItems;
    }

    public BunchConfig(@NotNull Map<?, ?> opts) {
        Intrinsics.checkNotNullParameter(opts, (String)"opts");
        super(opts);
        this.myItems = new ArrayList();
        List<?> items = this.getList("items");
        for (Object itemRaw : items) {
            if (!(itemRaw instanceof Map)) continue;
            OptionsAccessor itemOptions = new OptionsAccessor(TypeIntrinsics.asMutableMap(itemRaw));
            Map<?, ?> map2 = itemOptions.getMap("feature_spec");
            Double d = itemOptions.getDouble("x");
            Intrinsics.checkNotNull((Object)d);
            double d2 = d;
            Double d3 = itemOptions.getDouble("y");
            Intrinsics.checkNotNull((Object)d3);
            this.myItems.add(new BunchItem(map2, d2, d3, itemOptions.getDouble("width"), itemOptions.getDouble("height")));
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010$\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B9\u0012\u000e\u0010\u0002\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\b\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\tJ\u0006\u0010\u0016\u001a\u00020\u0017R\u001d\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u00010\u00038F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0016\u0010\u0002\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\b\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000eR\u0012\u0010\u0007\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000eR\u0011\u0010\u000f\u001a\u00020\u00108F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0014\u00a8\u0006\u0018"}, d2={"Ljetbrains/datalore/plot/config/BunchConfig$BunchItem;", "", "myFeatureSpec", "", "x", "", "y", "myWidth", "myHeight", "(Ljava/util/Map;DDLjava/lang/Double;Ljava/lang/Double;)V", "featureSpec", "", "getFeatureSpec", "()Ljava/util/Map;", "Ljava/lang/Double;", "size", "Ljetbrains/datalore/base/geometry/DoubleVector;", "getSize", "()Ljetbrains/datalore/base/geometry/DoubleVector;", "getX", "()D", "getY", "hasSize", "", "plot-config-portable"})
    public static final class BunchItem {
        private final Map<?, ?> myFeatureSpec;
        private final double x;
        private final double y;
        private final Double myWidth;
        private final Double myHeight;

        @NotNull
        public final Map<String, Object> getFeatureSpec() {
            Map<String, Object> map2 = this.myFeatureSpec;
            if (map2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, kotlin.Any>");
            }
            return map2;
        }

        @NotNull
        public final DoubleVector getSize() {
            Preconditions.INSTANCE.checkState(this.hasSize(), "Size is not defined");
            Double d = this.myWidth;
            Intrinsics.checkNotNull((Object)d);
            double d2 = d;
            Double d3 = this.myHeight;
            Intrinsics.checkNotNull((Object)d3);
            return new DoubleVector(d2, d3);
        }

        public final boolean hasSize() {
            return this.myWidth != null && this.myHeight != null;
        }

        public final double getX() {
            return this.x;
        }

        public final double getY() {
            return this.y;
        }

        public BunchItem(@NotNull Map<?, ?> myFeatureSpec, double x2, double y2, @Nullable Double myWidth, @Nullable Double myHeight) {
            Intrinsics.checkNotNullParameter(myFeatureSpec, (String)"myFeatureSpec");
            this.myFeatureSpec = myFeatureSpec;
            this.x = x2;
            this.y = y2;
            this.myWidth = myWidth;
            this.myHeight = myHeight;
        }
    }
}

