/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.datalore.plot.builder.tooltip.layout;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jetbrains.datalore.base.geometry.DoubleRectangle;
import jetbrains.datalore.base.geometry.DoubleSegment;
import jetbrains.datalore.base.geometry.DoubleVector;
import jetbrains.datalore.base.values.Pair;
import jetbrains.datalore.plot.builder.interact.MathUtil;
import jetbrains.datalore.plot.builder.tooltip.layout.LayoutManager;
import jetbrains.datalore.plot.builder.tooltip.layout.VerticalTooltipShiftingExpander$WhenMappings;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010%\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u000e\b\u0000\u0018\u00002\u00020\u0001:\u00010B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J*\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00110\u000f2\u0006\u0010\u0012\u001a\u00020\u00132\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00150\u000bH\u0002J<\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u001b\u001a\u00020\u00152\u0006\u0010\u001c\u001a\u00020\u00102\u0012\u0010\u001d\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00110\u001eH\u0002J5\u0010\u001f\u001a\u00020 2\u0012\u0010!\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00110\u000f2\u0012\u0010\"\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00100#\"\u00020\u0010H\u0002\u00a2\u0006\u0002\u0010$J\u001c\u0010%\u001a\u00020\t2\u0012\u0010\u001d\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00110\u000fH\u0002J.\u0010&\u001a\u00020\u00172\u0018\u0010'\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00130\u00070\u000b2\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00150\u000bJ\u001c\u0010(\u001a\u00020\u00102\u0012\u0010!\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00110\u000fH\u0002J\u0016\u0010)\u001a\b\u0012\u0004\u0012\u00020\t0\u000b2\u0006\u0010*\u001a\u00020\u0019H\u0002J0\u0010+\u001a\u00020\u00172\u0012\u0010,\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00110\u001e2\u0012\u0010-\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00110\u000fH\u0002J\u0018\u0010.\u001a\u00020\t2\u0006\u0010\u001c\u001a\u00020\u00102\u0006\u0010/\u001a\u00020\u0011H\u0002R\"\u0010\u0005\u001a\u0016\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R%\u0010\n\u001a\u0016\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007\u0018\u00010\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\r\u00a8\u00061"}, d2={"Ljetbrains/datalore/plot/builder/tooltip/layout/VerticalTooltipShiftingExpander;", "", "space", "Ljetbrains/datalore/plot/builder/interact/MathUtil$DoubleRange;", "(Ljetbrains/datalore/plot/builder/interact/MathUtil$DoubleRange;)V", "mySpacedTooltips", "", "Ljetbrains/datalore/base/values/Pair;", "", "Ljetbrains/datalore/base/geometry/DoubleVector;", "spacedTooltips", "", "getSpacedTooltips", "()Ljava/util/List;", "analyzeOverlapping", "", "Ljetbrains/datalore/plot/builder/tooltip/layout/VerticalTooltipShiftingExpander$Side;", "", "tooltip", "Ljetbrains/datalore/plot/builder/tooltip/layout/LayoutManager$PositionedTooltip;", "restrictions", "Ljetbrains/datalore/base/geometry/DoubleRectangle;", "checkSideOverlapping", "", "tooltipSide", "Ljetbrains/datalore/base/geometry/DoubleSegment;", "restrictedPart", "intersection", "side", "overlappings", "", "containsAll", "", "map", "keys", "", "(Ljava/util/Map;[Ljetbrains/datalore/plot/builder/tooltip/layout/VerticalTooltipShiftingExpander$Side;)Z", "findVector", "fixOverlapping", "tooltips", "min", "pointsOf", "doubleSegment", "putAllIfGreater", "existingOverlappings", "newOverlappings", "vectorBySide", "overlapping", "Side", "plot-builder"})
public final class VerticalTooltipShiftingExpander {
    private List<Pair<Integer, DoubleVector>> mySpacedTooltips;

    @Nullable
    public final List<Pair<Integer, DoubleVector>> getSpacedTooltips() {
        return this.mySpacedTooltips;
    }

    public final void fixOverlapping(@NotNull List<Pair<Integer, LayoutManager.PositionedTooltip>> tooltips, @NotNull List<DoubleRectangle> restrictions) {
        Intrinsics.checkNotNullParameter(tooltips, (String)"tooltips");
        Intrinsics.checkNotNullParameter(restrictions, (String)"restrictions");
        this.mySpacedTooltips = new ArrayList();
        for (Pair<Integer, LayoutManager.PositionedTooltip> tooltip : tooltips) {
            Map<Side, Double> overlappings = this.analyzeOverlapping(tooltip.getSecond(), restrictions);
            if (overlappings.isEmpty()) {
                List<Pair<Integer, DoubleVector>> list2 = this.mySpacedTooltips;
                Intrinsics.checkNotNull(list2);
                list2.add(new Pair<Integer, DoubleVector>(tooltip.getFirst(), tooltip.getSecond().getTooltipCoord()));
                continue;
            }
            List<Pair<Integer, DoubleVector>> list3 = this.mySpacedTooltips;
            Intrinsics.checkNotNull(list3);
            list3.add(new Pair<Integer, DoubleVector>(tooltip.getFirst(), tooltip.getSecond().getTooltipCoord().add(this.findVector(overlappings))));
        }
    }

    private final Map<Side, Double> analyzeOverlapping(LayoutManager.PositionedTooltip tooltip, List<DoubleRectangle> restrictions) {
        DoubleRectangle tooltipRect = tooltip.rect$plot_builder();
        DoubleSegment topSide = MathUtil.INSTANCE.topEdgeOf(tooltipRect);
        DoubleSegment leftSide = MathUtil.INSTANCE.leftEdgeOf(tooltipRect);
        DoubleSegment bottomSide = MathUtil.INSTANCE.bottomEdgeOf(tooltipRect);
        DoubleSegment rightSide = MathUtil.INSTANCE.rightEdgeOf(tooltipRect);
        HashMap overlappings = new HashMap();
        for (DoubleRectangle restriction : restrictions) {
            DoubleRectangle intersection;
            if (tooltipRect.intersect(restriction) == null) {
                continue;
            }
            HashMap currentOverlappings = new HashMap();
            for (DoubleSegment part : restriction.getParts()) {
                this.checkSideOverlapping(topSide, part, intersection, Side.TOP, currentOverlappings);
                this.checkSideOverlapping(leftSide, part, intersection, Side.LEFT, currentOverlappings);
                this.checkSideOverlapping(bottomSide, part, intersection, Side.BOTTOM, currentOverlappings);
                this.checkSideOverlapping(rightSide, part, intersection, Side.RIGHT, currentOverlappings);
            }
            if (currentOverlappings.isEmpty()) {
                throw (Throwable)new IllegalStateException("Intersection was detected, but no points added");
            }
            if (currentOverlappings.size() == 1) {
                overlappings.putAll(currentOverlappings);
                continue;
            }
            if (currentOverlappings.size() == 2) {
                if (this.containsAll(currentOverlappings, Side.LEFT, Side.RIGHT)) {
                    if (this.pointsOf(MathUtil.INSTANCE.topEdgeOf(tooltipRect)).contains(intersection.getOrigin())) {
                        ((Map)overlappings).put(Side.TOP, intersection.getDimension().getY());
                        continue;
                    }
                    if (!this.pointsOf(MathUtil.INSTANCE.bottomEdgeOf(tooltipRect)).contains(MathUtil.INSTANCE.bottomEdgeOf(intersection).getStart())) continue;
                    ((Map)overlappings).put(Side.BOTTOM, intersection.getDimension().getY());
                    continue;
                }
                if (this.containsAll(currentOverlappings, Side.TOP, Side.BOTTOM)) {
                    if (this.pointsOf(MathUtil.INSTANCE.leftEdgeOf(tooltipRect)).contains(intersection.getOrigin())) {
                        ((Map)overlappings).put(Side.LEFT, intersection.getDimension().getX());
                        continue;
                    }
                    if (!this.pointsOf(MathUtil.INSTANCE.bottomEdgeOf(tooltipRect)).contains(MathUtil.INSTANCE.rightEdgeOf(intersection).getStart())) continue;
                    ((Map)overlappings).put(Side.RIGHT, intersection.getDimension().getX());
                    continue;
                }
                this.putAllIfGreater(overlappings, currentOverlappings);
                continue;
            }
            this.putAllIfGreater(overlappings, currentOverlappings);
        }
        return overlappings;
    }

    private final void putAllIfGreater(Map<Side, Double> existingOverlappings, Map<Side, Double> newOverlappings) {
        for (Side side : newOverlappings.keySet()) {
            if (existingOverlappings.containsKey((Object)side)) {
                Double d = existingOverlappings.get((Object)side);
                Intrinsics.checkNotNull((Object)d);
                if (!(((Number)d).doubleValue() < ((Number)MapsKt.getValue(newOverlappings, (Object)((Object)side))).doubleValue())) continue;
            }
            existingOverlappings.put(side, (Double)MapsKt.getValue(newOverlappings, (Object)((Object)side)));
        }
    }

    private final List<DoubleVector> pointsOf(DoubleSegment doubleSegment) {
        ArrayList<DoubleVector> points2 = new ArrayList<DoubleVector>();
        points2.add(doubleSegment.getStart());
        points2.add(doubleSegment.getEnd());
        return points2;
    }

    private final void checkSideOverlapping(DoubleSegment tooltipSide, DoubleSegment restrictedPart, DoubleRectangle intersection, Side side, Map<Side, Double> overlappings) {
        double intersectionLength;
        if (restrictedPart.intersection(tooltipSide) == null) {
            return;
        }
        double d = intersectionLength = side == Side.LEFT || side == Side.RIGHT ? intersection.getDimension().getX() : intersection.getDimension().getY();
        if (!overlappings.containsKey((Object)side)) {
            overlappings.put(side, intersectionLength);
        } else {
            Double d2 = overlappings.get((Object)side);
            Intrinsics.checkNotNull((Object)d2);
            double d3 = ((Number)d2).doubleValue();
            boolean bl = false;
            overlappings.put(side, Math.max(d3, intersectionLength));
        }
    }

    private final DoubleVector findVector(Map<Side, Double> overlappings) {
        if (overlappings.isEmpty()) {
            return DoubleVector.Companion.getZERO();
        }
        if (overlappings.size() == 1) {
            Side side = overlappings.keySet().iterator().next();
            double value = ((Number)MapsKt.getValue(overlappings, (Object)((Object)side))).doubleValue();
            return this.vectorBySide(side, value);
        }
        if (overlappings.containsKey((Object)Side.LEFT)) {
            return this.vectorBySide(Side.LEFT, ((Number)MapsKt.getValue(overlappings, (Object)((Object)Side.LEFT))).doubleValue());
        }
        if (overlappings.containsKey((Object)Side.RIGHT)) {
            return this.vectorBySide(Side.RIGHT, ((Number)MapsKt.getValue(overlappings, (Object)((Object)Side.RIGHT))).doubleValue());
        }
        Side minOverlappedSide = this.min(overlappings);
        return this.vectorBySide(minOverlappedSide, ((Number)MapsKt.getValue(overlappings, (Object)((Object)minOverlappedSide))).doubleValue());
    }

    private final DoubleVector vectorBySide(Side side, double overlapping) {
        DoubleVector doubleVector;
        switch (VerticalTooltipShiftingExpander$WhenMappings.$EnumSwitchMapping$0[side.ordinal()]) {
            case 1: {
                doubleVector = new DoubleVector(overlapping, 0.0);
                break;
            }
            case 2: {
                doubleVector = new DoubleVector(-overlapping, 0.0);
                break;
            }
            case 3: {
                doubleVector = new DoubleVector(0.0, overlapping);
                break;
            }
            case 4: {
                doubleVector = new DoubleVector(0.0, -overlapping);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return doubleVector;
    }

    private final boolean containsAll(Map<Side, Double> map2, Side ... keys) {
        if (map2.size() != keys.length) {
            return false;
        }
        for (Side side : keys) {
            if (map2.containsKey((Object)side)) continue;
            return false;
        }
        return true;
    }

    private final Side min(Map<Side, Double> map2) {
        Side minSide = null;
        for (Side side : map2.keySet()) {
            if (minSide == null) {
                minSide = side;
                continue;
            }
            if (!(((Number)MapsKt.getValue(map2, (Object)((Object)minSide))).doubleValue() > ((Number)MapsKt.getValue(map2, (Object)((Object)side))).doubleValue())) continue;
            minSide = side;
        }
        Side side = minSide;
        Intrinsics.checkNotNull((Object)((Object)side));
        return side;
    }

    public VerticalTooltipShiftingExpander(@NotNull MathUtil.DoubleRange space) {
        Intrinsics.checkNotNullParameter((Object)space, (String)"space");
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\b\u0080\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Ljetbrains/datalore/plot/builder/tooltip/layout/VerticalTooltipShiftingExpander$Side;", "", "(Ljava/lang/String;I)V", "LEFT", "RIGHT", "TOP", "BOTTOM", "plot-builder"})
    public static final class Side
    extends Enum<Side> {
        public static final /* enum */ Side LEFT;
        public static final /* enum */ Side RIGHT;
        public static final /* enum */ Side TOP;
        public static final /* enum */ Side BOTTOM;
        private static final /* synthetic */ Side[] $VALUES;

        static {
            Side[] sideArray = new Side[4];
            Side[] sideArray2 = sideArray;
            sideArray[0] = LEFT = new Side();
            sideArray[1] = RIGHT = new Side();
            sideArray[2] = TOP = new Side();
            sideArray[3] = BOTTOM = new Side();
            $VALUES = sideArray;
        }

        public static Side[] values() {
            return (Side[])$VALUES.clone();
        }

        public static Side valueOf(String string) {
            return Enum.valueOf(Side.class, string);
        }
    }
}

