/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.datalore.plot.builder.guide;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import jetbrains.datalore.base.geometry.DoubleVector;
import jetbrains.datalore.base.observable.event.EventSource;
import jetbrains.datalore.base.observable.event.EventSources;
import jetbrains.datalore.base.observable.property.Property;
import jetbrains.datalore.base.observable.property.PropertyBinding;
import jetbrains.datalore.base.observable.property.ReadableProperty;
import jetbrains.datalore.base.observable.property.ValueProperty;
import jetbrains.datalore.base.observable.property.WritableProperty;
import jetbrains.datalore.base.values.Color;
import jetbrains.datalore.plot.base.render.svg.SvgComponent;
import jetbrains.datalore.plot.base.render.svg.TextLabel;
import jetbrains.datalore.plot.builder.guide.AxisComponent$WhenMappings;
import jetbrains.datalore.plot.builder.guide.Orientation;
import jetbrains.datalore.vis.svg.SvgGElement;
import jetbrains.datalore.vis.svg.SvgLineElement;
import jetbrains.datalore.vis.svg.SvgUtils;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\b\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\f\u00102\u001a\b\u0012\u0004\u0012\u00020\u001b0\bJ\b\u00103\u001a\u00020\u001bH\u0002J\b\u00104\u001a\u000205H\u0002J\b\u00106\u001a\u000205H\u0014J \u00107\u001a\u0002082\u0006\u00109\u001a\u00020\u00142\u0006\u0010:\u001a\u00020#2\u0006\u0010\u000f\u001a\u00020\u0003H\u0002J\u0010\u0010;\u001a\u00020 2\u0006\u0010\u0004\u001a\u00020\u0005H\u0002J\u0010\u0010<\u001a\u00020*2\u0006\u0010\u0004\u001a\u00020\u0005H\u0002J\b\u0010=\u001a\u00020#H\u0002J\b\u0010>\u001a\u00020\u0003H\u0002J\u0010\u0010?\u001a\u00020#2\u0006\u0010@\u001a\u00020AH\u0002J\f\u0010B\u001a\b\u0012\u0004\u0012\u00020\u001b0\bJ\b\u0010,\u001a\u00020\u0003H\u0002J\f\u0010C\u001a\b\u0012\u0004\u0012\u00020\u001b0\bR\u001f\u0010\u0007\u001a\u0010\u0012\f\u0012\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010\t0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0017\u0010\f\u001a\b\u0012\u0004\u0012\u00020\r0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000bR\u0017\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00030\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000bR\u0017\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00030\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u000bR\u001f\u0010\u0013\u001a\u0010\u0012\f\u0012\n\u0012\u0004\u0012\u00020\u0014\u0018\u00010\t0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u000bR\u0016\u0010\u0002\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00030\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\r0\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00030\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u000bR\u0014\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001b0\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001b0\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001b0\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0004\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\r0\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020 0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\u000bR\u001f\u0010\"\u001a\u0010\u0012\f\u0012\n\u0012\u0004\u0012\u00020#\u0018\u00010\t0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010\u000bR\u0017\u0010%\u001a\b\u0012\u0004\u0012\u00020\u00030\b\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010\u000bR\u0017\u0010'\u001a\b\u0012\u0004\u0012\u00020\u001b0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b(\u0010\u000bR\u0017\u0010)\u001a\b\u0012\u0004\u0012\u00020*0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b+\u0010\u000bR\u0017\u0010,\u001a\b\u0012\u0004\u0012\u00020\u00030\b\u00a2\u0006\b\n\u0000\u001a\u0004\b-\u0010\u000bR\u0017\u0010.\u001a\b\u0012\u0004\u0012\u00020\u00030\b\u00a2\u0006\b\n\u0000\u001a\u0004\b/\u0010\u000bR\u0017\u00100\u001a\b\u0012\u0004\u0012\u00020\u00030\b\u00a2\u0006\b\n\u0000\u001a\u0004\b1\u0010\u000b\u00a8\u0006D"}, d2={"Ljetbrains/datalore/plot/builder/guide/AxisComponent;", "Ljetbrains/datalore/plot/base/render/svg/SvgComponent;", "length", "", "orientation", "Ljetbrains/datalore/plot/builder/guide/Orientation;", "(DLjetbrains/datalore/plot/builder/guide/Orientation;)V", "breaks", "Ljetbrains/datalore/base/observable/property/Property;", "", "getBreaks", "()Ljetbrains/datalore/base/observable/property/Property;", "gridLineColor", "Ljetbrains/datalore/base/values/Color;", "getGridLineColor", "gridLineLength", "getGridLineLength", "gridLineWidth", "getGridLineWidth", "labels", "", "getLabels", "Ljetbrains/datalore/base/observable/property/ValueProperty;", "lineColor", "lineWidth", "getLineWidth", "myAxisLineEnabled", "", "myTickLabelsEnabled", "myTickMarksEnabled", "tickColor", "tickLabelHorizontalAnchor", "Ljetbrains/datalore/plot/base/render/svg/TextLabel$HorizontalAnchor;", "getTickLabelHorizontalAnchor", "tickLabelOffsets", "Ljetbrains/datalore/base/geometry/DoubleVector;", "getTickLabelOffsets", "tickLabelRotationDegree", "getTickLabelRotationDegree", "tickLabelSmallFont", "getTickLabelSmallFont", "tickLabelVerticalAnchor", "Ljetbrains/datalore/plot/base/render/svg/TextLabel$VerticalAnchor;", "getTickLabelVerticalAnchor", "tickMarkLength", "getTickMarkLength", "tickMarkPadding", "getTickMarkPadding", "tickMarkWidth", "getTickMarkWidth", "axisLineEnabled", "breaksEnabled", "buildAxis", "", "buildComponent", "buildTick", "Ljetbrains/datalore/vis/svg/SvgGElement;", "label", "labelOffset", "defTickLabelHorizontalAnchor", "defTickLabelVerticalAnchor", "tickLabelBaseOffset", "tickLabelDistance", "tickLabelOffset", "tickIndex", "", "tickLabelsEnabled", "tickMarksEnabled", "plot-builder-portable"})
public final class AxisComponent
extends SvgComponent {
    @NotNull
    private final Property<List<Double>> breaks;
    @NotNull
    private final Property<List<String>> labels;
    @NotNull
    private final Property<Double> tickLabelRotationDegree;
    @NotNull
    private final Property<TextLabel.HorizontalAnchor> tickLabelHorizontalAnchor;
    @NotNull
    private final Property<TextLabel.VerticalAnchor> tickLabelVerticalAnchor;
    @NotNull
    private final Property<Boolean> tickLabelSmallFont;
    @NotNull
    private final Property<List<DoubleVector>> tickLabelOffsets;
    @NotNull
    private final Property<Color> gridLineColor;
    @NotNull
    private final Property<Double> lineWidth;
    @NotNull
    private final Property<Double> gridLineWidth;
    @NotNull
    private final Property<Double> gridLineLength;
    @NotNull
    private final Property<Double> tickMarkWidth;
    @NotNull
    private final Property<Double> tickMarkLength;
    @NotNull
    private final Property<Double> tickMarkPadding;
    private final ValueProperty<Double> length;
    private final ValueProperty<Orientation> orientation;
    private final ValueProperty<Boolean> myTickMarksEnabled;
    private final ValueProperty<Boolean> myTickLabelsEnabled;
    private final ValueProperty<Boolean> myAxisLineEnabled;
    private final ValueProperty<Color> lineColor;
    private final ValueProperty<Color> tickColor;

    @NotNull
    public final Property<List<Double>> getBreaks() {
        return this.breaks;
    }

    @NotNull
    public final Property<List<String>> getLabels() {
        return this.labels;
    }

    @NotNull
    public final Property<Double> getTickLabelRotationDegree() {
        return this.tickLabelRotationDegree;
    }

    @NotNull
    public final Property<TextLabel.HorizontalAnchor> getTickLabelHorizontalAnchor() {
        return this.tickLabelHorizontalAnchor;
    }

    @NotNull
    public final Property<TextLabel.VerticalAnchor> getTickLabelVerticalAnchor() {
        return this.tickLabelVerticalAnchor;
    }

    @NotNull
    public final Property<Boolean> getTickLabelSmallFont() {
        return this.tickLabelSmallFont;
    }

    @NotNull
    public final Property<List<DoubleVector>> getTickLabelOffsets() {
        return this.tickLabelOffsets;
    }

    @NotNull
    public final Property<Color> getGridLineColor() {
        return this.gridLineColor;
    }

    @NotNull
    public final Property<Double> getLineWidth() {
        return this.lineWidth;
    }

    @NotNull
    public final Property<Double> getGridLineWidth() {
        return this.gridLineWidth;
    }

    @NotNull
    public final Property<Double> getGridLineLength() {
        return this.gridLineLength;
    }

    @NotNull
    public final Property<Double> getTickMarkWidth() {
        return this.tickMarkWidth;
    }

    @NotNull
    public final Property<Double> getTickMarkLength() {
        return this.tickMarkLength;
    }

    @NotNull
    public final Property<Double> getTickMarkPadding() {
        return this.tickMarkPadding;
    }

    private final TextLabel.HorizontalAnchor defTickLabelHorizontalAnchor(Orientation orientation) {
        TextLabel.HorizontalAnchor horizontalAnchor;
        switch (AxisComponent$WhenMappings.$EnumSwitchMapping$0[orientation.ordinal()]) {
            case 1: {
                horizontalAnchor = TextLabel.HorizontalAnchor.RIGHT;
                break;
            }
            case 2: {
                horizontalAnchor = TextLabel.HorizontalAnchor.LEFT;
                break;
            }
            case 3: 
            case 4: {
                horizontalAnchor = TextLabel.HorizontalAnchor.MIDDLE;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return horizontalAnchor;
    }

    private final TextLabel.VerticalAnchor defTickLabelVerticalAnchor(Orientation orientation) {
        switch (AxisComponent$WhenMappings.$EnumSwitchMapping$1[orientation.ordinal()]) {
            case 1: 
            case 2: {
                return TextLabel.VerticalAnchor.CENTER;
            }
            case 3: {
                return TextLabel.VerticalAnchor.BOTTOM;
            }
            case 4: {
                return TextLabel.VerticalAnchor.TOP;
            }
        }
        throw (Throwable)new RuntimeException("Unexpected orientation:" + (Object)((Object)orientation));
    }

    @Override
    protected void buildComponent() {
        this.buildAxis();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final void buildAxis() {
        List breaks;
        SvgGElement rootElement = this.getRootGroup();
        rootElement.addClass("plt-axis");
        if (((Boolean)this.tickLabelSmallFont.get()).booleanValue()) {
            rootElement.addClass("small-tick-font");
        }
        Double d = this.length.get();
        Intrinsics.checkNotNull((Object)d);
        double l = ((Number)d).doubleValue();
        double x1 = 0.0;
        double y1 = 0.0;
        double x2 = 0.0;
        double y2 = 0.0;
        double start = 0.0;
        double end = 0.0;
        Orientation orientation = this.orientation.get();
        if (orientation == null) throw (Throwable)new RuntimeException("Unexpected orientation:" + (Object)((Object)this.orientation.get()));
        switch (AxisComponent$WhenMappings.$EnumSwitchMapping$2[orientation.ordinal()]) {
            case 1: 
            case 2: {
                x1 = x2 = 0.0;
                y1 = start = 0.0;
                y2 = end = l;
                break;
            }
            case 3: 
            case 4: {
                x1 = start = 0.0;
                x2 = end = l;
                y1 = y2 = 0.0;
                break;
            }
            default: {
                throw (Throwable)new RuntimeException("Unexpected orientation:" + (Object)((Object)this.orientation.get()));
            }
        }
        SvgLineElement axisLine = null;
        if (((Boolean)this.axisLineEnabled().get()).booleanValue()) {
            axisLine = new SvgLineElement(x1, y1, x2, y2);
            this.reg(PropertyBinding.INSTANCE.bindOneWay((ReadableProperty)this.lineWidth, (WritableProperty)axisLine.strokeWidth()));
            this.reg(PropertyBinding.INSTANCE.bindOneWay((ReadableProperty)this.lineColor, axisLine.strokeColor()));
        }
        double gridLineMinPos = start + (double)3;
        double gridLineMaxPos = end - (double)3;
        if (this.breaksEnabled() && (breaks = (List)this.breaks.get()) != null && !breaks.isEmpty()) {
            int i;
            List labels = (List)this.labels.get();
            if (labels == null || labels.isEmpty()) {
                labels = new ArrayList();
                int n = 0;
                int n2 = ((Collection)breaks).size();
                while (n < n2) {
                    ((ArrayList)labels).add("");
                    ++i;
                }
            }
            i = 0;
            Iterator iterator2 = breaks.iterator();
            while (iterator2.hasNext()) {
                double br = ((Number)iterator2.next()).doubleValue();
                boolean addGridLine = br >= gridLineMinPos && br <= gridLineMaxPos;
                String label = (String)labels.get(i % labels.size());
                DoubleVector labelOffset = this.tickLabelOffset(i);
                ++i;
                SvgGElement group2 = this.buildTick(label, labelOffset, addGridLine ? ((Number)this.gridLineLength.get()).doubleValue() : 0.0);
                Orientation orientation2 = this.orientation.get();
                if (orientation2 == null) throw (Throwable)new RuntimeException("Unexpected orientation:" + (Object)((Object)this.orientation.get()));
                switch (AxisComponent$WhenMappings.$EnumSwitchMapping$3[orientation2.ordinal()]) {
                    case 1: 
                    case 2: {
                        SvgUtils.INSTANCE.transformTranslate(group2, 0.0, br);
                        break;
                    }
                    case 3: 
                    case 4: {
                        SvgUtils.INSTANCE.transformTranslate(group2, br, 0.0);
                        break;
                    }
                    default: {
                        throw (Throwable)new RuntimeException("Unexpected orientation:" + (Object)((Object)this.orientation.get()));
                    }
                }
                rootElement.children().add(group2);
            }
        }
        if (axisLine == null) return;
        rootElement.children().add(axisLine);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final SvgGElement buildTick(String label, DoubleVector labelOffset, double gridLineLength) {
        SvgLineElement tickMark = null;
        if (((Boolean)this.tickMarksEnabled().get()).booleanValue()) {
            tickMark = new SvgLineElement();
            this.reg(PropertyBinding.INSTANCE.bindOneWay((ReadableProperty)this.tickMarkWidth, (WritableProperty)tickMark.strokeWidth()));
            this.reg(PropertyBinding.INSTANCE.bindOneWay((ReadableProperty)this.tickColor, tickMark.strokeColor()));
        }
        TextLabel tickLabel = null;
        if (((Boolean)this.tickLabelsEnabled().get()).booleanValue()) {
            tickLabel = new TextLabel(label);
            this.reg(PropertyBinding.INSTANCE.bindOneWay((ReadableProperty)this.tickColor, tickLabel.textColor()));
        }
        SvgLineElement gridLine = null;
        if (gridLineLength > 0.0) {
            gridLine = new SvgLineElement();
            this.reg(PropertyBinding.INSTANCE.bindOneWay((ReadableProperty)this.gridLineColor, gridLine.strokeColor()));
            this.reg(PropertyBinding.INSTANCE.bindOneWay((ReadableProperty)this.gridLineWidth, (WritableProperty)gridLine.strokeWidth()));
        }
        double markLength = ((Number)this.tickMarkLength.get()).doubleValue();
        Orientation orientation = this.orientation.get();
        if (orientation == null) throw (Throwable)new RuntimeException("Unexpected orientation:" + (Object)((Object)this.orientation.get()));
        switch (AxisComponent$WhenMappings.$EnumSwitchMapping$4[orientation.ordinal()]) {
            case 1: {
                if (tickMark != null) {
                    tickMark.x2().set(-markLength);
                    tickMark.y2().set(0.0);
                }
                if (gridLine == null) break;
                gridLine.x2().set(gridLineLength);
                gridLine.y2().set(0.0);
                break;
            }
            case 2: {
                if (tickMark != null) {
                    tickMark.x2().set(markLength);
                    tickMark.y2().set(0.0);
                }
                if (gridLine == null) break;
                gridLine.x2().set(-gridLineLength);
                gridLine.y2().set(0.0);
                break;
            }
            case 3: {
                if (tickMark != null) {
                    tickMark.x2().set(0.0);
                    tickMark.y2().set(-markLength);
                }
                if (gridLine == null) break;
                gridLine.x2().set(0.0);
                gridLine.y2().set(gridLineLength);
                break;
            }
            case 4: {
                if (tickMark != null) {
                    tickMark.x2().set(0.0);
                    tickMark.y2().set(markLength);
                }
                if (gridLine == null) break;
                gridLine.x2().set(0.0);
                gridLine.y2().set(-gridLineLength);
                break;
            }
            default: {
                throw (Throwable)new RuntimeException("Unexpected orientation:" + (Object)((Object)this.orientation.get()));
            }
        }
        SvgGElement g = new SvgGElement();
        if (gridLine != null) {
            g.children().add(gridLine);
        }
        if (tickMark != null) {
            g.children().add(tickMark);
        }
        if (tickLabel != null) {
            tickLabel.moveTo(labelOffset.getX(), labelOffset.getY());
            tickLabel.setHorizontalAnchor((TextLabel.HorizontalAnchor)((Object)this.tickLabelHorizontalAnchor.get()));
            tickLabel.setVerticalAnchor((TextLabel.VerticalAnchor)((Object)this.tickLabelVerticalAnchor.get()));
            tickLabel.rotate(((Number)this.tickLabelRotationDegree.get()).doubleValue());
            g.children().add(tickLabel.getRootGroup());
        }
        g.addClass("tick");
        return g;
    }

    private final double tickMarkLength() {
        return this.myTickMarksEnabled.get() != false ? ((Number)this.tickMarkLength.get()).doubleValue() : 0.0;
    }

    private final double tickLabelDistance() {
        return this.tickMarkLength() + ((Number)this.tickMarkPadding.get()).doubleValue();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final DoubleVector tickLabelBaseOffset() {
        double distance = this.tickLabelDistance();
        Orientation orientation = this.orientation.get();
        if (orientation == null) throw (Throwable)new RuntimeException("Unexpected orientation:" + (Object)((Object)this.orientation.get()));
        switch (AxisComponent$WhenMappings.$EnumSwitchMapping$5[orientation.ordinal()]) {
            case 1: {
                DoubleVector doubleVector = new DoubleVector(-distance, 0.0);
                return doubleVector;
            }
            case 2: {
                DoubleVector doubleVector = new DoubleVector(distance, 0.0);
                return doubleVector;
            }
            case 3: {
                DoubleVector doubleVector = new DoubleVector(0.0, -distance);
                return doubleVector;
            }
            case 4: {
                DoubleVector doubleVector = new DoubleVector(0.0, distance);
                return doubleVector;
            }
            default: {
                throw (Throwable)new RuntimeException("Unexpected orientation:" + (Object)((Object)this.orientation.get()));
            }
        }
    }

    private final DoubleVector tickLabelOffset(int tickIndex) {
        List additionalOffsets = (List)this.tickLabelOffsets.get();
        DoubleVector additionalOffset = additionalOffsets != null ? (DoubleVector)additionalOffsets.get(tickIndex) : DoubleVector.Companion.getZERO();
        return this.tickLabelBaseOffset().add(additionalOffset);
    }

    private final boolean breaksEnabled() {
        return this.myTickMarksEnabled.get() != false || this.myTickLabelsEnabled.get() != false;
    }

    @NotNull
    public final Property<Boolean> tickMarksEnabled() {
        return this.myTickMarksEnabled;
    }

    @NotNull
    public final Property<Boolean> tickLabelsEnabled() {
        return this.myTickLabelsEnabled;
    }

    @NotNull
    public final Property<Boolean> axisLineEnabled() {
        return this.myAxisLineEnabled;
    }

    public AxisComponent(double length, @NotNull Orientation orientation) {
        Intrinsics.checkNotNullParameter((Object)((Object)orientation), (String)"orientation");
        this.breaks = new ValueProperty<Object>(null);
        this.labels = new ValueProperty<Object>(null);
        this.tickLabelRotationDegree = new ValueProperty<Double>(0.0);
        this.tickLabelSmallFont = new ValueProperty<Boolean>(false);
        this.tickLabelOffsets = new ValueProperty<Object>(null);
        this.gridLineColor = new ValueProperty<Color>(Color.Companion.getLIGHT_GRAY());
        this.lineWidth = new ValueProperty<Double>(1.0);
        this.gridLineWidth = new ValueProperty<Double>(1.0);
        this.gridLineLength = new ValueProperty<Double>(0.0);
        this.tickMarkWidth = new ValueProperty<Double>(1.0);
        this.tickMarkLength = new ValueProperty<Double>(6.0);
        this.tickMarkPadding = new ValueProperty<Double>(3.0);
        this.length = new ValueProperty<Object>(null);
        this.orientation = new ValueProperty<Object>(null);
        this.myTickMarksEnabled = new ValueProperty<Boolean>(true);
        this.myTickLabelsEnabled = new ValueProperty<Boolean>(true);
        this.myAxisLineEnabled = new ValueProperty<Boolean>(true);
        this.lineColor = new ValueProperty<Color>(Color.Companion.getBLACK());
        this.tickColor = new ValueProperty<Color>(Color.Companion.getBLACK());
        this.length.set(length);
        this.orientation.set(orientation);
        this.tickLabelHorizontalAnchor = new ValueProperty<TextLabel.HorizontalAnchor>(this.defTickLabelHorizontalAnchor(orientation));
        this.tickLabelVerticalAnchor = new ValueProperty<TextLabel.VerticalAnchor>(this.defTickLabelVerticalAnchor(orientation));
        1 $fun$asPropertyChangedEventSource$1 = 1.INSTANCE;
        EventSources.INSTANCE.composite($fun$asPropertyChangedEventSource$1.invoke((EventSource)this.length), $fun$asPropertyChangedEventSource$1.invoke((EventSource)this.orientation), $fun$asPropertyChangedEventSource$1.invoke((EventSource)this.breaks), $fun$asPropertyChangedEventSource$1.invoke((EventSource)this.labels), $fun$asPropertyChangedEventSource$1.invoke((EventSource)this.gridLineLength), $fun$asPropertyChangedEventSource$1.invoke((EventSource)this.tickLabelOffsets), $fun$asPropertyChangedEventSource$1.invoke((EventSource)this.tickLabelHorizontalAnchor), $fun$asPropertyChangedEventSource$1.invoke((EventSource)this.tickLabelVerticalAnchor), $fun$asPropertyChangedEventSource$1.invoke((EventSource)this.tickLabelRotationDegree), $fun$asPropertyChangedEventSource$1.invoke((EventSource)this.tickLabelSmallFont)).addHandler(this.rebuildHandler());
    }
}

