/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.datalore.plot.builder;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jetbrains.datalore.base.gcommon.collect.ClosedRange;
import jetbrains.datalore.base.geometry.DoubleRectangle;
import jetbrains.datalore.base.geometry.DoubleVector;
import jetbrains.datalore.base.observable.property.Property;
import jetbrains.datalore.base.observable.property.ValueProperty;
import jetbrains.datalore.base.values.Color;
import jetbrains.datalore.base.values.SomeFig;
import jetbrains.datalore.plot.base.Aes;
import jetbrains.datalore.plot.base.Aesthetics;
import jetbrains.datalore.plot.base.CoordinateSystem;
import jetbrains.datalore.plot.base.Geom;
import jetbrains.datalore.plot.base.PositionAdjustment;
import jetbrains.datalore.plot.base.Scale;
import jetbrains.datalore.plot.base.geom.LiveMapProvider;
import jetbrains.datalore.plot.base.interact.GeomTargetLocator;
import jetbrains.datalore.plot.base.render.svg.SvgComponent;
import jetbrains.datalore.plot.base.render.svg.TextLabel;
import jetbrains.datalore.plot.base.scale.Mappers;
import jetbrains.datalore.plot.builder.AxisUtil;
import jetbrains.datalore.plot.builder.GeomLayer;
import jetbrains.datalore.plot.builder.LayerRendererUtil;
import jetbrains.datalore.plot.builder.PlotTileKt;
import jetbrains.datalore.plot.builder.SvgLayerRenderer;
import jetbrains.datalore.plot.builder.assemble.GeomContextBuilder;
import jetbrains.datalore.plot.builder.assemble.ImmutableGeomContext;
import jetbrains.datalore.plot.builder.guide.AxisComponent;
import jetbrains.datalore.plot.builder.guide.Orientation;
import jetbrains.datalore.plot.builder.interact.loc.LayerTargetCollectorWithLocator;
import jetbrains.datalore.plot.builder.layout.AxisLayoutInfo;
import jetbrains.datalore.plot.builder.layout.TileLayoutInfo;
import jetbrains.datalore.plot.builder.theme.AxisTheme;
import jetbrains.datalore.plot.builder.theme.Theme;
import jetbrains.datalore.vis.svg.SvgRectElement;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u00a4\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u0000 >2\u00020\u0001:\u0001>BO\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\u0006\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\u0002\u0010\u0011J\u0010\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020(H\u0002J\u0010\u0010)\u001a\u00020&2\u0006\u0010'\u001a\u00020(H\u0002J.\u0010*\u001a\u00020+2\f\u0010,\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u00020\u000e2\u0006\u00100\u001a\u000201H\u0002J\b\u00102\u001a\u00020&H\u0014J`\u00103\u001a\b\u0012\u0004\u0012\u00020\u00010\u00032(\u00104\u001a$\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000706\u0012\u0014\u0012\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u0007\u0012\u0006\u0012\u0004\u0018\u00010\u000707052\u001e\u00108\u001a\u001a\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000706\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000709052\u0006\u0010/\u001a\u00020\u000eH\u0002J\f\u0010:\u001a\b\u0012\u0004\u0012\u00020\u00130;J\u000e\u0010<\u001a\u00020&2\u0006\u0010=\u001a\u00020\u0013R\u0014\u0010\u0012\u001a\u00020\u00138BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0014R\"\u0010\u0017\u001a\u0004\u0018\u00010\u00162\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00130\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u001e\u001a\u0012\u0012\u0004\u0012\u00020 0\u001fj\b\u0012\u0004\u0012\u00020 `!X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\"\u001a\b\u0012\u0004\u0012\u00020 0\u00038F\u00a2\u0006\u0006\u001a\u0004\b#\u0010$\u00a8\u0006?"}, d2={"Ljetbrains/datalore/plot/builder/PlotTile;", "Ljetbrains/datalore/plot/base/render/svg/SvgComponent;", "layers", "", "Ljetbrains/datalore/plot/builder/GeomLayer;", "myScaleX", "Ljetbrains/datalore/plot/base/Scale;", "", "myScaleY", "myTilesOrigin", "Ljetbrains/datalore/base/geometry/DoubleVector;", "myLayoutInfo", "Ljetbrains/datalore/plot/builder/layout/TileLayoutInfo;", "myCoord", "Ljetbrains/datalore/plot/base/CoordinateSystem;", "myTheme", "Ljetbrains/datalore/plot/builder/theme/Theme;", "(Ljava/util/List;Ljetbrains/datalore/plot/base/Scale;Ljetbrains/datalore/plot/base/Scale;Ljetbrains/datalore/base/geometry/DoubleVector;Ljetbrains/datalore/plot/builder/layout/TileLayoutInfo;Ljetbrains/datalore/plot/base/CoordinateSystem;Ljetbrains/datalore/plot/builder/theme/Theme;)V", "isDebugDrawing", "", "()Z", "<set-?>", "Ljetbrains/datalore/base/values/SomeFig;", "liveMapFigure", "getLiveMapFigure", "()Ljetbrains/datalore/base/values/SomeFig;", "myDebugDrawing", "Ljetbrains/datalore/base/observable/property/ValueProperty;", "myLayers", "myShowAxis", "myTargetLocators", "Ljava/util/ArrayList;", "Ljetbrains/datalore/plot/base/interact/GeomTargetLocator;", "Lkotlin/collections/ArrayList;", "targetLocators", "getTargetLocators", "()Ljava/util/List;", "addAxis", "", "geomBounds", "Ljetbrains/datalore/base/geometry/DoubleRectangle;", "addFacetLabels", "buildAxis", "Ljetbrains/datalore/plot/builder/guide/AxisComponent;", "scale", "info", "Ljetbrains/datalore/plot/builder/layout/AxisLayoutInfo;", "coord", "theme", "Ljetbrains/datalore/plot/builder/theme/AxisTheme;", "buildComponent", "buildGeoms", "sharedNumericMappers", "", "Ljetbrains/datalore/plot/base/Aes;", "Lkotlin/Function1;", "overallNumericDomains", "Ljetbrains/datalore/base/gcommon/collect/ClosedRange;", "debugDrawing", "Ljetbrains/datalore/base/observable/property/Property;", "setShowAxis", "showAxis", "Companion", "plot-builder-portable"})
public final class PlotTile
extends SvgComponent {
    private final ValueProperty<Boolean> myDebugDrawing;
    private final List<GeomLayer> myLayers;
    private final ArrayList<GeomTargetLocator> myTargetLocators;
    private boolean myShowAxis;
    @Nullable
    private SomeFig liveMapFigure;
    private final Scale<Double> myScaleX;
    private final Scale<Double> myScaleY;
    private final DoubleVector myTilesOrigin;
    private final TileLayoutInfo myLayoutInfo;
    private final CoordinateSystem myCoord;
    private final Theme myTheme;
    private static final double FACET_LABEL_HEIGHT = 30.0;
    public static final Companion Companion = new Companion(null);

    @Nullable
    public final SomeFig getLiveMapFigure() {
        return this.liveMapFigure;
    }

    @NotNull
    public final List<GeomTargetLocator> getTargetLocators() {
        return this.myTargetLocators;
    }

    private final boolean isDebugDrawing() {
        return this.myDebugDrawing.get();
    }

    @Override
    protected void buildComponent() {
        Object v0;
        DoubleRectangle geomBounds;
        block8: {
            geomBounds = this.myLayoutInfo.getGeomBounds();
            this.addFacetLabels(geomBounds);
            Iterable $this$firstOrNull$iv = this.myLayers;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                GeomLayer it = (GeomLayer)element$iv;
                boolean bl = false;
                if (!it.isLiveMap()) continue;
                v0 = element$iv;
                break block8;
            }
            v0 = null;
        }
        GeomLayer liveMapGeomLayer = v0;
        if (liveMapGeomLayer == null && this.myShowAxis) {
            this.addAxis(geomBounds);
        }
        if (this.isDebugDrawing()) {
            DoubleRectangle tileBounds = this.myLayoutInfo.getBounds();
            SvgRectElement rect2 = new SvgRectElement(tileBounds);
            rect2.fillColor().set(Color.Companion.getBLACK());
            rect2.strokeWidth().set(0.0);
            rect2.fillOpacity().set(0.1);
            this.add(rect2);
        }
        if (this.isDebugDrawing()) {
            DoubleRectangle clipBounds = this.myLayoutInfo.getClipBounds();
            SvgRectElement rect3 = new SvgRectElement(clipBounds);
            rect3.fillColor().set(Color.Companion.getDARK_GREEN());
            rect3.strokeWidth().set(0.0);
            rect3.fillOpacity().set(0.3);
            this.add(rect3);
        }
        if (this.isDebugDrawing()) {
            SvgRectElement rect4 = new SvgRectElement(geomBounds);
            rect4.fillColor().set(Color.Companion.getPINK());
            rect4.strokeWidth().set(1.0);
            rect4.fillOpacity().set(0.5);
            this.add(rect4);
        }
        if (liveMapGeomLayer != null) {
            DoubleRectangle realBounds = this.myLayoutInfo.getAbsoluteGeomBounds(this.myTilesOrigin);
            LiveMapProvider.LiveMapData liveMapData = PlotTileKt.access$createCanvasFigure(liveMapGeomLayer, realBounds);
            this.liveMapFigure = liveMapData.getCanvasFigure();
            this.myTargetLocators.add(liveMapData.getTargetLocator());
        } else {
            HashMap sharedNumericMappers = new HashMap();
            HashMap overallNumericDomains = new HashMap();
            AxisLayoutInfo xAxisInfo = this.myLayoutInfo.getXAxisInfo();
            AxisLayoutInfo yAxisInfo = this.myLayoutInfo.getYAxisInfo();
            Function1<Double, Double> mapperX = this.myScaleX.getMapper();
            Function1<Double, Double> mapperY = this.myScaleY.getMapper();
            ((Map)sharedNumericMappers).put(Aes.Companion.getX(), mapperX);
            ((Map)sharedNumericMappers).put(Aes.Companion.getY(), mapperY);
            Map map2 = sharedNumericMappers;
            Aes<Double> aes = Aes.Companion.getSLOPE();
            Object object = mapperY.invoke((Object)1.0);
            Intrinsics.checkNotNull((Object)object);
            double d = ((Number)object).doubleValue();
            Object object2 = mapperX.invoke((Object)1.0);
            Intrinsics.checkNotNull((Object)object2);
            map2.put(aes, Mappers.INSTANCE.mul(d / ((Number)object2).doubleValue()));
            Map map3 = overallNumericDomains;
            Aes<Double> aes2 = Aes.Companion.getX();
            AxisLayoutInfo axisLayoutInfo = xAxisInfo;
            Intrinsics.checkNotNull((Object)axisLayoutInfo);
            ClosedRange<Double> closedRange = axisLayoutInfo.getAxisDomain();
            Intrinsics.checkNotNull(closedRange);
            map3.put(aes2, closedRange);
            Map map4 = overallNumericDomains;
            Aes<Double> aes3 = Aes.Companion.getY();
            AxisLayoutInfo axisLayoutInfo2 = yAxisInfo;
            Intrinsics.checkNotNull((Object)axisLayoutInfo2);
            ClosedRange<Double> closedRange2 = axisLayoutInfo2.getAxisDomain();
            Intrinsics.checkNotNull(closedRange2);
            map4.put(aes3, closedRange2);
            List<SvgComponent> geomLayerComponents = this.buildGeoms(sharedNumericMappers, overallNumericDomains, this.myCoord);
            for (SvgComponent layerComponent : geomLayerComponents) {
                layerComponent.moveTo(geomBounds.getOrigin());
                layerComponent.clipBounds(new DoubleRectangle(DoubleVector.Companion.getZERO(), geomBounds.getDimension()));
                this.add(layerComponent);
            }
        }
    }

    private final void addFacetLabels(DoubleRectangle geomBounds) {
        double y2;
        double x2;
        double h;
        double w;
        TextLabel lab;
        if (this.myLayoutInfo.getFacetXLabel() != null) {
            lab = new TextLabel(this.myLayoutInfo.getFacetXLabel());
            w = geomBounds.getWidth();
            h = 30.0;
            x2 = geomBounds.getLeft() + w / (double)2;
            y2 = geomBounds.getTop() - h / (double)2;
            lab.moveTo(x2, y2);
            lab.setHorizontalAnchor(TextLabel.HorizontalAnchor.MIDDLE);
            lab.setVerticalAnchor(TextLabel.VerticalAnchor.CENTER);
            this.add(lab);
        }
        if (this.myLayoutInfo.getFacetYLabel() != null) {
            lab = new TextLabel(this.myLayoutInfo.getFacetYLabel());
            w = 30.0;
            h = geomBounds.getHeight();
            x2 = geomBounds.getRight() + w / (double)2;
            y2 = geomBounds.getTop() + h / (double)2;
            lab.moveTo(x2, y2);
            lab.setHorizontalAnchor(TextLabel.HorizontalAnchor.MIDDLE);
            lab.setVerticalAnchor(TextLabel.VerticalAnchor.CENTER);
            lab.rotate(90.0);
            this.add(lab);
        }
    }

    private final void addAxis(DoubleRectangle geomBounds) {
        AxisComponent axis;
        if (this.myLayoutInfo.getXAxisShown()) {
            AxisLayoutInfo axisLayoutInfo = this.myLayoutInfo.getXAxisInfo();
            Intrinsics.checkNotNull((Object)axisLayoutInfo);
            axis = this.buildAxis(this.myScaleX, axisLayoutInfo, this.myCoord, this.myTheme.axisX());
            axis.moveTo(new DoubleVector(geomBounds.getLeft(), geomBounds.getBottom()));
            this.add(axis);
        }
        if (this.myLayoutInfo.getYAxisShown()) {
            AxisLayoutInfo axisLayoutInfo = this.myLayoutInfo.getYAxisInfo();
            Intrinsics.checkNotNull((Object)axisLayoutInfo);
            axis = this.buildAxis(this.myScaleY, axisLayoutInfo, this.myCoord, this.myTheme.axisY());
            axis.moveTo(geomBounds.getOrigin());
            this.add(axis);
        }
    }

    private final AxisComponent buildAxis(Scale<Double> scale, AxisLayoutInfo info, CoordinateSystem coord, AxisTheme theme) {
        double d = info.getAxisLength();
        Orientation orientation = info.getOrientation();
        Intrinsics.checkNotNull((Object)((Object)orientation));
        AxisComponent axis = new AxisComponent(d, orientation);
        AxisUtil.INSTANCE.setBreaks(axis, scale, coord, info.getOrientation().isHorizontal());
        AxisUtil.INSTANCE.applyLayoutInfo(axis, info);
        AxisUtil.INSTANCE.applyTheme(axis, theme);
        if (this.isDebugDrawing() && info.getTickLabelsBounds() != null) {
            SvgRectElement rect2 = new SvgRectElement(info.getTickLabelsBounds());
            rect2.strokeColor().set(Color.Companion.getGREEN());
            rect2.strokeWidth().set(1.0);
            rect2.fillOpacity().set(0.0);
            axis.add(rect2);
        }
        return axis;
    }

    private final List<SvgComponent> buildGeoms(Map<Aes<Double>, ? extends Function1<? super Double, Double>> sharedNumericMappers, Map<Aes<Double>, ? extends ClosedRange<Double>> overallNumericDomains, CoordinateSystem coord) {
        ArrayList<SvgLayerRenderer> layerRenderers = new ArrayList<SvgLayerRenderer>();
        for (GeomLayer layer : this.myLayers) {
            LayerRendererUtil.LayerRendererData rendererData = LayerRendererUtil.INSTANCE.createLayerRendererData(layer, sharedNumericMappers, overallNumericDomains);
            Map<Aes<?>, Function1<Double, Object>> aestheticMappers = rendererData.getAestheticMappers();
            Aesthetics aesthetics = rendererData.getAesthetics();
            LayerTargetCollectorWithLocator targetCollector = new LayerTargetCollectorWithLocator(layer.getGeomKind(), layer.getLocatorLookupSpec(), layer.getContextualMapping());
            this.myTargetLocators.add(targetCollector);
            ImmutableGeomContext ctx2 = new GeomContextBuilder().aesthetics(aesthetics).aestheticMappers(aestheticMappers).geomTargetCollector(targetCollector).build();
            PositionAdjustment pos = rendererData.getPos();
            Geom geom = layer.getGeom();
            layerRenderers.add(new SvgLayerRenderer(aesthetics, geom, pos, coord, ctx2));
        }
        return layerRenderers;
    }

    public final void setShowAxis(boolean showAxis) {
        this.myShowAxis = showAxis;
    }

    @NotNull
    public final Property<Boolean> debugDrawing() {
        return this.myDebugDrawing;
    }

    public PlotTile(@NotNull List<? extends GeomLayer> layers, @NotNull Scale<Double> myScaleX, @NotNull Scale<Double> myScaleY, @NotNull DoubleVector myTilesOrigin, @NotNull TileLayoutInfo myLayoutInfo, @NotNull CoordinateSystem myCoord, @NotNull Theme myTheme) {
        Intrinsics.checkNotNullParameter(layers, (String)"layers");
        Intrinsics.checkNotNullParameter(myScaleX, (String)"myScaleX");
        Intrinsics.checkNotNullParameter(myScaleY, (String)"myScaleY");
        Intrinsics.checkNotNullParameter((Object)myTilesOrigin, (String)"myTilesOrigin");
        Intrinsics.checkNotNullParameter((Object)myLayoutInfo, (String)"myLayoutInfo");
        Intrinsics.checkNotNullParameter((Object)myCoord, (String)"myCoord");
        Intrinsics.checkNotNullParameter((Object)myTheme, (String)"myTheme");
        this.myScaleX = myScaleX;
        this.myScaleY = myScaleY;
        this.myTilesOrigin = myTilesOrigin;
        this.myLayoutInfo = myLayoutInfo;
        this.myCoord = myCoord;
        this.myTheme = myTheme;
        this.myDebugDrawing = new ValueProperty<Boolean>(false);
        this.myTargetLocators = new ArrayList();
        this.myLayers = new ArrayList(layers);
        this.moveTo(this.myLayoutInfo.getAbsoluteBounds(this.myTilesOrigin).getOrigin());
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Ljetbrains/datalore/plot/builder/PlotTile$Companion;", "", "()V", "FACET_LABEL_HEIGHT", "", "plot-builder-portable"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

