/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.datalore.plot.base.stat.math3;

import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=2, d1={"\u0000\u0010\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u0013\n\u0002\b\u0003\u001a\u0016\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0003\u001a\u000e\u0010\u0005\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u00a8\u0006\u0006"}, d2={"correlationPearson", "", "xs", "", "ys", "mean", "plot-base-portable"})
public final class CorrelationKt {
    public static final double mean(@NotNull double[] xs) {
        Intrinsics.checkNotNullParameter((Object)xs, (String)"xs");
        return ArraysKt.average((double[])xs);
    }

    /*
     * WARNING - void declaration
     */
    public static final double correlationPearson(@NotNull double[] xs, @NotNull double[] ys) {
        Intrinsics.checkNotNullParameter((Object)xs, (String)"xs");
        Intrinsics.checkNotNullParameter((Object)ys, (String)"ys");
        boolean bl = xs.length == ys.length;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "Two series must have the same size.";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        bl = xs.length > 0;
        bl2 = false;
        bl3 = false;
        if (!bl) {
            boolean bl5 = false;
            String string = "Can't correlate empty sequences.";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        double mx = CorrelationKt.mean(xs);
        double my = CorrelationKt.mean(ys);
        double cov = 0.0;
        double d2x = 0.0;
        double d2y = 0.0;
        int n = 0;
        int n2 = xs.length;
        while (n < n2) {
            void i;
            double dx = xs[i] - mx;
            double dy = ys[i] - my;
            cov += dx * dy;
            double d = dx;
            int n3 = 2;
            boolean bl6 = false;
            d2x += Math.pow(d, n3);
            d = dy;
            n3 = 2;
            bl6 = false;
            d2y += Math.pow(d, n3);
            ++i;
        }
        n = d2x != 0.0 && d2y != 0.0 ? 1 : 0;
        n2 = 0;
        boolean bl7 = false;
        if (n == 0) {
            boolean bl8 = false;
            String string = "Correlation is not defined for sequences with zero variation.";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        double d = d2x * d2y;
        bl7 = false;
        return cov / Math.sqrt(d);
    }
}

