/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.datalore.plot.base.stat;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import jetbrains.datalore.base.gcommon.collect.ClosedRange;
import jetbrains.datalore.plot.base.stat.DensityStat;
import jetbrains.datalore.plot.base.stat.DensityStatUtil;
import jetbrains.datalore.plot.base.stat.DensityStatUtil$WhenMappings;
import jetbrains.datalore.plot.base.stat.FiveNumberSummary;
import jetbrains.datalore.plot.common.data.SeriesUtil;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u0013\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u000e\u0010\b\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00040\tJc\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u000e\u0010\r\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00040\t2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00040\t2\u0012\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u00102\u0006\u0010\u0006\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u00042\u000e\u0010\u0012\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00040\t\u00a2\u0006\u0002\u0010\u0013J\"\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00040\t2\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00040\u00162\u0006\u0010\u0017\u001a\u00020\u0018J]\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u00102\u000e\u0010\b\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00040\t2\u0012\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u00102\u0006\u0010\u0006\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u00042\u000e\u0010\u001a\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00040\tH\u0000\u00a2\u0006\u0002\b\u001bJ\u001a\u0010\u001c\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u00102\u0006\u0010\u000f\u001a\u00020\u001dJ\u0014\u0010\u001e\u001a\u00020\u00042\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00040\tJ\u000e\u0010 \u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020!J\u000e\u0010\"\u001a\u00020\u001d2\u0006\u0010#\u001a\u00020!R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Ljetbrains/datalore/plot/base/stat/DensityStatUtil;", "", "()V", "DEF_STEP_SIZE", "", "bandWidth", "bw", "Ljetbrains/datalore/plot/base/stat/DensityStat$BandWidthMethod;", "valuesX", "", "createRawMatrix", "", "", "values", "list", "ker", "Lkotlin/Function1;", "ad", "weight", "(Ljava/util/List;Ljava/util/List;Lkotlin/jvm/functions/Function1;DDLjava/util/List;)[[D", "createStepValues", "range", "Ljetbrains/datalore/base/gcommon/collect/ClosedRange;", "n", "", "densityFunction", "weightX", "densityFunction$plot_base_portable", "kernel", "Ljetbrains/datalore/plot/base/stat/DensityStat$Kernel;", "stdDev", "data", "toBandWidthMethod", "", "toKernel", "method", "plot-base-portable"})
public final class DensityStatUtil {
    private static final double DEF_STEP_SIZE;
    public static final DensityStatUtil INSTANCE;

    public final double stdDev(@NotNull List<Double> data) {
        Intrinsics.checkNotNullParameter(data, (String)"data");
        double sum = 0.0;
        double counter = 0.0;
        Iterator<Double> iterator2 = data.iterator();
        while (iterator2.hasNext()) {
            double i = ((Number)iterator2.next()).doubleValue();
            sum += i;
        }
        double mean = sum / (double)data.size();
        Iterator<Double> iterator3 = data.iterator();
        while (iterator3.hasNext()) {
            double i = ((Number)iterator3.next()).doubleValue();
            double d = i - mean;
            double d2 = 2.0;
            boolean bl = false;
            counter += Math.pow(d, d2);
        }
        double d = counter / (double)data.size();
        boolean bl = false;
        return Math.sqrt(d);
    }

    /*
     * WARNING - void declaration
     */
    public final double bandWidth(@NotNull DensityStat.BandWidthMethod bw, @NotNull List<Double> valuesX) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)((Object)bw), (String)"bw");
        Intrinsics.checkNotNullParameter(valuesX, (String)"valuesX");
        int mySize = valuesX.size();
        Iterable $this$filter$iv = valuesX;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Double it = (Double)element$iv$iv;
            boolean bl = false;
            if (!SeriesUtil.INSTANCE.isFinite(it)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List valuesXFinite = (List)destination$iv$iv;
        FiveNumberSummary dataSummary = new FiveNumberSummary(valuesXFinite);
        double myIQR = dataSummary.getThirdQuartile() - dataSummary.getFirstQuartile();
        double myStdD = this.stdDev(valuesXFinite);
        switch (DensityStatUtil$WhenMappings.$EnumSwitchMapping$0[bw.ordinal()]) {
            case 1: {
                if (myIQR > 0.0) {
                    double d = myIQR / 1.34;
                    boolean bl = false;
                    double d2 = 0.9 * Math.min(myStdD, d);
                    d = mySize;
                    double d3 = -0.2;
                    boolean bl2 = false;
                    return d2 * Math.pow(d, d3);
                }
                if (!(myStdD > 0.0)) break;
                double d = mySize;
                double d4 = -0.2;
                boolean bl = false;
                return 0.9 * myStdD * Math.pow(d, d4);
            }
            case 2: {
                if (myIQR > 0.0) {
                    double d = myIQR / 1.34;
                    boolean bl = false;
                    double d5 = 1.06 * Math.min(myStdD, d);
                    d = mySize;
                    double d6 = -0.2;
                    boolean bl3 = false;
                    return d5 * Math.pow(d, d6);
                }
                if (!(myStdD > 0.0)) break;
                double d = mySize;
                double d7 = -0.2;
                boolean bl = false;
                return 1.06 * myStdD * Math.pow(d, d7);
            }
        }
        return 1.0;
    }

    @NotNull
    public final Function1<Double, Double> kernel(@NotNull DensityStat.Kernel ker) {
        Function1 function1;
        Intrinsics.checkNotNullParameter((Object)((Object)ker), (String)"ker");
        switch (DensityStatUtil$WhenMappings.$EnumSwitchMapping$1[ker.ordinal()]) {
            case 1: {
                function1 = kernel.1.INSTANCE;
                break;
            }
            case 2: {
                function1 = kernel.2.INSTANCE;
                break;
            }
            case 3: {
                function1 = kernel.3.INSTANCE;
                break;
            }
            case 4: {
                function1 = kernel.4.INSTANCE;
                break;
            }
            case 5: {
                function1 = kernel.5.INSTANCE;
                break;
            }
            case 6: {
                function1 = kernel.6.INSTANCE;
                break;
            }
            default: {
                function1 = kernel.7.INSTANCE;
            }
        }
        return function1;
    }

    @NotNull
    public final Function1<Double, Double> densityFunction$plot_base_portable(@NotNull List<Double> valuesX, @NotNull Function1<? super Double, Double> ker, double bw, double ad, @NotNull List<Double> weightX) {
        Intrinsics.checkNotNullParameter(valuesX, (String)"valuesX");
        Intrinsics.checkNotNullParameter(ker, (String)"ker");
        Intrinsics.checkNotNullParameter(weightX, (String)"weightX");
        double a = bw * ad;
        return (Function1)new Function1<Double, Double>(valuesX, ker, a, weightX){
            final /* synthetic */ List $valuesX;
            final /* synthetic */ Function1 $ker;
            final /* synthetic */ double $a;
            final /* synthetic */ List $weightX;

            /*
             * WARNING - void declaration
             */
            public final double invoke(double d) {
                double sum = 0.0;
                double value = 0.0;
                int n = 0;
                int n2 = ((Collection)this.$valuesX).size();
                while (n < n2) {
                    void i;
                    E e = this.$valuesX.get((int)i);
                    Intrinsics.checkNotNull(e);
                    value = ((Number)e).doubleValue();
                    double d2 = ((Number)this.$ker.invoke((Object)((d - value) / this.$a))).doubleValue();
                    E e2 = this.$weightX.get((int)i);
                    Intrinsics.checkNotNull(e2);
                    sum += d2 * ((Number)e2).doubleValue();
                    ++i;
                }
                return sum / this.$a;
            }
            {
                this.$valuesX = list2;
                this.$ker = function1;
                this.$a = d;
                this.$weightX = list3;
                super(1);
            }
        };
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<Double> createStepValues(@NotNull ClosedRange<Double> range2, int n) {
        Intrinsics.checkNotNullParameter(range2, (String)"range");
        ArrayList<Double> x2 = new ArrayList<Double>();
        double min = ((Number)range2.getLowerEnd()).doubleValue();
        double max = ((Number)range2.getUpperEnd()).doubleValue();
        double step = 0.0;
        if (max == min) {
            max += DEF_STEP_SIZE;
            min -= DEF_STEP_SIZE;
        }
        step = (max - min) / (double)(n - 1);
        int n2 = 0;
        int n3 = n;
        while (n2 < n3) {
            void i;
            x2.add(min + step * (double)i);
            ++i;
        }
        return x2;
    }

    @NotNull
    public final DensityStat.Kernel toKernel(@NotNull String method) {
        DensityStat.Kernel kernel2;
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        switch (method) {
            case "gaussian": {
                kernel2 = DensityStat.Kernel.GAUSSIAN;
                break;
            }
            case "uniform": 
            case "rectangular": {
                kernel2 = DensityStat.Kernel.RECTANGULAR;
                break;
            }
            case "triangular": {
                kernel2 = DensityStat.Kernel.TRIANGULAR;
                break;
            }
            case "quartic": 
            case "biweight": {
                kernel2 = DensityStat.Kernel.BIWEIGHT;
                break;
            }
            case "epanechikov": 
            case "parabolic": {
                kernel2 = DensityStat.Kernel.EPANECHNIKOV;
                break;
            }
            case "optcosine": {
                kernel2 = DensityStat.Kernel.OPTCOSINE;
                break;
            }
            case "cosine": {
                kernel2 = DensityStat.Kernel.COSINE;
                break;
            }
            default: {
                throw (Throwable)new IllegalArgumentException("Unsupported kernel method: " + method);
            }
        }
        return kernel2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @NotNull
    public final DensityStat.BandWidthMethod toBandWidthMethod(@NotNull String bw) {
        DensityStat.BandWidthMethod bandWidthMethod;
        Intrinsics.checkNotNullParameter((Object)bw, (String)"bw");
        String string = bw;
        switch (string.hashCode()) {
            case 109344: {
                if (!string.equals("nrd")) throw (Throwable)new IllegalArgumentException("Unsupported bandwidth method: " + bw);
                break;
            }
            case 3389712: {
                if (!string.equals("nrd0")) throw (Throwable)new IllegalArgumentException("Unsupported bandwidth method: " + bw);
                bandWidthMethod = DensityStat.BandWidthMethod.NRD0;
                return bandWidthMethod;
            }
        }
        bandWidthMethod = DensityStat.BandWidthMethod.NRD;
        return bandWidthMethod;
        throw (Throwable)new IllegalArgumentException("Unsupported bandwidth method: " + bw);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final double[][] createRawMatrix(@NotNull List<Double> values2, @NotNull List<Double> list2, @NotNull Function1<? super Double, Double> ker, double bw, double ad, @NotNull List<Double> weight) {
        Intrinsics.checkNotNullParameter(values2, (String)"values");
        Intrinsics.checkNotNullParameter(list2, (String)"list");
        Intrinsics.checkNotNullParameter(ker, (String)"ker");
        Intrinsics.checkNotNullParameter(weight, (String)"weight");
        double a = bw * ad;
        int n = values2.size();
        int x2 = list2.size();
        double[][] dArrayArray = new double[x2][];
        int n2 = 0;
        while (n2 < x2) {
            int n3 = n2;
            int n4 = n2++;
            double[][] dArrayArray2 = dArrayArray;
            boolean bl = false;
            double[] dArray = new double[n];
            dArrayArray2[n4] = dArray;
        }
        double[][] result = dArrayArray;
        int n5 = 0;
        n2 = x2;
        while (n5 < n2) {
            void row;
            int it = 0;
            int n6 = n;
            while (it < n6) {
                void col;
                double[] dArray = result[row];
                double d = ((Number)list2.get((int)row)).doubleValue();
                Double d2 = values2.get((int)col);
                Intrinsics.checkNotNull((Object)d2);
                double d3 = ((Number)ker.invoke((Object)((d - ((Number)d2).doubleValue()) / a))).doubleValue();
                Double d4 = weight.get((int)col);
                Intrinsics.checkNotNull((Object)d4);
                double d5 = ((Number)d4).doubleValue();
                boolean bl = false;
                dArray[col] = d3 * Math.sqrt(d5) / a;
                ++col;
            }
            ++row;
        }
        return result;
    }

    private DensityStatUtil() {
    }

    static {
        DensityStatUtil densityStatUtil;
        INSTANCE = densityStatUtil = new DensityStatUtil();
        DEF_STEP_SIZE = 0.5;
    }
}

