/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.datalore.plot.base.stat;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import jetbrains.datalore.base.gcommon.collect.ClosedRange;
import jetbrains.datalore.base.geometry.DoubleVector;
import jetbrains.datalore.plot.base.Aes;
import jetbrains.datalore.plot.base.DataFrame;
import jetbrains.datalore.plot.base.StatContext;
import jetbrains.datalore.plot.base.data.TransformVar;
import jetbrains.datalore.plot.base.stat.AbstractDensity2dStat;
import jetbrains.datalore.plot.base.stat.BinStatUtil;
import jetbrains.datalore.plot.base.stat.Contour;
import jetbrains.datalore.plot.base.stat.ContourStatUtil;
import jetbrains.datalore.plot.base.stat.DensityStatUtil;
import jetbrains.datalore.plot.base.stat.Stats;
import jetbrains.datalore.plot.base.stat.math3.BlockRealMatrix;
import jetbrains.datalore.plot.common.data.SeriesUtil;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\b\u0000\u00a2\u0006\u0002\u0010\u0002J;\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u00072!\u0010\b\u001a\u001d\u0012\u0013\u0012\u00110\n\u00a2\u0006\f\b\u000b\u0012\b\b\f\u0012\u0004\b\b(\r\u0012\u0004\u0012\u00020\u000e0\tH\u0016\u00a8\u0006\u000f"}, d2={"Ljetbrains/datalore/plot/base/stat/Density2dStat;", "Ljetbrains/datalore/plot/base/stat/AbstractDensity2dStat;", "()V", "apply", "Ljetbrains/datalore/plot/base/DataFrame;", "data", "statCtx", "Ljetbrains/datalore/plot/base/StatContext;", "messageConsumer", "Lkotlin/Function1;", "", "Lkotlin/ParameterName;", "name", "s", "", "plot-base-portable"})
public final class Density2dStat
extends AbstractDensity2dStat {
    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public DataFrame apply(@NotNull DataFrame data, @NotNull StatContext statCtx, @NotNull Function1<? super String, Unit> messageConsumer) {
        double d;
        double d2;
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Intrinsics.checkNotNullParameter((Object)statCtx, (String)"statCtx");
        Intrinsics.checkNotNullParameter(messageConsumer, (String)"messageConsumer");
        if (!this.hasRequiredValues(data, Aes.Companion.getX(), Aes.Companion.getY())) {
            return this.withEmptyStatValues();
        }
        List<Double> xVector = data.getNumeric(TransformVar.INSTANCE.getX());
        List<Double> yVector = data.getNumeric(TransformVar.INSTANCE.getY());
        if (xVector.isEmpty()) {
            return DataFrame.Builder.Companion.emptyFrame();
        }
        if (xVector.size() != yVector.size()) {
            throw (Throwable)new RuntimeException("len(x)= " + xVector.size() + " and len(y)= " + yVector.size() + " doesn't match!");
        }
        ClosedRange<Double> xRange = statCtx.overallXRange();
        ClosedRange<Double> yRange = statCtx.overallYRange();
        ArrayList<Double> statX = new ArrayList<Double>();
        ArrayList<Double> statY = new ArrayList<Double>();
        ArrayList<Double> statDensity = new ArrayList<Double>();
        double[] bandWidth = new double[2];
        if (this.getBandWidths() != null) {
            double[] dArray = this.getBandWidths();
            Intrinsics.checkNotNull((Object)dArray);
            d2 = dArray[0];
        } else {
            d2 = bandWidth[0] = DensityStatUtil.INSTANCE.bandWidth(this.getBandWidthMethod(), xVector);
        }
        if (this.getBandWidths() != null) {
            double[] dArray = this.getBandWidths();
            Intrinsics.checkNotNull((Object)dArray);
            d = dArray[1];
        } else {
            d = DensityStatUtil.INSTANCE.bandWidth(this.getBandWidthMethod(), yVector);
        }
        bandWidth[1] = d;
        ClosedRange<Double> closedRange = xRange;
        Intrinsics.checkNotNull(closedRange);
        List<Double> stepsX = DensityStatUtil.INSTANCE.createStepValues(closedRange, this.getNx());
        ClosedRange<Double> closedRange2 = yRange;
        Intrinsics.checkNotNull(closedRange2);
        List<Double> stepsY = DensityStatUtil.INSTANCE.createStepValues(closedRange2, this.getNy());
        List<Double> groupWeight = BinStatUtil.INSTANCE.weightVector(xVector.size(), data);
        Function1<Double, Double> function1 = this.getKernel();
        Intrinsics.checkNotNull(function1);
        BlockRealMatrix matrixX = new BlockRealMatrix(DensityStatUtil.INSTANCE.createRawMatrix(xVector, stepsX, function1, bandWidth[0], this.getAdjust(), groupWeight));
        Function1<Double, Double> function12 = this.getKernel();
        Intrinsics.checkNotNull(function12);
        BlockRealMatrix matrixY = new BlockRealMatrix(DensityStatUtil.INSTANCE.createRawMatrix(yVector, stepsY, function12, bandWidth[1], this.getAdjust(), groupWeight));
        BlockRealMatrix matrixFinal = matrixY.multiply(matrixX.transpose());
        int n = 0;
        int n2 = this.getNy();
        while (n < n2) {
            void row;
            int n3 = 0;
            int n4 = this.getNx();
            while (n3 < n4) {
                void col;
                statX.add(stepsX.get((int)col));
                statY.add(stepsY.get((int)row));
                statDensity.add(matrixFinal.getEntry((int)row, (int)col) / SeriesUtil.INSTANCE.sum(groupWeight));
                ++col;
            }
            ++row;
        }
        if (this.isContour()) {
            ClosedRange<Double> zRange = SeriesUtil.INSTANCE.range((Iterable<Double>)statDensity);
            List<Double> list2 = ContourStatUtil.INSTANCE.computeLevels(zRange, this.getBinOptions());
            if (list2 == null) {
                return DataFrame.Builder.Companion.emptyFrame();
            }
            List<Double> levels = list2;
            Map<Double, List<List<DoubleVector>>> pathListByLevel = ContourStatUtil.INSTANCE.computeContours(xRange, yRange, this.getNx(), this.getNy(), (List<Double>)statDensity, levels);
            return Contour.Companion.getPathDataFrame(levels, pathListByLevel);
        }
        return new DataFrame.Builder().putNumeric(Stats.INSTANCE.getX(), (List<Double>)statX).putNumeric(Stats.INSTANCE.getY(), (List<Double>)statY).putNumeric(Stats.INSTANCE.getDENSITY(), (List<Double>)statDensity).build();
    }
}

