/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.datalore.plot.base.stat;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import jetbrains.datalore.plot.base.Aes;
import jetbrains.datalore.plot.base.DataFrame;
import jetbrains.datalore.plot.base.StatContext;
import jetbrains.datalore.plot.base.stat.BaseStat;
import jetbrains.datalore.plot.base.stat.CorrelationStat;
import jetbrains.datalore.plot.base.stat.CorrelationUtil;
import jetbrains.datalore.plot.base.stat.Stats;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u001e2\u00020\u0001:\u0003\u001e\u001f B\u0005\u00a2\u0006\u0002\u0010\u0002J;\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u00132!\u0010\u0014\u001a\u001d\u0012\u0013\u0012\u00110\u0016\u00a2\u0006\f\b\u0017\u0012\b\b\u0018\u0012\u0004\b\b(\u0019\u0012\u0004\u0012\u00020\u001a0\u0015H\u0016J\u0012\u0010\u001b\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u001d0\u001cH\u0016R\u001a\u0010\u0003\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000e\u00a8\u0006!"}, d2={"Ljetbrains/datalore/plot/base/stat/CorrelationStat;", "Ljetbrains/datalore/plot/base/stat/BaseStat;", "()V", "correlationMethod", "Ljetbrains/datalore/plot/base/stat/CorrelationStat$Method;", "getCorrelationMethod", "()Ljetbrains/datalore/plot/base/stat/CorrelationStat$Method;", "setCorrelationMethod", "(Ljetbrains/datalore/plot/base/stat/CorrelationStat$Method;)V", "type", "Ljetbrains/datalore/plot/base/stat/CorrelationStat$Type;", "getType", "()Ljetbrains/datalore/plot/base/stat/CorrelationStat$Type;", "setType", "(Ljetbrains/datalore/plot/base/stat/CorrelationStat$Type;)V", "apply", "Ljetbrains/datalore/plot/base/DataFrame;", "data", "statCtx", "Ljetbrains/datalore/plot/base/StatContext;", "messageConsumer", "Lkotlin/Function1;", "", "Lkotlin/ParameterName;", "name", "s", "", "consumes", "", "Ljetbrains/datalore/plot/base/Aes;", "Companion", "Method", "Type", "plot-base-portable"})
public final class CorrelationStat
extends BaseStat {
    @NotNull
    private Method correlationMethod = DEF_CORRELATION_METHOD;
    @NotNull
    private Type type = DEF_TYPE;
    private static final Map<Aes<?>, DataFrame.Variable> DEF_MAPPING;
    private static final Method DEF_CORRELATION_METHOD;
    private static final Type DEF_TYPE;
    public static final Companion Companion;

    @NotNull
    public final Method getCorrelationMethod() {
        return this.correlationMethod;
    }

    public final void setCorrelationMethod(@NotNull Method method) {
        Intrinsics.checkNotNullParameter((Object)((Object)method), (String)"<set-?>");
        this.correlationMethod = method;
    }

    @NotNull
    public final Type getType() {
        return this.type;
    }

    public final void setType(@NotNull Type type) {
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"<set-?>");
        this.type = type;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public DataFrame apply(@NotNull DataFrame data, @NotNull StatContext statCtx, @NotNull Function1<? super String, Unit> messageConsumer) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Intrinsics.checkNotNullParameter((Object)statCtx, (String)"statCtx");
        Intrinsics.checkNotNullParameter(messageConsumer, (String)"messageConsumer");
        if (this.correlationMethod != Method.PEARSON) {
            throw (Throwable)new IllegalArgumentException("Unsupported correlation method: " + (Object)((Object)this.correlationMethod) + " (only pearson is currently available)");
        }
        DataFrame cm2 = CorrelationUtil.INSTANCE.correlationMatrix(data, this.type, (Function2<? super double[], ? super double[], Double>)((Function2)apply.cm.1.INSTANCE));
        List<Double> vals = cm2.getNumeric(Stats.INSTANCE.getCORR());
        Iterable $this$map$iv = vals;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Double d = (Double)item$iv$iv;
            Collection collection2 = destination$iv$iv;
            boolean bl = false;
            void v0 = it;
            Intrinsics.checkNotNull((Object)v0);
            double d2 = v0.doubleValue();
            boolean bl2 = false;
            Double d3 = Math.abs(d2);
            collection2.add(d3);
        }
        List abs = (List)destination$iv$iv;
        return cm2.builder().putNumeric(Stats.INSTANCE.getCORR_ABS(), abs).build();
    }

    @Override
    @NotNull
    public List<Aes<?>> consumes() {
        boolean bl = false;
        return CollectionsKt.emptyList();
    }

    public CorrelationStat() {
        super(DEF_MAPPING);
    }

    static {
        Companion = new Companion(null);
        DEF_MAPPING = MapsKt.mapOf((Pair[])new Pair[]{TuplesKt.to(Aes.Companion.getX(), (Object)Stats.INSTANCE.getX()), TuplesKt.to(Aes.Companion.getY(), (Object)Stats.INSTANCE.getY()), TuplesKt.to(Aes.Companion.getCOLOR(), (Object)Stats.INSTANCE.getCORR()), TuplesKt.to(Aes.Companion.getSIZE(), (Object)Stats.INSTANCE.getCORR_ABS()), TuplesKt.to(Aes.Companion.getLABEL(), (Object)Stats.INSTANCE.getCORR())});
        DEF_CORRELATION_METHOD = Method.PEARSON;
        DEF_TYPE = Type.FULL;
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Ljetbrains/datalore/plot/base/stat/CorrelationStat$Method;", "", "(Ljava/lang/String;I)V", "PEARSON", "SPEARMAN", "KENDALL", "plot-base-portable"})
    public static final class Method
    extends Enum<Method> {
        public static final /* enum */ Method PEARSON;
        public static final /* enum */ Method SPEARMAN;
        public static final /* enum */ Method KENDALL;
        private static final /* synthetic */ Method[] $VALUES;

        static {
            Method[] methodArray = new Method[3];
            Method[] methodArray2 = methodArray;
            methodArray[0] = PEARSON = new Method();
            methodArray[1] = SPEARMAN = new Method();
            methodArray[2] = KENDALL = new Method();
            $VALUES = methodArray;
        }

        public static Method[] values() {
            return (Method[])$VALUES.clone();
        }

        public static Method valueOf(String string) {
            return Enum.valueOf(Method.class, string);
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Ljetbrains/datalore/plot/base/stat/CorrelationStat$Type;", "", "(Ljava/lang/String;I)V", "FULL", "UPPER", "LOWER", "plot-base-portable"})
    public static final class Type
    extends Enum<Type> {
        public static final /* enum */ Type FULL;
        public static final /* enum */ Type UPPER;
        public static final /* enum */ Type LOWER;
        private static final /* synthetic */ Type[] $VALUES;

        static {
            Type[] typeArray = new Type[3];
            Type[] typeArray2 = typeArray;
            typeArray[0] = FULL = new Type();
            typeArray[1] = UPPER = new Type();
            typeArray[2] = LOWER = new Type();
            $VALUES = typeArray;
        }

        public static Type[] values() {
            return (Type[])$VALUES.clone();
        }

        public static Type valueOf(String string) {
            return Enum.valueOf(Type.class, string);
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0005\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0007\u0012\u0004\u0012\u00020\b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Ljetbrains/datalore/plot/base/stat/CorrelationStat$Companion;", "", "()V", "DEF_CORRELATION_METHOD", "Ljetbrains/datalore/plot/base/stat/CorrelationStat$Method;", "DEF_MAPPING", "", "Ljetbrains/datalore/plot/base/Aes;", "Ljetbrains/datalore/plot/base/DataFrame$Variable;", "DEF_TYPE", "Ljetbrains/datalore/plot/base/stat/CorrelationStat$Type;", "plot-base-portable"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

